/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.restrict;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import thredds.servlet.ServletUtil;
import thredds.servlet.restrict.Authorizer;
import thredds.servlet.restrict.RoleSource;

public class TomcatAuthorizer
implements Authorizer {
    private boolean useSSL = false;
    private String sslPort = "8443";
    private boolean debugResourceControl = false;

    public boolean authorize(HttpServletRequest req, HttpServletResponse res, String role) throws IOException {
        String urlr;
        if (req.isUserInRole(role)) {
            return true;
        }
        HttpSession session = req.getSession();
        session.setAttribute("origRequest", (Object)ServletUtil.getRequest(req));
        session.setAttribute("role", (Object)role);
        String context = ServletUtil.getContextPath();
        String string = urlr = this.useSSL ? "https://" + req.getServerName() + ":" + this.sslPort + context + "/restrictedAccess/" + role : "http://" + req.getServerName() + ":" + req.getServerPort() + context + "/restrictedAccess/" + role;
        if (this.debugResourceControl) {
            System.out.println("redirect to = " + urlr);
        }
        res.setStatus(307);
        res.addHeader("Location", urlr);
        res.setHeader("Last-Modified", "");
        return false;
    }

    public void init(HttpServlet servlet) throws ServletException {
        String s = servlet.getInitParameter("useSSL");
        if (null != s) {
            this.useSSL = Boolean.valueOf(s);
        }
        if (null != (s = servlet.getInitParameter("portSSL"))) {
            this.sslPort = s;
        }
    }

    public void setRoleSource(RoleSource db) {
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletUtil.logServerAccessSetup(req);
        HttpSession session = req.getSession();
        if (session != null) {
            String origURI = (String)session.getAttribute("origRequest");
            String role = (String)session.getAttribute("role");
            if (this.debugResourceControl) {
                System.out.println("ResourceControl: " + ServletUtil.showSecurity(req, role));
            }
            if (req.isUserInRole(role)) {
                if (origURI != null) {
                    if (this.debugResourceControl) {
                        System.out.println("redirect to origRequest = " + origURI);
                    }
                    res.setStatus(307);
                    String frag = origURI.indexOf("?") > 0 ? "&auth" : "?auth";
                    res.addHeader("Location", origURI + frag);
                    return;
                }
                res.setStatus(200);
                return;
            }
        } else if (this.debugResourceControl) {
            System.out.println("ResourceControl: no session established");
        }
        res.sendError(401, "Not authorized to access this dataset.");
    }
}

