/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.servlet.AbstractServlet;
import thredds.servlet.DatasetHandler;
import thredds.servlet.Debug;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import thredds.wcs.GetCoverageRequest;
import thredds.wcs.SectionType;
import thredds.wcs.WcsDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.util.DiskCache2;

public class WCSServlet
extends AbstractServlet {
    private DiskCache2 diskCache = null;
    private boolean allow = false;
    private boolean deleteImmediately = true;
    private long maxFileDownloadSize;

    protected String getPath() {
        return "wcs/";
    }

    protected void makeDebugActions() {
    }

    public void init() throws ServletException {
        super.init();
        this.allow = ThreddsConfig.getBoolean("WCS.allow", false);
        this.maxFileDownloadSize = ThreddsConfig.getBytes("WCS.maxFileDownloadSize", 1000000000L);
        String cache = ThreddsConfig.get("WCS.dir", this.contentPath + "/wcache");
        File cacheDir = new File(cache);
        cacheDir.mkdirs();
        int scourSecs = ThreddsConfig.getSeconds("WCS.scour", 600);
        int maxAgeSecs = ThreddsConfig.getSeconds("WCS.maxAge", -1);
        maxAgeSecs = Math.max(maxAgeSecs, 300);
        scourSecs = Math.max(scourSecs, 300);
        this.diskCache = new DiskCache2(cache, false, maxAgeSecs / 60, scourSecs / 60);
        WcsDataset.setDiskCache((DiskCache2)this.diskCache);
    }

    public void destroy() {
        if (this.diskCache != null) {
            this.diskCache.exit();
        }
        super.destroy();
    }

    private WcsDataset openWcsDataset(HttpServletRequest req, HttpServletResponse res) throws IOException {
        GridDataset gd;
        String datasetURL = ServletUtil.getParameterIgnoreCase(req, "dataset");
        boolean isRemote = datasetURL != null;
        String datasetPath = isRemote ? datasetURL : req.getPathInfo();
        Object object = gd = isRemote ? GridDataset.open((String)datasetPath) : DatasetHandler.openGridDataset(req, res, datasetPath);
        if (gd == null) {
            return null;
        }
        WcsDataset ds = new WcsDataset((ucar.nc2.dt.GridDataset)gd, datasetPath, isRemote);
        String setServerBase = ServletUtil.getRequestBase(req);
        ds.setServerBase(setServerBase);
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block65: {
            if (!this.allow) {
                res.sendError(403, "Service not supported");
                return;
            }
            ServletUtil.logServerAccessSetup(req);
            if (Debug.isSet("showRequest")) {
                this.log.debug("**WCS req=" + ServletUtil.getRequest(req));
            }
            if (Debug.isSet("showRequestDetail")) {
                this.log.debug(ServletUtil.showRequestDetail(this, req));
            }
            WcsDataset wcsDataset = null;
            try {
                String request = ServletUtil.getParameterIgnoreCase(req, "REQUEST");
                if (request == null) {
                    this.makeServiceException(res, "MissingParameterValue", "REQUEST parameter missing");
                    ServletUtil.logServerAccess(400, -1L);
                    return;
                }
                wcsDataset = this.openWcsDataset(req, res);
                if (wcsDataset == null) {
                    return;
                }
                if (request.equals("GetCapabilities")) {
                    SectionType sectionType = null;
                    String section = ServletUtil.getParameterIgnoreCase(req, "SECTION");
                    if (section != null && (sectionType = SectionType.getType((String)section)) == null) {
                        this.makeServiceException(res, "InvalidParameterValue", "Unknown GetCapabilities section = " + section);
                        return;
                    }
                    ServletOutputStream os = res.getOutputStream();
                    res.setContentType("text/xml");
                    res.setStatus(200);
                    int len = wcsDataset.getCapabilities((OutputStream)os, sectionType);
                    ServletUtil.logServerAccess(200, len);
                    os.flush();
                    break block65;
                }
                if (request.equals("DescribeCoverage")) {
                    String[] coverages = ServletUtil.getParameterValuesIgnoreCase(req, "COVERAGE");
                    if (coverages != null) {
                        for (int i = 0; i < coverages.length; ++i) {
                            if (wcsDataset.hasCoverage(coverages[i])) continue;
                            this.makeServiceException(res, "CoverageNotDefined", "Unknown Coverage = " + coverages[i]);
                            return;
                        }
                    }
                    ServletOutputStream os = res.getOutputStream();
                    res.setContentType("text/xml");
                    res.setStatus(200);
                    int len = wcsDataset.describeCoverage((OutputStream)os, coverages);
                    ServletUtil.logServerAccess(200, len);
                    os.flush();
                    break block65;
                }
                if (request.equals("GetCoverage")) {
                    GetCoverageRequest r;
                    String coverage = ServletUtil.getParameterIgnoreCase(req, "COVERAGE");
                    if (!wcsDataset.hasCoverage(coverage)) {
                        this.makeServiceException(res, "CoverageNotDefined", "Unknown Coverage = " + coverage);
                        return;
                    }
                    String bbox = ServletUtil.getParameterIgnoreCase(req, "BBOX");
                    String time = ServletUtil.getParameterIgnoreCase(req, "TIME");
                    String vertical = ServletUtil.getParameterIgnoreCase(req, "Vertical");
                    String format = ServletUtil.getParameterIgnoreCase(req, "FORMAT");
                    try {
                        r = new GetCoverageRequest(coverage, bbox, time, vertical, format);
                    }
                    catch (Exception e) {
                        this.makeServiceException(res, "InvalidParameterValue", "query=" + req.getQueryString());
                        if (wcsDataset != null) {
                            try {
                                wcsDataset.close();
                            }
                            catch (IOException ioe) {
                                this.log.error("Failed to close ", (Throwable)ioe);
                            }
                        }
                        return;
                    }
                    if (r.getFormat() == null || r.getFormat() == GetCoverageRequest.Format.NONE) {
                        this.makeServiceException(res, "InvalidFormat", "Invalid Format = " + format);
                        return;
                    }
                    String errMessage = wcsDataset.checkCoverageParameters(r);
                    if (null != errMessage) {
                        this.makeServiceException(res, "InvalidParameterValue", errMessage);
                        return;
                    }
                    File result = wcsDataset.getCoverage(r);
                    int pos = result.getPath().lastIndexOf(".");
                    String suffix = result.getPath().substring(pos);
                    String resultFilename = wcsDataset.getDatasetName();
                    if (!resultFilename.endsWith(suffix)) {
                        resultFilename = resultFilename + suffix;
                    }
                    res.setHeader("Content-Disposition", "attachment; filename=" + resultFilename);
                    ServletUtil.returnFile(this, "", result.getPath(), req, res, null);
                    if (this.deleteImmediately) {
                        result.delete();
                    }
                    break block65;
                }
                this.makeServiceException(res, "InvalidParameterValue", "Unknown request=" + request);
                return;
            }
            catch (IOException ioe) {
                this.makeServiceException(res, "Invalid Dataset", ioe);
                return;
            }
            catch (SecurityException e) {
                this.makeServiceException(res, "Restricted Dataset", e);
                return;
            }
            catch (Throwable t) {
                this.makeServiceException(res, "Server Error", t);
                t.printStackTrace();
                return;
            }
            finally {
                if (wcsDataset != null) {
                    try {
                        wcsDataset.close();
                    }
                    catch (IOException ioe) {
                        this.log.error("Failed to close ", (Throwable)ioe);
                    }
                }
            }
        }
    }

    private void makeServiceException(HttpServletResponse res, String code, String message) throws IOException {
        res.setContentType("application/vnd.ogc.se_xml");
        PrintStream ps = new PrintStream((OutputStream)res.getOutputStream());
        ps.println("<ServiceExceptionReport version='1.2.0'>");
        ps.println("  <ServiceException code='" + code + "'>");
        ps.println("    " + message);
        ps.println("  </ServiceException>");
        ps.println("</ServiceExceptionReport>");
        ps.flush();
        ServletUtil.logServerAccess(400, -1L);
    }

    private void makeServiceException(HttpServletResponse res, String code, Throwable t) throws IOException {
        res.setContentType("application/vnd.ogc.se_xml");
        PrintStream ps = new PrintStream((OutputStream)res.getOutputStream());
        ps.println("<ServiceExceptionReport version='1.2.0'>");
        ps.println("  <ServiceException code='" + code + "'>");
        if (Debug.isSet("trustedMode")) {
            t.printStackTrace(ps);
        } else {
            ps.println(t.getMessage());
        }
        ps.println("  </ServiceException>");
        ps.println("</ServiceExceptionReport>");
        ps.flush();
        if (t instanceof FileNotFoundException) {
            this.log.info("makeServiceException", (Object)t.getMessage());
        } else {
            this.log.info("makeServiceException", t);
        }
        ServletUtil.logServerAccess(400, -1L);
    }
}

