/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.BooleanPrimitiveVector;
import dods.dap.ClientIO;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class DBoolean
extends BaseType
implements ClientIO {
    private boolean val;

    public DBoolean() {
    }

    public DBoolean(String n) {
        super(n);
    }

    public final boolean getValue() {
        return this.val;
    }

    public final void setValue(boolean newVal) {
        this.val = newVal;
    }

    public PrimitiveVector newPrimitiveVector() {
        return new BooleanPrimitiveVector(this);
    }

    public String getTypeName() {
        return "Boolean";
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.println(" = " + this.val + ";");
        } else {
            os.print(this.val);
        }
    }

    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException {
        this.val = source.readBoolean();
        if (statusUI != null) {
            statusUI.incrementByteCount(1);
        }
    }

    public void externalize(DataOutputStream sink) throws IOException {
        sink.writeBoolean(this.val);
    }
}

