/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseTypeFactory;
import dods.dap.DAS;
import dods.dap.DASException;
import dods.dap.DDS;
import dods.dap.DDSException;
import dods.dap.DODSException;
import dods.dap.DataDDS;
import dods.dap.DefaultFactory;
import dods.dap.HeaderInputStream;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import dods.dap.parser.ParseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.InflaterInputStream;

public class DConnect {
    private boolean dumpStream = false;
    private boolean dumpDAS = false;
    private InputStream fileStream;
    private URLConnection connection;
    private String urlString;
    private String projString;
    private String selString;
    private boolean acceptDeflate;
    private ServerVersion ver;

    public DConnect(String urlString) throws FileNotFoundException {
        this(urlString, true);
    }

    public DConnect(String urlString, boolean acceptDeflate) throws FileNotFoundException {
        int ceIndex = urlString.indexOf(63);
        if (ceIndex != -1) {
            this.urlString = urlString.substring(0, ceIndex);
            String expr = urlString.substring(ceIndex);
            int selIndex = expr.indexOf(38);
            if (selIndex != -1) {
                this.projString = expr.substring(0, selIndex);
                this.selString = expr.substring(selIndex);
            } else {
                this.projString = expr;
                this.selString = "";
            }
        } else {
            this.urlString = urlString;
            this.selString = "";
            this.projString = "";
        }
        this.acceptDeflate = acceptDeflate;
        try {
            URL testURL = new URL(urlString);
        }
        catch (MalformedURLException e) {
            this.fileStream = new FileInputStream(urlString);
        }
    }

    public DConnect(InputStream is) {
        this.fileStream = is;
    }

    public final boolean isLocal() {
        return this.fileStream != null;
    }

    public final String CE() {
        return this.projString + this.selString;
    }

    public final String URL() {
        return this.urlString;
    }

    private InputStream openConnection(URL url) throws IOException, DODSException {
        this.connection = url.openConnection();
        if (this.acceptDeflate) {
            this.connection.setRequestProperty("Accept-Encoding", "deflate");
        }
        this.connection.connect();
        InputStream is = null;
        int retry = 1;
        long backoff = 100L;
        while (true) {
            try {
                is = this.connection.getInputStream();
                break;
            }
            catch (NullPointerException e) {
                System.out.println("DConnect NullPointer; retry open (" + retry + ") " + url);
                try {
                    Thread.currentThread();
                    Thread.sleep(backoff);
                }
                catch (InterruptedException ie) {}
            }
            catch (FileNotFoundException e) {
                System.out.println("DConnect FileNotFound; retry open (" + retry + ") " + url);
                try {
                    Thread.currentThread();
                    Thread.sleep(backoff);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            if (retry == 3) {
                throw new DODSException("Connection cannot be opened");
            }
            ++retry;
            backoff *= 2L;
        }
        String type = this.connection.getHeaderField("content-description");
        this.handleContentDesc(is, type);
        this.ver = new ServerVersion(this.connection.getHeaderField("xdods-server"));
        String encoding = this.connection.getContentEncoding();
        return this.handleContentEncoding(is, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DAS getDAS() throws MalformedURLException, IOException, ParseException, DASException, DODSException {
        InputStream is;
        if (this.fileStream != null) {
            is = this.parseMime(this.fileStream);
        } else {
            URL url = new URL(this.urlString + ".das" + this.projString + this.selString);
            if (this.dumpDAS) {
                System.out.println("--DConnect.getDAS to " + url);
                this.copy(url.openStream(), System.out);
                System.out.println("\n--DConnect.getDAS END1");
                this.dumpBytes(url.openStream(), 100);
                System.out.println("\n-DConnect.getDAS END2");
            }
            is = this.openConnection(url);
        }
        DAS das = new DAS();
        try {
            das.parse(is);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            is.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
            throw throwable;
        }
        is.close();
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).disconnect();
        }
        return das;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDS getDDS() throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        InputStream is;
        if (this.fileStream != null) {
            is = this.parseMime(this.fileStream);
        } else {
            URL url = new URL(this.urlString + ".dds" + this.projString + this.selString);
            is = this.openConnection(url);
        }
        DDS dds = new DDS();
        try {
            dds.parse(is);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            is.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
            throw throwable;
        }
        is.close();
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).disconnect();
        }
        return dds;
    }

    public DataDDS getData(String CE, StatusUI statusUI, BaseTypeFactory btf) throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        String localSelString;
        String localProjString;
        if (this.fileStream != null) {
            return this.getDataFromFileStream(this.fileStream, statusUI, btf);
        }
        int selIndex = CE.indexOf(38);
        if (selIndex != -1) {
            localProjString = CE.substring(0, selIndex);
            localSelString = CE.substring(selIndex);
        } else {
            localProjString = CE;
            localSelString = "";
        }
        URL url = new URL(this.urlString + ".dods" + this.projString + localProjString + this.selString + localSelString);
        String errorMsg = "DConnect getData failed " + url;
        int errorCode = 0;
        int retry = 1;
        long backoff = 100L;
        while (true) {
            try {
                return this.getDataFromUrl(url, statusUI, btf);
            }
            catch (DODSException e) {
                System.out.println("DConnect getData failed; retry (" + retry + "," + backoff + ") " + url);
                errorMsg = e.getErrorMessage();
                errorCode = e.getErrorCode();
                try {
                    Thread.currentThread();
                    Thread.sleep(backoff);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (retry == 5) {
                    throw new DODSException(errorCode, errorMsg);
                }
                ++retry;
                backoff *= 2L;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataDDS getDataFromFileStream(InputStream fileStream, StatusUI statusUI, BaseTypeFactory btf) throws IOException, ParseException, DDSException, DODSException {
        InputStream is = this.parseMime(fileStream);
        DataDDS dds = new DataDDS(this.ver, btf);
        try {
            dds.parse(new HeaderInputStream(is));
            dds.readData(is, statusUI);
        }
        finally {
            is.close();
        }
        return dds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataDDS getDataFromUrl(URL url, StatusUI statusUI, BaseTypeFactory btf) throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        InputStream is = this.openConnection(url);
        DataDDS dds = new DataDDS(this.ver, btf);
        ByteArrayInputStream bis = null;
        if (this.dumpStream) {
            System.out.println("DConnect to " + url);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.copy(is, bos);
            bis = new ByteArrayInputStream(bos.toByteArray());
            is = bis;
        }
        try {
            try {
                if (this.dumpStream) {
                    bis.mark(1000);
                    System.out.println("DConnect parse header: ");
                    this.dump(bis);
                    bis.reset();
                }
                dds.parse(new HeaderInputStream(is));
                if (this.dumpStream) {
                    bis.mark(20);
                    System.out.println("DConnect done with header, next bytes are: ");
                    this.dumpBytes(bis, 20);
                    bis.reset();
                }
                dds.readData(is, statusUI);
            }
            catch (Exception e) {
                System.out.println("DConnect dds.parse: " + url + "\n " + e);
                e.printStackTrace();
                throw new DODSException("Connection cannot be read " + url);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            is.close();
            if (!(this.connection instanceof HttpURLConnection)) throw throwable;
            ((HttpURLConnection)this.connection).disconnect();
            throw throwable;
        }
        is.close();
        if (!(this.connection instanceof HttpURLConnection)) return dds;
        ((HttpURLConnection)this.connection).disconnect();
        return dds;
    }

    private void copy(InputStream in, OutputStream out) {
        try {
            int bytesRead;
            byte[] buffer = new byte[256];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void dump(InputStream is) throws IOException {
        DataInputStream d = new DataInputStream(is);
        try {
            String line;
            System.out.println("dump lines avail=" + is.available());
            do {
                line = d.readLine();
                System.out.println(line);
                if (null != line) continue;
                return;
            } while (!line.equals("Data:"));
            System.out.println("dump bytes avail=" + is.available());
            this.dumpBytes(is, 20);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private void dumpBytes(InputStream is, int n) {
        try {
            DataInputStream d = new DataInputStream(is);
            for (int count = 0; count < n && d.available() > 0; ++count) {
                System.out.println(count + " " + d.readByte());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DataDDS getData(String CE, StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        return this.getData(CE, statusUI, new DefaultFactory());
    }

    public final DataDDS getData(StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        return this.getData("", statusUI, new DefaultFactory());
    }

    public final ServerVersion getServerVersion() {
        return this.ver;
    }

    private InputStream parseMime(InputStream is) throws IOException, DODSException {
        String line;
        DataInputStream d = new DataInputStream(is);
        String description = null;
        String encoding = null;
        while (!(line = d.readLine()).equals("")) {
            int spaceIndex = line.indexOf(32);
            if (spaceIndex == -1) continue;
            String header = line.substring(0, spaceIndex);
            String value = line.substring(spaceIndex + 1);
            if (header.equals("Server:")) {
                this.ver = new ServerVersion(value);
                continue;
            }
            if (header.equals("Content-Description:")) {
                description = value;
                continue;
            }
            if (!header.equals("Content-Encoding:")) continue;
            encoding = value;
        }
        this.handleContentDesc(is, description);
        return this.handleContentEncoding(is, encoding);
    }

    private void handleContentDesc(InputStream is, String type) throws IOException, DODSException {
        if (type != null && type.equals("dods_error")) {
            DODSException ds = new DODSException();
            ds.parse(is);
            throw ds;
        }
    }

    private InputStream handleContentEncoding(InputStream is, String encoding) {
        if (encoding != null && encoding.equals("deflate")) {
            return new InflaterInputStream(is);
        }
        return is;
    }
}

