/*
 * Decompiled with CFR 0.152.
 */
package dods.servlet;

import dods.dap.DODSException;
import dods.dap.parser.ParseException;
import dods.servlet.ReqState;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class dodsDIR {
    private static final boolean _Debug = false;

    public void sendDIR(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws DODSException, ParseException {
        String ddsCacheDir = rs.getInitParameter("DDScache");
        if (ddsCacheDir == null) {
            ddsCacheDir = rs.getDDSCache();
        }
        File ddsDir = new File(ddsCacheDir);
        String separator = "/";
        try {
            PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
            if (ddsDir.exists()) {
                if (ddsDir.isDirectory()) {
                    String thisServer = request.getRequestURL().toString();
                    if (thisServer.lastIndexOf(separator) != thisServer.length() - 1) {
                        thisServer = thisServer + separator;
                    }
                    pw.println("<html>");
                    pw.println("<head>");
                    pw.println("<title>DODS Directory</title>");
                    pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
                    pw.println("</head>");
                    pw.println("<body bgcolor=\"#FFFFFF\">");
                    pw.println("<h1>DODS Directory for:</h1>");
                    pw.println("<h2>" + thisServer + "</h2>");
                    pw.println("<hr>");
                    File[] fList = ddsDir.listFiles();
                    pw.println("<table border=\"0\">");
                    for (int i = 0; i < fList.length; ++i) {
                        if (!fList[i].isFile()) continue;
                        pw.println("<tr>");
                        pw.print("    <td>");
                        pw.print("<div align='right'>");
                        pw.print("<b>" + fList[i].getName() + ":</b> ");
                        pw.print("</div>");
                        pw.println("</td>");
                        pw.print("    <td>");
                        pw.print("<div align='center'>");
                        pw.print("<a href='" + thisServer + fList[i].getName() + ".dds'> DDS </a>");
                        pw.print("</div>");
                        pw.println("</td>");
                        pw.print("    <td>");
                        pw.print("<div align='center'>");
                        pw.print("<a href='" + thisServer + fList[i].getName() + ".das'> DAS </a>");
                        pw.print("</div>");
                        pw.println("</td>");
                        pw.print("    <td>");
                        pw.print("<div align='center'>");
                        pw.print("<a href='" + thisServer + fList[i].getName() + ".info'> Information </a>");
                        pw.print("</div>");
                        pw.println("</td>");
                        pw.print("    <td>");
                        pw.print("<div align='center'>");
                        pw.print("<a href='" + thisServer + fList[i].getName() + ".html'> HTML Data Request Form </a>");
                        pw.print("</div>");
                        pw.println("</td>");
                        pw.println("</tr>");
                    }
                    pw.println("</table>");
                    pw.println("<hr>");
                    pw.println("</html>");
                } else {
                    pw.println("<hr>");
                    pw.println("<h1>");
                    pw.println("Specified DDS cache:</h1>");
                    pw.println("<h2><i>" + ddsCacheDir + "</i></h2>");
                    pw.println("not a directory!");
                    pw.println("</h1>");
                    pw.println("<hr>");
                }
            } else {
                pw.println("<hr>");
                pw.println("<h1>Cannot Find DDS Directory:<br></h1>");
                pw.println("<h2><i>" + ddsCacheDir + "</i></h2>");
                pw.println("<hr>");
            }
            pw.flush();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("OUCH! FileNotFoundException: " + fnfe.getMessage());
            fnfe.printStackTrace(System.out);
        }
        catch (IOException ioe) {
            System.out.println("OUCH! IOException: " + ioe.getMessage());
            ioe.printStackTrace(System.out);
        }
    }
}

