/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.Flagged;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.Option;
import com.martiansoftware.jsap.StringParser;

public class FlaggedOption
extends Option
implements Flagged {
    private char shortFlag = '\u0000';
    private String longFlag = JSAP.NO_LONGFLAG;
    private boolean allowMultipleDeclarations = false;

    public FlaggedOption(String string) {
        super(string);
    }

    public FlaggedOption(String string, StringParser stringParser, String string2, boolean bl, char c, String string3) {
        this(string);
        this.setStringParser(stringParser);
        this.setDefault(string2);
        this.setShortFlag(c);
        this.setLongFlag(string3);
        this.setRequired(bl);
    }

    public FlaggedOption setShortFlag(char c) {
        this.enforceParameterLock();
        this.shortFlag = c;
        return this;
    }

    public char getShortFlag() {
        return this.shortFlag;
    }

    public Character getShortFlagCharacter() {
        return this.shortFlag == '\u0000' ? null : new Character(this.shortFlag);
    }

    public FlaggedOption setLongFlag(String string) {
        this.enforceParameterLock();
        this.longFlag = string;
        return this;
    }

    public String getLongFlag() {
        return this.longFlag;
    }

    public FlaggedOption setAllowMultipleDeclarations(boolean bl) {
        this.enforceParameterLock();
        this.allowMultipleDeclarations = bl;
        return this;
    }

    public boolean allowMultipleDeclarations() {
        return this.allowMultipleDeclarations;
    }

    public String getSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.required()) {
            stringBuffer.append("[");
        }
        if (this.getLongFlag() != JSAP.NO_LONGFLAG || this.getShortFlag() != '\u0000') {
            if (this.getLongFlag() == JSAP.NO_LONGFLAG) {
                stringBuffer.append("-" + this.getShortFlag() + " ");
            } else if (this.getShortFlag() == '\u0000') {
                stringBuffer.append("--" + this.getLongFlag() + " ");
            } else {
                stringBuffer.append("(-" + this.getShortFlag() + "|--" + this.getLongFlag() + ") ");
            }
        }
        String string = this.getID();
        char c = this.getListSeparator();
        if (this.isList()) {
            stringBuffer.append(string + "1" + c + string + "2" + c + "..." + c + string + "N ");
        } else {
            stringBuffer.append("<" + string + ">");
        }
        if (!this.required()) {
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public FlaggedOption setList(boolean bl) {
        super.internalSetList(bl);
        return this;
    }

    public FlaggedOption setListSeparator(char c) {
        super.internalSetListSeparator(c);
        return this;
    }

    public FlaggedOption setRequired(boolean bl) {
        super.internalSetRequired(bl);
        return this;
    }

    public FlaggedOption setDefault(String[] stringArray) {
        this._setDefault(stringArray);
        return this;
    }

    public FlaggedOption setDefault(String string) {
        this._setDefault(string);
        return this;
    }

    public FlaggedOption setStringParser(StringParser stringParser) {
        super.internalSetStringParser(stringParser);
        return this;
    }
}

