/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.AbstractParameter;
import com.martiansoftware.jsap.CommandLineTokenizer;
import com.martiansoftware.jsap.DefaultSource;
import com.martiansoftware.jsap.Defaults;
import com.martiansoftware.jsap.ExceptionMap;
import com.martiansoftware.jsap.Flagged;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.IDMap;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Option;
import com.martiansoftware.jsap.Parser;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSAP {
    private Map paramsByID = new HashMap();
    private Map paramsByShortFlag = new HashMap();
    private Map paramsByLongFlag = new HashMap();
    private List unflaggedOptions = new ArrayList();
    private List paramsByDeclarationOrder = new ArrayList();
    private List defaultSources = new ArrayList();
    private String usage = null;
    private String help = null;
    public static final char NO_SHORTFLAG = '\u0000';
    public static final String NO_LONGFLAG = null;
    public static final char DEFAULT_LISTSEPARATOR = File.pathSeparatorChar;
    public static final boolean REQUIRED = true;
    public static final boolean NOT_REQUIRED = false;
    public static final boolean LIST = true;
    public static final boolean NOT_LIST = false;
    public static final boolean MULTIPLEDECLARATIONS = true;
    public static final boolean NO_MULTIPLEDECLARATIONS = false;
    public static final boolean GREEDY = true;
    public static final boolean NOT_GREEDY = false;
    public static final String NO_DEFAULT = null;
    private static final int DEFAULT_SCREENWIDTH = 80;

    public void setUsage(String string) {
        this.usage = string;
    }

    public void setHelp(String string) {
        this.help = string;
    }

    public String getHelp() {
        return this.getHelp(80);
    }

    public String getHelp(int n) {
        String string = this.help;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            Iterator iterator = this.paramsByDeclarationOrder.iterator();
            while (iterator.hasNext()) {
                n2 = Math.max(n2, ((AbstractParameter)iterator.next()).getSyntax().length());
            }
            int n3 = n - 8 - n2;
            Iterator iterator2 = this.paramsByDeclarationOrder.iterator();
            while (iterator2.hasNext()) {
                AbstractParameter abstractParameter = (AbstractParameter)iterator2.next();
                Iterator iterator3 = StringUtils.wrapToList(abstractParameter.getHelp(), n3).iterator();
                stringBuffer.append("  ");
                stringBuffer.append(StringUtils.padRightToWidth(abstractParameter.getSyntax(), n2));
                stringBuffer.append("    ");
                stringBuffer.append(StringUtils.padRightToWidth(iterator3.hasNext() ? (String)iterator3.next() : "", n3));
                stringBuffer.append("\n");
                while (iterator3.hasNext()) {
                    stringBuffer.append(StringUtils.padRightToWidth("", n2 + 6));
                    stringBuffer.append(StringUtils.padRightToWidth((String)iterator3.next(), n3));
                    stringBuffer.append("\n");
                }
                if (!iterator2.hasNext()) continue;
                stringBuffer.append("\n");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public String getUsage() {
        String string = this.usage;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.paramsByDeclarationOrder.iterator();
            while (iterator.hasNext()) {
                AbstractParameter abstractParameter = (AbstractParameter)iterator.next();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(abstractParameter.getSyntax());
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public String toString() {
        return this.getUsage();
    }

    public IDMap getIDMap() {
        Object object;
        HashMap<String, String> hashMap;
        ArrayList<String> arrayList = new ArrayList<String>(this.paramsByDeclarationOrder.size());
        Object object2 = this.paramsByDeclarationOrder.iterator();
        while (object2.hasNext()) {
            hashMap = (AbstractParameter)object2.next();
            arrayList.add(((AbstractParameter)((Object)hashMap)).getID());
        }
        object2 = new HashMap();
        hashMap = this.paramsByShortFlag.keySet().iterator();
        while (hashMap.hasNext()) {
            object = (Character)hashMap.next();
            object2.put(object, ((AbstractParameter)this.paramsByShortFlag.get(object)).getID());
        }
        hashMap = new HashMap<String, String>();
        object = this.paramsByLongFlag.keySet().iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            hashMap.put(string, ((AbstractParameter)this.paramsByLongFlag.get(string)).getID());
        }
        return new IDMap(arrayList, (Map)object2, hashMap);
    }

    public AbstractParameter getByID(String string) {
        return (AbstractParameter)this.paramsByID.get(string);
    }

    public Flagged getByLongFlag(String string) {
        return (Flagged)this.paramsByLongFlag.get(string);
    }

    public Flagged getByShortFlag(Character c) {
        return (Flagged)this.paramsByShortFlag.get(c);
    }

    public Flagged getByShortFlag(char c) {
        return this.getByShortFlag(new Character(c));
    }

    public Iterator getUnflaggedOptionsIterator() {
        return this.unflaggedOptions.iterator();
    }

    public void registerDefaultSource(DefaultSource defaultSource) {
        this.defaultSources.add(defaultSource);
    }

    public void unregisterDefaultSource(DefaultSource defaultSource) {
        this.defaultSources.remove(defaultSource);
    }

    private Defaults getSystemDefaults() {
        Defaults defaults = new Defaults();
        Iterator iterator = this.paramsByDeclarationOrder.iterator();
        while (iterator.hasNext()) {
            AbstractParameter abstractParameter = (AbstractParameter)iterator.next();
            defaults.setDefault(abstractParameter.getID(), abstractParameter.getDefault());
        }
        return defaults;
    }

    private void combineDefaults(Defaults defaults, Defaults defaults2) {
        if (defaults2 != null) {
            Iterator iterator = defaults2.idIterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                defaults.setDefaultIfNeeded(string, defaults2.getDefault(string));
            }
        }
    }

    protected Defaults getDefaults(ExceptionMap exceptionMap) {
        Defaults defaults = new Defaults();
        IDMap iDMap = this.getIDMap();
        Iterator iterator = this.defaultSources.iterator();
        while (iterator.hasNext()) {
            DefaultSource defaultSource = (DefaultSource)iterator.next();
            this.combineDefaults(defaults, defaultSource.getDefaults(iDMap, exceptionMap));
        }
        this.combineDefaults(defaults, this.getSystemDefaults());
        return defaults;
    }

    public void registerParameter(AbstractParameter abstractParameter) throws JSAPException {
        Flagged flagged;
        String string = abstractParameter.getID();
        if (this.paramsByID.containsKey(string)) {
            throw new JSAPException("A parameter with ID '" + string + "' has already been registered.");
        }
        if (abstractParameter instanceof Flagged) {
            flagged = (Flagged)((Object)abstractParameter);
            if (flagged.getShortFlagCharacter() == null && flagged.getLongFlag() == null) {
                throw new JSAPException("FlaggedOption '" + string + "' has no flags defined.");
            }
            if (this.paramsByShortFlag.containsKey(flagged.getShortFlagCharacter())) {
                throw new JSAPException("A parameter with short flag '" + flagged.getShortFlag() + "' has already been registered.");
            }
            if (this.paramsByLongFlag.containsKey(flagged.getLongFlag())) {
                throw new JSAPException("A parameter with long flag '" + flagged.getLongFlag() + "' has already been registered.");
            }
        } else if (this.unflaggedOptions.size() > 0 && ((UnflaggedOption)this.unflaggedOptions.get(this.unflaggedOptions.size() - 1)).isGreedy()) {
            throw new JSAPException("A greedy unflagged option has already been registered; option '" + string + "' will never be reached.");
        }
        if (abstractParameter instanceof Option) {
            ((Option)abstractParameter).register();
        }
        abstractParameter.setLocked(true);
        this.paramsByID.put(string, abstractParameter);
        this.paramsByDeclarationOrder.add(abstractParameter);
        if (abstractParameter instanceof Flagged) {
            flagged = (Flagged)((Object)abstractParameter);
            if (flagged.getShortFlagCharacter() != null) {
                this.paramsByShortFlag.put(flagged.getShortFlagCharacter(), abstractParameter);
            }
            if (flagged.getLongFlag() != null) {
                this.paramsByLongFlag.put(flagged.getLongFlag(), abstractParameter);
            }
        } else if (abstractParameter instanceof Option) {
            this.unflaggedOptions.add(abstractParameter);
        }
    }

    public void unregisterParameter(AbstractParameter abstractParameter) {
        if (this.paramsByID.containsKey(abstractParameter.getID())) {
            if (abstractParameter instanceof Option) {
                ((Option)abstractParameter).unregister();
            }
            this.paramsByID.remove(abstractParameter.getID());
            this.paramsByDeclarationOrder.remove(abstractParameter);
            if (abstractParameter instanceof FlaggedOption) {
                FlaggedOption flaggedOption = (FlaggedOption)abstractParameter;
                this.paramsByShortFlag.remove(flaggedOption.getShortFlagCharacter());
                this.paramsByLongFlag.remove(flaggedOption.getLongFlag());
            } else if (abstractParameter instanceof UnflaggedOption) {
                this.unflaggedOptions.remove(abstractParameter);
            }
            abstractParameter.setLocked(false);
        }
    }

    public JSAPResult parse(String[] stringArray) {
        Parser parser = new Parser(this, stringArray);
        return parser.parse();
    }

    public JSAPResult parse(String string) {
        String[] stringArray = CommandLineTokenizer.tokenize(string);
        return this.parse(stringArray);
    }

    public void finalize() {
        AbstractParameter[] abstractParameterArray = this.paramsByDeclarationOrder.toArray(new AbstractParameter[0]);
        int n = abstractParameterArray.length;
        for (int i = 0; i < n; ++i) {
            this.unregisterParameter(abstractParameterArray[i]);
        }
    }
}

