/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.AbstractParameter;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.stringparsers.StringStringParser;
import java.util.ArrayList;
import java.util.List;

public abstract class Option
extends AbstractParameter {
    private boolean isList = false;
    private boolean required = false;
    private char listSeparator = JSAP.DEFAULT_LISTSEPARATOR;
    private StringParser stringParser = null;

    public Option(String string) {
        super(string);
    }

    protected final void internalSetList(boolean bl) {
        this.enforceParameterLock();
        this.isList = bl;
    }

    public final boolean isList() {
        return this.isList;
    }

    protected final void internalSetListSeparator(char c) {
        this.enforceParameterLock();
        this.listSeparator = c;
    }

    public final char getListSeparator() {
        return this.listSeparator;
    }

    protected final void internalSetRequired(boolean bl) {
        this.enforceParameterLock();
        this.required = bl;
    }

    public final boolean required() {
        return this.required;
    }

    protected final void internalSetStringParser(StringParser stringParser) {
        this.enforceParameterLock();
        this.stringParser = stringParser;
    }

    public final StringParser getStringParser() {
        return this.stringParser;
    }

    private void storeParseResult(List list, String string) throws ParseException {
        Object object = this.getStringParser().parse(string);
        if (object != null) {
            list.add(object);
        }
    }

    protected final List parse(String string) throws ParseException {
        ArrayList arrayList = new ArrayList();
        if (this.getStringParser() == null) {
            boolean bl = this.locked();
            this.setLocked(false);
            this.internalSetStringParser(new StringStringParser());
            this.setLocked(bl);
        }
        if (string == null || !this.isList()) {
            this.storeParseResult(arrayList, string);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == this.getListSeparator()) {
                    this.storeParseResult(arrayList, stringBuffer.toString());
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append(c);
                if (i != n - 1) continue;
                this.storeParseResult(arrayList, stringBuffer.toString());
            }
        }
        return arrayList;
    }

    protected void register() throws JSAPException {
        StringParser stringParser = this.getStringParser();
        try {
            if (stringParser != null) {
                stringParser.setUp();
            }
        }
        catch (Exception exception) {
            throw new JSAPException(exception.getMessage(), exception);
        }
    }

    protected void unregister() {
        StringParser stringParser = this.getStringParser();
        if (stringParser != null) {
            stringParser.tearDown();
        }
    }
}

