/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.AbstractParameter;
import com.martiansoftware.jsap.Defaults;
import com.martiansoftware.jsap.Flagged;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.IDMap;
import com.martiansoftware.jsap.IllegalMultipleDeclarationException;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Option;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.QualifiedSwitch;
import com.martiansoftware.jsap.RequiredParameterMissingException;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.SyntaxException;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.UnknownFlagException;
import java.util.Iterator;

class Parser {
    private JSAP config = null;
    private Iterator unflaggedOptions = null;
    private UnflaggedOption curUnflaggedOption = null;
    private String[] args = null;
    private boolean parsed = false;
    private JSAPResult result = null;

    public Parser(JSAP jSAP, String[] stringArray) {
        this.config = jSAP;
        this.args = stringArray;
        this.parsed = false;
        this.result = new JSAPResult();
        this.unflaggedOptions = jSAP.getUnflaggedOptionsIterator();
        this.advanceUnflaggedOption();
    }

    private void advanceUnflaggedOption() {
        this.curUnflaggedOption = this.unflaggedOptions.hasNext() ? (UnflaggedOption)this.unflaggedOptions.next() : null;
    }

    private void processParameter(AbstractParameter abstractParameter, String string) {
        if (this.result.getObject(abstractParameter.getID()) != null && (abstractParameter instanceof FlaggedOption && !((FlaggedOption)abstractParameter).allowMultipleDeclarations() || abstractParameter instanceof Switch || abstractParameter instanceof QualifiedSwitch || abstractParameter instanceof UnflaggedOption && !((UnflaggedOption)abstractParameter).isGreedy())) {
            this.result.addException(abstractParameter.getID(), new IllegalMultipleDeclarationException(abstractParameter.getID()));
        }
        if (abstractParameter instanceof QualifiedSwitch) {
            this.result.registerQualifiedSwitch(abstractParameter.getID(), true);
        }
        try {
            this.result.add(abstractParameter.getID(), abstractParameter.parse(string));
        }
        catch (ParseException parseException) {
            this.result.addException(abstractParameter.getID(), parseException);
        }
    }

    private int parseArg(String[] stringArray, int n) {
        if (stringArray[n].startsWith("--")) {
            return this.parseLongForm(stringArray, n);
        }
        if (stringArray[n].startsWith("-")) {
            return this.parseShortForm(stringArray, n);
        }
        return this.parseUnflaggedOption(stringArray, n);
    }

    private void processDefaults() {
        Defaults defaults = this.config.getDefaults(this.result);
        Iterator iterator = defaults.idIterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            String string = (String)iterator.next();
            if (this.result.getObject(string) != null || (stringArray = defaults.getDefault(string)) == null) continue;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.processParameter(this.config.getByID(string), stringArray[i]);
            }
        }
    }

    private void enforceRequirements() {
        IDMap iDMap = this.config.getIDMap();
        Iterator iterator = iDMap.idIterator();
        while (iterator.hasNext()) {
            Option option;
            String string = (String)iterator.next();
            AbstractParameter abstractParameter = this.config.getByID(string);
            if (!(abstractParameter instanceof Option) || !(option = (Option)abstractParameter).required() || this.result.getObject(string) != null) continue;
            this.result.addException(option.getID(), new RequiredParameterMissingException(string));
        }
    }

    public JSAPResult parse() {
        if (this.parsed) {
            this.result.addException(null, new JSAPException("This Parser has already run."));
        } else {
            this.preregisterQualifiedSwitches();
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                n2 = this.parseArg(this.args, n2);
            }
            this.processDefaults();
            this.enforceRequirements();
            this.parsed = true;
        }
        return this.result;
    }

    private void preregisterQualifiedSwitches() {
        Iterator iterator = this.config.getIDMap().idIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AbstractParameter abstractParameter = this.config.getByID(string);
            if (!(abstractParameter instanceof QualifiedSwitch)) continue;
            this.result.registerQualifiedSwitch(string, false);
        }
    }

    private int parseLongForm(String[] stringArray, int n) {
        int n2 = stringArray[n].indexOf(61);
        int n3 = stringArray[n].indexOf(58);
        String string = null;
        String string2 = null;
        String string3 = null;
        if (n2 == -1 && n3 == -1) {
            string = stringArray[n].substring(2);
        }
        if (n2 != -1) {
            string = stringArray[n].substring(2, n2);
            string2 = stringArray[n].substring(n2 + 1);
        }
        if (n2 == -1 && n3 != -1) {
            string = stringArray[n].substring(2, n3);
            string3 = stringArray[n].substring(n3);
        }
        ++n;
        Flagged flagged = this.config.getByLongFlag(string);
        AbstractParameter abstractParameter = (AbstractParameter)((Object)flagged);
        if (flagged == null) {
            this.result.addException(null, new UnknownFlagException(string));
        } else if (flagged instanceof Switch) {
            if (n2 != -1) {
                this.result.addException(abstractParameter.getID(), new SyntaxException("Switch \"" + string + "\" does not take any parameters."));
            } else {
                this.processParameter(abstractParameter, null);
            }
        } else if (abstractParameter instanceof QualifiedSwitch) {
            Object var10_10 = null;
            if (n3 == -1) {
                this.processParameter(abstractParameter, null);
            } else {
                this.processParameter(abstractParameter, stringArray[n - 1].substring(n3 + 1));
            }
        } else if (n2 == -1) {
            if (n >= stringArray.length) {
                this.result.addException(abstractParameter.getID(), new SyntaxException("No value specified for option \"" + string + "\""));
            } else {
                string2 = stringArray[n];
                ++n;
                this.processParameter(abstractParameter, string2);
            }
        } else {
            this.processParameter(abstractParameter, string2);
        }
        return n;
    }

    private int parseShortForm(String[] stringArray, int n) {
        Character c = null;
        int n2 = stringArray[n].indexOf(61);
        int n3 = stringArray[n].length();
        if (n2 != -1) {
            n3 = n2;
        }
        for (int i = 1; i < n3; ++i) {
            c = new Character(stringArray[n].charAt(i));
            Flagged flagged = this.config.getByShortFlag(c);
            AbstractParameter abstractParameter = (AbstractParameter)((Object)flagged);
            if (flagged == null) {
                this.result.addException(null, new UnknownFlagException(c));
                continue;
            }
            if (flagged instanceof Switch) {
                if (i == n2 - 1) {
                    this.result.addException(abstractParameter.getID(), new SyntaxException("Switch \"" + c + "\" does not take any parameters."));
                    continue;
                }
                this.processParameter(abstractParameter, null);
                continue;
            }
            if (flagged instanceof QualifiedSwitch) {
                if (stringArray[n].length() > i + 1 && stringArray[n].charAt(i + 1) == ':') {
                    this.processParameter(abstractParameter, stringArray[n].substring(i + 2));
                    break;
                }
                this.processParameter(abstractParameter, null);
                continue;
            }
            String string = null;
            if (i != n3 - 1) {
                this.result.addException(abstractParameter.getID(), new SyntaxException("No value specified for option \"" + c + "\"."));
                continue;
            }
            if (n2 != -1) {
                string = stringArray[n].substring(n2 + 1);
                continue;
            }
            if (++n >= stringArray.length) {
                this.result.addException(abstractParameter.getID(), new SyntaxException("No value specified for option \"" + c + "\"."));
                continue;
            }
            string = stringArray[n];
            this.processParameter(abstractParameter, string);
        }
        return ++n;
    }

    private int parseUnflaggedOption(String[] stringArray, int n) {
        if (this.curUnflaggedOption != null) {
            this.processParameter(this.curUnflaggedOption, stringArray[n]);
            if (!this.curUnflaggedOption.isGreedy()) {
                this.advanceUnflaggedOption();
            }
        } else {
            this.result.addException(null, new JSAPException("Unexpected argument: " + stringArray[n]));
        }
        return n + 1;
    }
}

