/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.AbstractParameter;
import com.martiansoftware.jsap.Flagged;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.stringparsers.BooleanStringParser;
import java.util.ArrayList;
import java.util.List;

public class Switch
extends AbstractParameter
implements Flagged {
    private char shortFlag = '\u0000';
    private String longFlag = JSAP.NO_LONGFLAG;

    public Switch(String string) {
        super(string);
        this.setDefault("FALSE");
    }

    public Switch(String string, char c, String string2) {
        this(string);
        this.setShortFlag(c);
        this.setLongFlag(string2);
    }

    public Switch setShortFlag(char c) {
        this.enforceParameterLock();
        this.shortFlag = c;
        return this;
    }

    public char getShortFlag() {
        return this.shortFlag;
    }

    public Character getShortFlagCharacter() {
        return this.shortFlag == '\u0000' ? null : new Character(this.shortFlag);
    }

    public Switch setLongFlag(String string) {
        this.enforceParameterLock();
        this.longFlag = string;
        return this;
    }

    public String getLongFlag() {
        return this.longFlag;
    }

    protected List parse(String string) throws ParseException {
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(new BooleanStringParser().parse(string));
        return arrayList;
    }

    public String getSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        stringBuffer.append("[");
        if (this.getShortFlag() != '\u0000') {
            stringBuffer.append("-" + this.getShortFlag());
            bl = true;
        }
        if (this.getLongFlag() != JSAP.NO_LONGFLAG) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("--" + this.getLongFlag());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Switch setDefault(String string) {
        this._setDefault(string);
        return this;
    }

    public Switch setDefault(String[] stringArray) {
        this._setDefault(stringArray);
        return this;
    }
}

