/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import org.iges.anagram.AnagramException;
import org.iges.anagram.ConfigException;
import org.iges.anagram.Log;
import org.iges.anagram.Module;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Server;
import org.iges.anagram.Setting;

public abstract class AbstractModule
implements Module {
    protected Module parent;
    protected String moduleName;
    protected Server server;
    protected Log log;

    public String getModuleName() {
        return this.moduleName;
    }

    public abstract String getModuleID();

    public abstract void configure(Setting var1) throws ConfigException;

    protected void configModule(Module module, Setting parent) throws ConfigException {
        try {
            Setting moduleSetting = parent.getUniqueSubSetting(module.getModuleID());
            module.configure(moduleSetting);
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (AnagramException ae) {
            throw new ConfigException((Module)this, ae.getMessage(), parent);
        }
    }

    public void init(Server server, Module parent) {
        this.server = server;
        this.log = server.getLog();
        this.parent = parent;
        this.moduleName = parent.getModuleName() + "/" + this.getModuleID();
    }

    protected final boolean debug() {
        return this.log.enabled(0, this);
    }

    protected final boolean verbose() {
        return this.log.enabled(1, this);
    }

    protected final void debug(String msg) {
        this.log.log(0, this, msg);
    }

    protected final void verbose(String msg) {
        this.log.log(1, this, msg);
    }

    protected final void info(String msg) {
        this.log.log(2, this, msg);
    }

    protected final void error(String msg) {
        this.log.log(3, this, msg);
    }

    protected final void fail(String msg) throws ModuleException {
        this.log.error(this, msg);
        throw new ModuleException(this, msg);
    }

    protected final void fail(String msg, Throwable cause) throws ModuleException {
        ModuleException me = new ModuleException((Module)this, msg, cause);
        throw me;
    }

    protected final void fail(String clientMsg, String serverMsg) throws ModuleException {
        throw new ModuleException(this, clientMsg);
    }

    public String toString() {
        return this.getModuleName();
    }
}

