/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.iges.anagram.AnagramException;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.ConfigException;
import org.iges.anagram.Log;
import org.iges.anagram.Module;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Server;
import org.iges.anagram.Setting;
import org.iges.anagram.filter.AbuseFilter;
import org.iges.anagram.filter.AnalysisFilter;
import org.iges.anagram.filter.DispatchFilter;
import org.iges.anagram.filter.Filter;
import org.iges.anagram.filter.OverloadFilter;
import org.iges.anagram.service.DODSErrorService;
import org.iges.anagram.service.ErrorService;
import org.iges.anagram.service.WebErrorService;

public class AnagramServlet
extends HttpServlet
implements Module {
    protected String moduleName;
    protected Server server;
    protected Log log;
    protected Set dodsErrorServices;
    protected ErrorService dodsErrorHandler;
    protected ErrorService webErrorHandler;
    protected List filters;

    public String getModuleID() {
        return "servlet";
    }

    public void init(Server server, Module parent) {
        this.server = server;
        this.log = server.getLog();
        this.moduleName = parent.getModuleName() + "/" + this.getModuleID();
        this.dodsErrorServices = new HashSet<String>(Arrays.asList("dds", "das", "dods", "upload"));
        this.dodsErrorHandler = new DODSErrorService();
        this.dodsErrorHandler.init(server, this);
        this.webErrorHandler = new WebErrorService();
        this.webErrorHandler.init(server, this);
        this.createFilters();
    }

    protected void createFilters() {
        this.filters = new ArrayList();
        this.filters.add(new AbuseFilter());
        this.filters.add(new OverloadFilter());
        this.filters.add(new AnalysisFilter());
        this.filters.add(new DispatchFilter());
        Iterator it = this.filters.iterator();
        Filter next = (Filter)it.next();
        next.init(this.server, this);
        while (it.hasNext()) {
            Filter current = next;
            next = (Filter)it.next();
            next.init(this.server, this);
            current.setNext(next);
        }
    }

    public void configure(Setting setting) throws ConfigException {
        Iterator it = this.filters.iterator();
        try {
            while (it.hasNext()) {
                Filter filter = (Filter)it.next();
                Setting filterSetting = setting.getUniqueSubSetting(filter.getModuleID());
                filter.configure(filterSetting);
            }
        }
        catch (AnagramException ae) {
            throw new ConfigException(this, ae.getMessage());
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    protected boolean debug() {
        return this.log.enabled(0, this);
    }

    protected boolean verbose() {
        return this.log.enabled(1, this);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.server = Server.createServer(this, config);
        this.server.init(config);
    }

    public void destroy() {
        this.server.destroy();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (this.debug()) {
            this.log.debug(this, "getting lock for thread: " + Thread.currentThread().getName());
        }
        this.server.getSynch().lock();
        long startTime = System.currentTimeMillis();
        boolean completed = false;
        ClientRequest clientRequest = this.server.getMapper().map(request, response);
        this.log.info(this, clientRequest + "STARTED");
        if (this.verbose()) {
            this.log.verbose(this, clientRequest + "privilege is " + clientRequest.getPrivilege());
        }
        if (this.debug()) {
            this.log.debug(this, clientRequest + "service is " + clientRequest.getService());
        }
        if (this.debug()) {
            this.log.debug(this, clientRequest + "handle is " + clientRequest.getDataPath());
        }
        try {
            if (this.debug()) {
                this.log.debug(this, clientRequest + "running filters");
            }
            Filter head = (Filter)this.filters.get(0);
            head.handle(clientRequest);
            completed = true;
        }
        catch (ModuleException me) {
            this.findErrorHandler(clientRequest).handle(clientRequest, me);
        }
        catch (Throwable t) {
            this.findErrorHandler(clientRequest).handleUnexpected(clientRequest, t);
        }
        long endTime = System.currentTimeMillis();
        String completedMsg = completed ? "success" : "error";
        this.log.info(this, clientRequest + "FINISHED (" + completedMsg + " in " + (endTime - startTime) + "ms)");
        try {
            clientRequest.getHttpResponse().getOutputStream().close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (clientRequest.getHandle() != null) {
            if (this.debug()) {
                this.log.debug(this, "releasing lock for handle: " + clientRequest.getHandle());
            }
            clientRequest.getHandle().getSynch().releaseAll();
        }
        if (this.debug()) {
            this.log.debug(this, "releasing lock for thread: " + Thread.currentThread().getName());
        }
        this.server.getSynch().releaseAll();
        if (this.debug()) {
            this.log.debug(this, "returning control to Tomcat on thread: " + Thread.currentThread().getName());
        }
    }

    protected ErrorService findErrorHandler(ClientRequest request) {
        if (request.getServiceName() != null && this.dodsErrorServices.contains(request.getServiceName())) {
            return this.dodsErrorHandler;
        }
        return this.webErrorHandler;
    }
}

