/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.iges.anagram.AbstractModule;
import org.iges.anagram.AnagramException;
import org.iges.anagram.ConfigException;
import org.iges.anagram.DataHandle;
import org.iges.anagram.DirHandle;
import org.iges.anagram.Handle;
import org.iges.anagram.Mapper;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Setting;
import org.iges.anagram.TempDataHandle;
import org.iges.anagram.filter.AnalysisFilter;
import org.iges.util.ExclusiveLock;

public class Catalog
extends AbstractModule {
    protected static final String TEMP_ENTRY_FILE = "temp_entry_data.obj";
    protected static final String CATALOG_FILE = "catalog_data.obj";
    protected ExclusiveLock synch;
    protected DirHandle root;
    protected DirHandle tempEntries;
    protected LinkedList tempDeleteQueue;
    protected long tempStorage;
    protected long tempStorageLimit;
    protected long tempEntryLimit;
    protected long tempAgeLimit;

    public Catalog() {
        try {
            this.root = new DirHandle("/");
            this.tempEntries = new DirHandle("/");
        }
        catch (AnagramException anagramException) {
            // empty catch block
        }
        this.synch = new ExclusiveLock();
    }

    public String getModuleID() {
        return "catalog";
    }

    public void configure(Setting setting) throws ConfigException {
        this.tempStorageLimit = setting.getNumAttribute("temp_storage_limit", 0L);
        if (this.tempStorageLimit == 0L) {
            if (this.verbose()) {
                this.log.verbose(this, "temp storage limit is 0 (no limit)");
            }
        } else if (this.verbose()) {
            this.log.verbose(this, "temp storage limit is " + this.tempStorageLimit + " MB");
        }
        this.tempEntryLimit = setting.getNumAttribute("temp_entry_limit", 0L);
        if (this.tempEntryLimit == 0L) {
            if (this.verbose()) {
                this.log.verbose(this, "temp entry limit is 0 (no limit)");
            }
        } else if (this.verbose()) {
            this.log.verbose(this, "temp entry limit is " + this.tempEntryLimit);
        }
        this.tempAgeLimit = setting.getNumAttribute("temp_age_limit", 0L);
        if (this.tempAgeLimit == 0L) {
            if (this.verbose()) {
                this.log.verbose(this, "temp age limit is 0 (no limit)");
            }
        } else if (this.verbose()) {
            this.log.verbose(this, "temp age limit is " + this.tempAgeLimit + " hours");
        }
        if (this.tempDeleteQueue == null) {
            this.loadTempEntriesFromStore();
            this.loadCatalogFromStore();
        }
        Setting dataTag = null;
        try {
            dataTag = setting.getUniqueSubSetting("data");
        }
        catch (AnagramException ae) {
            throw new ConfigException(this, ae.getMessage());
        }
        if (this.verbose()) {
            this.log.verbose(this, "importing data");
        }
        List handleList = this.server.getTool().doImport(dataTag);
        if (this.verbose()) {
            this.log.verbose(this, "clearing deleted entries");
        }
        this.unloadEntries(handleList);
        if (this.verbose()) {
            this.log.verbose(this, "adding new entries");
        }
        this.loadEntries(handleList);
    }

    public void addTemp(TempDataHandle tempData) {
        this.synch.lockExclusive();
        this.addTemp(tempData, false);
        this.synch.releaseExclusive();
    }

    protected void addTemp(TempDataHandle tempData, boolean save) {
        this.tempDeleteQueue.addLast(tempData);
        DataHandle[] handles = tempData.getDataHandles();
        for (int i = 0; i < handles.length; ++i) {
            if (this.debug()) {
                this.log.debug(this, "adding temp data as " + handles[i].getCompleteName());
            }
            this.tempEntries.add(handles[i]);
        }
        this.tempStorage += tempData.getStorageSize();
        if (this.debug()) {
            this.log.debug(this, "temp queue size is " + this.tempDeleteQueue.size());
        }
        if (this.debug()) {
            this.log.debug(this, "temp entries: " + this.tempEntries.getEntries(true).keySet());
        }
        try {
            if (this.outdated(tempData)) {
                this.removeTemp("clearing outdated cache entry", tempData);
            }
            this.checkLimits();
        }
        catch (AnagramException ae) {
            // empty catch block
        }
        if (save) {
            this.saveTempEntriesToStore();
        }
    }

    protected boolean outdated(TempDataHandle tempData) {
        if (this.debug()) {
            this.debug("out-of-date check for temp data");
        }
        Iterator it = tempData.getDependencies().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Handle handle = this.get(name);
            if (handle == null || !(handle instanceof DataHandle) || ((DataHandle)handle).getCreateTime() <= tempData.getCreateTime()) continue;
            return true;
        }
        return false;
    }

    protected void checkDependencies(DataHandle data) {
        if (this.debug()) {
            this.debug("checking temp entries for dependencies on " + data.getCompleteName());
        }
        Iterator it = this.tempDeleteQueue.iterator();
        while (it.hasNext()) {
            TempDataHandle tempHandle = (TempDataHandle)it.next();
            if (tempHandle.getCreateTime() >= data.getCreateTime() || !tempHandle.getDependencies().contains(data.getCompleteName())) continue;
            it.remove();
            try {
                this.removeTemp("dependency " + data.getCompleteName() + " has changed", tempHandle);
            }
            catch (AnagramException ae) {}
        }
    }

    public Handle getLocked(String path) {
        this.synch.lock();
        Handle handle = this.get(path);
        if (handle != null) {
            handle.getSynch().lock();
        }
        this.synch.release();
        return handle;
    }

    public boolean contains(String path) {
        this.synch.lock();
        Handle handle = this.get(path);
        this.synch.release();
        return handle != null;
    }

    protected Handle get(String path) {
        Handle handle = null;
        if (path.indexOf(AnalysisFilter.ANALYSIS_PREFIX) >= 0) {
            if (this.debug()) {
                this.debug("looking in temp entries for " + path);
            }
            try {
                this.checkLimits();
            }
            catch (AnagramException ae) {
                // empty catch block
            }
            handle = this.tempEntries.get(path);
            if (handle != null && handle instanceof DataHandle) {
                try {
                    this.server.getTool().doUpdate((DataHandle)handle);
                }
                catch (ModuleException me) {
                    this.error("update of dataset  " + handle.getCompleteName() + " failed; " + me.getMessage());
                    handle = null;
                }
            }
        } else {
            if (this.debug()) {
                this.debug("looking in permanent catalog for " + path);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.equals("")) {
                handle = this.root;
            } else {
                DirHandle dir;
                if (path.startsWith(Mapper.NO_CACHE)) {
                    path = "/" + path.substring(Mapper.NO_CACHE.length());
                }
                if ((handle = (dir = this.getDir(path, this.root)).get(path)) instanceof DataHandle) {
                    try {
                        if (this.server.getTool().doUpdate((DataHandle)handle)) {
                            this.checkDependencies((DataHandle)handle);
                        }
                    }
                    catch (ModuleException me) {
                        this.error("update of dataset  " + handle.getCompleteName() + " failed; " + me.getMessage());
                        handle = null;
                    }
                }
            }
        }
        return handle;
    }

    public void clearTemp() throws AnagramException {
        while (this.tempDeleteQueue.size() > 0) {
            this.removeTemp("clearing cache", null);
        }
        this.synch.lock();
        this.saveTempEntriesToStore();
        this.synch.release();
    }

    public DirHandle getParent(Handle handle) {
        return this.getDir(handle.getCompleteName(), this.root);
    }

    protected DirHandle getDir(String path, DirHandle dir) {
        String subPath;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((subPath = this.getChildPath(path, dir)).equals("") || path.startsWith("_")) {
            return dir;
        }
        Handle handle = dir.get(dir.getCompleteName() + subPath);
        if (handle != null && handle instanceof DirHandle) {
            DirHandle subdir = (DirHandle)handle;
            return this.getDir(path, subdir);
        }
        return dir;
    }

    protected String getChildPath(String completePath, DirHandle dir) {
        int subPathStart = dir.getCompleteName().length();
        int subPathEnd = completePath.indexOf(47, subPathStart + 1);
        if (subPathEnd < 0) {
            return "";
        }
        return completePath.substring(subPathStart, subPathEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHandle(Handle handle) {
        try {
            if (this.debug()) {
                this.debug("adding handle " + handle);
            }
            DirHandle parent = this.getDir(handle.getCompleteName(), this.root);
            if (this.debug()) {
                this.debug("handle matches dir " + parent);
            }
            String childPath = this.getChildPath(handle.getCompleteName(), parent);
            if (this.debug()) {
                this.debug("subdir is " + childPath);
            }
            while (!childPath.equals("") && !handle.getCompleteName().startsWith("_")) {
                DirHandle newDir = new DirHandle(parent.getCompleteName() + childPath);
                DirHandle dirHandle = parent;
                synchronized (dirHandle) {
                    parent.add(newDir);
                }
                parent = newDir;
                if (this.debug()) {
                    this.debug("created dir " + newDir);
                }
                childPath = this.getChildPath(handle.getCompleteName(), parent);
                if (!this.debug()) continue;
                this.debug("subdir is " + childPath);
            }
            DirHandle dirHandle = parent;
            synchronized (dirHandle) {
                if (this.debug()) {
                    this.debug("adding handle to " + parent);
                }
                parent.add(handle);
            }
            if (handle instanceof DataHandle) {
                this.checkDependencies((DataHandle)handle);
            }
        }
        catch (AnagramException ae) {
            this.error("failed adding " + handle + "; " + ae.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHandle(Handle handle) {
        DirHandle parent;
        DirHandle dirHandle = parent = this.getDir(handle.getCompleteName(), this.root);
        synchronized (dirHandle) {
            parent.remove(handle.getCompleteName());
        }
        if (parent != this.root && parent.isEmpty()) {
            if (this.debug()) {
                this.debug("destroying dir " + parent);
            }
            this.removeHandle(parent);
        }
    }

    protected void unloadEntries(List newEntries) {
        Iterator it = newEntries.iterator();
        HashMap<String, Handle> newMap = new HashMap<String, Handle>();
        while (it.hasNext()) {
            Handle current = (Handle)it.next();
            newMap.put(current.getCompleteName(), current);
        }
        Map oldMap = this.root.getEntries(true);
        Iterator it2 = oldMap.values().iterator();
        while (it2.hasNext()) {
            Handle current = (Handle)it2.next();
            Handle newHandle = (Handle)newMap.get(current.getCompleteName());
            if (newHandle != null) continue;
            this.removeHandle(current);
            if (!this.verbose()) continue;
            this.log.verbose(this, "unloaded dataset " + current.getCompleteName());
        }
    }

    protected void loadEntries(List newEntries) {
        Iterator it = newEntries.iterator();
        while (it.hasNext()) {
            Handle current = (Handle)it.next();
            Handle oldHandle = this.get(current.getCompleteName());
            if (oldHandle == null) {
                this.addHandle(current);
                if (!this.verbose()) continue;
                this.log.verbose(this, "loaded dataset " + current.getCompleteName());
                continue;
            }
            if (oldHandle.equals(current)) continue;
            this.addHandle(current);
            if (!this.verbose()) continue;
            this.log.verbose(this, "loaded dataset " + current.getCompleteName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadTempEntriesFromStore() {
        block11: {
            this.tempDeleteQueue = new LinkedList();
            File tempEntryFile = this.server.getStore().get(this, TEMP_ENTRY_FILE);
            if (!tempEntryFile.exists()) {
                this.log.info(this, "no temp entries to reload");
                return;
            }
            try {
                try {
                    ObjectInputStream entryStream = new ObjectInputStream(new FileInputStream(tempEntryFile));
                    Collection restoredEntries = (Collection)entryStream.readObject();
                    Iterator it = restoredEntries.iterator();
                    while (it.hasNext()) {
                        this.addTemp((TempDataHandle)it.next(), false);
                    }
                    this.log.info(this, "reloaded " + restoredEntries.size() + " temp entries from " + tempEntryFile.getAbsolutePath());
                    entryStream.close();
                }
                catch (IOException ioe) {
                    this.log.error(this, "temp entries could not be reloaded from " + tempEntryFile.getAbsolutePath() + "; message: " + ioe.getMessage());
                    Object var6_8 = null;
                    if (this.tempDeleteQueue == null) {
                        this.tempDeleteQueue = new LinkedList();
                    }
                    break block11;
                }
                catch (ClassNotFoundException cnfe) {
                    this.log.error(this, "temp entries could not be reloaded from " + tempEntryFile.getAbsolutePath() + "; message: " + cnfe.getMessage());
                    Object var6_9 = null;
                    if (this.tempDeleteQueue == null) {
                        this.tempDeleteQueue = new LinkedList();
                    }
                }
                Object var6_7 = null;
                if (this.tempDeleteQueue == null) {
                    this.tempDeleteQueue = new LinkedList();
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (this.tempDeleteQueue == null) {
                    this.tempDeleteQueue = new LinkedList();
                }
                throw throwable;
            }
        }
    }

    protected void loadCatalogFromStore() {
        File catalogFile = this.server.getStore().get(this, CATALOG_FILE);
        if (!catalogFile.exists()) {
            this.log.info(this, "no catalog entries to reload");
            return;
        }
        try {
            ObjectInputStream entryStream = new ObjectInputStream(new FileInputStream(catalogFile));
            Collection oldEntries = (Collection)entryStream.readObject();
            entryStream.close();
            Iterator it = oldEntries.iterator();
            while (it.hasNext()) {
                Handle data = (Handle)it.next();
                this.addHandle(data);
            }
            this.log.info(this, "reloaded " + oldEntries.size() + " catalog entries from " + catalogFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            this.log.error(this, "catalog entries could not be reloaded from " + catalogFile.getAbsolutePath() + "; message: " + ioe.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            this.log.error(this, "catalog entries could not be reloaded from " + catalogFile.getAbsolutePath() + "; message: " + cnfe.getMessage());
        }
    }

    protected void saveTempEntriesToStore() {
        try {
            File tempEntryFile = this.server.getStore().get(this, TEMP_ENTRY_FILE);
            if (this.debug()) {
                this.log.debug(this, "writing " + this.tempDeleteQueue.size() + " temp entries to " + tempEntryFile.getAbsolutePath());
            }
            ObjectOutputStream entryStream = new ObjectOutputStream(new FileOutputStream(tempEntryFile));
            entryStream.writeObject(this.tempDeleteQueue);
            entryStream.close();
        }
        catch (IOException ioe) {
            this.log.error(this, "saving to persistence mechanism failed; temp entries will not persist after reboot; message: " + ioe);
        }
    }

    protected void saveCatalogToStore() {
        try {
            File catalogFile = this.server.getStore().get(this, CATALOG_FILE);
            LinkedList entries = new LinkedList();
            Iterator it = this.root.getEntries(true).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry current = it.next();
                entries.add(current.getValue());
            }
            if (this.debug()) {
                this.log.debug(this, "writing " + entries.size() + " catalog entries to " + catalogFile.getAbsolutePath());
            }
            ObjectOutputStream entryStream = new ObjectOutputStream(new FileOutputStream(catalogFile));
            entryStream.writeObject(entries);
            entryStream.close();
        }
        catch (IOException ioe) {
            this.log.error(this, "saving to persistence mechanism failed; catalog will not persist after reboot; message: " + ioe);
        }
    }

    protected void checkLimits() throws AnagramException {
        TempDataHandle current;
        long age;
        while (this.tempEntryLimit != 0L && (long)this.tempDeleteQueue.size() > this.tempEntryLimit) {
            this.removeTemp("entry limit exceeded", null);
        }
        while (this.tempStorageLimit != 0L && (double)this.tempStorage > (double)this.tempStorageLimit * 1000000.0) {
            this.removeTemp("storage limit exceeded", null);
        }
        long now = System.currentTimeMillis();
        long limit = this.tempAgeLimit * 60L * 60L * 1000L;
        while (this.tempAgeLimit != 0L && (age = now - (current = (TempDataHandle)this.tempDeleteQueue.getFirst()).getCreateTime()) >= limit) {
            this.removeTemp("age limit exceeded", null);
        }
    }

    protected void removeTemp(String reason, TempDataHandle tempHandle) throws AnagramException {
        int i;
        this.synch.lockExclusive();
        boolean isFirst = false;
        if (tempHandle == null) {
            try {
                isFirst = true;
                tempHandle = (TempDataHandle)this.tempDeleteQueue.getFirst();
            }
            catch (NoSuchElementException nse) {
                this.synch.releaseExclusive();
                return;
            }
        }
        DataHandle[] handles = tempHandle.getDataHandles();
        boolean succeeded = true;
        this.log.info(this, reason + "; deleting temp data " + handles[0]);
        for (i = 0; i < handles.length; ++i) {
            if (handles[i].getSynch().tryLockExclusive()) continue;
            succeeded = false;
            for (int j = i - 1; j >= 0; --j) {
                handles[j].getSynch().releaseExclusive();
            }
            break;
        }
        if (succeeded) {
            for (i = 0; i < handles.length; ++i) {
                this.tempEntries.remove(handles[i].getCompleteName());
            }
            if (isFirst) {
                this.tempDeleteQueue.removeFirst();
            }
            this.tempStorage -= tempHandle.getStorageSize();
            tempHandle.deleteStorage();
            for (i = handles.length - 1; i >= 0; --i) {
                handles[i].getSynch().releaseExclusive();
            }
        } else {
            this.synch.releaseExclusive();
            throw new AnagramException("fail to get exclusive lock for some handle");
        }
        this.synch.releaseExclusive();
    }

    public void destroy() {
        this.synch.lock();
        this.saveCatalogToStore();
        this.saveTempEntriesToStore();
        this.synch.release();
    }
}

