/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.iges.anagram.Handle;
import org.iges.anagram.Privilege;
import org.iges.anagram.service.Service;
import org.iges.util.FDSUtils;

public class ClientRequest {
    protected HttpServletRequest httpRequest;
    protected HttpServletResponse httpResponse;
    protected Handle handle;
    protected Service service;
    protected String dataPath;
    protected String serviceName;
    protected String ce;
    protected String summary;
    protected Privilege privileges;
    protected boolean useCache;

    public ClientRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Privilege privileges, Service service, String serviceName, String dataPath, Handle handle, boolean useCache) {
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.privileges = privileges;
        this.service = service;
        this.serviceName = serviceName;
        this.ce = httpRequest.getQueryString();
        if (this.ce != null) {
            this.ce = URLDecoder.decode(this.ce);
        }
        this.dataPath = dataPath;
        this.handle = handle;
        this.useCache = useCache;
        this.buildSummary();
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    public String getURL() {
        return FDSUtils.decodeURL(this.httpRequest.getRequestURL().toString());
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public void setHandle(Handle handle) {
        this.handle = handle;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Service getService() {
        return this.service;
    }

    public String getCE() {
        return this.ce;
    }

    public Privilege getPrivilege() {
        return this.privileges;
    }

    public boolean useCache() {
        return this.useCache;
    }

    public String toString() {
        return this.summary;
    }

    protected void buildSummary() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ ");
        buf.append(Thread.currentThread().getName());
        buf.append(" ");
        buf.append(this.httpRequest.getRemoteHost());
        buf.append(" ");
        buf.append(this.httpRequest.getMethod());
        buf.append(" ");
        buf.append(FDSUtils.getServletPath(this.httpRequest));
        if (this.ce != null) {
            buf.append("?");
            buf.append(this.ce);
        }
        buf.append(" ] ");
        this.summary = buf.toString();
    }
}

