/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import org.iges.anagram.AnagramException;
import org.iges.anagram.Handle;
import org.iges.anagram.ToolInfo;
import org.iges.anagram.filter.AnalysisFilter;
import org.iges.util.FDSUtils;

public class DataHandle
extends Handle {
    protected String dataSetName = null;
    protected boolean available;
    protected ToolInfo toolInfo;
    protected String description;
    protected long createTime;

    public DataHandle(String completeName, String description, ToolInfo toolInfo, long createTime) throws AnagramException {
        super(completeName);
        this.description = description;
        this.toolInfo = toolInfo;
        this.createTime = createTime;
        this.available = true;
    }

    public String getDataSetName() {
        if (this.dataSetName == null) {
            this.dataSetName = this.completeName.indexOf(AnalysisFilter.ANALYSIS_PREFIX.substring(1)) >= 0 ? "_expr_" + FDSUtils.MD5Encode(this.completeName) : this.getName();
        }
        return this.dataSetName;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.createTime = System.currentTimeMillis();
    }

    public ToolInfo getToolInfo() {
        return this.toolInfo;
    }

    public void setToolInfo(ToolInfo toolInfo) {
        this.toolInfo = toolInfo;
        this.createTime = System.currentTimeMillis();
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        DataHandle o1 = (DataHandle)o;
        if (this.isEqual(o1.getDescription(), this.getDescription()) && (o1.isAvailable() && this.isAvailable() || !o1.isAvailable() && !this.isAvailable())) {
            if (this.getToolInfo() == null) {
                return false;
            }
            return this.getToolInfo().equals(o1.getToolInfo());
        }
        return false;
    }
}

