/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.iges.anagram.AnagramException;
import org.iges.anagram.Handle;

public class DirHandle
extends Handle {
    protected SortedMap entries = new TreeMap();

    public DirHandle(String completeName) throws AnagramException {
        super(completeName);
    }

    public void add(Handle handle) {
        this.entries.put(handle.getCompleteName(), handle);
    }

    public void remove(String completeName) {
        this.entries.remove(completeName);
    }

    public boolean contains(String completeName) {
        return this.entries.keySet().contains(completeName);
    }

    public Handle get(String completeName) {
        return (Handle)this.entries.get(completeName);
    }

    public boolean isEmpty() {
        return this.getEntries(false).size() == 0;
    }

    public Map getEntries(boolean recurse) {
        if (recurse) {
            TreeMap<String, Handle> recursedEntries = new TreeMap<String, Handle>();
            Iterator it = this.entries.values().iterator();
            while (it.hasNext()) {
                Handle next = (Handle)it.next();
                recursedEntries.put(next.getCompleteName(), next);
                if (!(next instanceof DirHandle)) continue;
                recursedEntries.putAll(((DirHandle)next).getEntries(true));
            }
            return recursedEntries;
        }
        return this.entries;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        DirHandle o1 = (DirHandle)o;
        return this.isEqual(o1.getCompleteName(), this.getCompleteName());
    }
}

