/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import java.io.Serializable;
import org.iges.anagram.AnagramException;
import org.iges.util.ExclusiveLock;
import org.iges.util.FDSUtils;

public abstract class Handle
implements Serializable {
    protected String completeName;
    protected transient ExclusiveLock synch;

    protected Handle(String completeName) throws AnagramException {
        this.validateName(completeName);
        this.completeName = completeName;
        this.synch = new ExclusiveLock();
    }

    public String getName() {
        int lastSlash = FDSUtils.lastIndexOf('/', this.completeName);
        if (lastSlash < 0) {
            lastSlash = 0;
        }
        return this.completeName.substring(lastSlash + 1);
    }

    public String getCompleteName() {
        return this.completeName;
    }

    public String toString() {
        return this.completeName;
    }

    public ExclusiveLock getSynch() {
        if (this.synch == null) {
            this.synch = new ExclusiveLock();
        }
        return this.synch;
    }

    protected void validateName(String name) throws AnagramException {
    }

    protected boolean isEqual(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }
}

