/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.iges.anagram.AnagramException;
import org.iges.anagram.ConfigException;
import org.iges.anagram.Module;
import org.iges.anagram.Server;
import org.iges.anagram.Setting;
import org.iges.util.FileResolver;

public class Log
implements Module {
    protected Server server;
    protected int defaultLevel = 0;
    protected int mode;
    protected boolean printMem;
    protected boolean printModule;
    protected String dateTemplate;
    protected DateFormat entryFormat;
    protected FieldPosition pos;
    protected String logFileName;
    protected String curLogFileName;
    protected Rotater rotater;
    protected PrintWriter logWriter;
    protected String defaultLogFile;
    protected String moduleName;
    protected Map moduleSettings = new HashMap();
    public static final int DEBUG = 0;
    public static final int VERBOSE = 1;
    public static final int INFO = 2;
    public static final int ERROR = 3;
    public static final int CRITICAL = 4;
    public static final int SILENT = 5;
    public static final int NUM_LEVELS = 6;
    public static final String[] LEVEL_NAME = new String[]{"debug", "verbose", "info", "error", "critical", "silent"};
    protected static final int CONSOLE_MODE = 0;
    protected static final int FILE_MODE = 1;
    protected static final int ROTATE_MODE = 2;
    protected static final String[] MODE_NAME = new String[]{"console", "file", "rotate"};

    public Log() {
        this.consoleMode();
        this.pos = new FieldPosition(2);
    }

    public final String getModuleID() {
        return "log";
    }

    public final String getModuleName() {
        return this.moduleName;
    }

    public final void init(Server server, Module parent) {
        this.server = server;
        this.moduleName = parent.getModuleName() + "/" + this.getModuleID();
        this.defaultLogFile = "log/" + server.getModuleName() + ".log";
        this.open(this.defaultLogFile);
        this.mode = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Setting setting) throws ConfigException {
        PrintWriter printWriter = this.logWriter;
        synchronized (printWriter) {
            Map map = this.moduleSettings;
            synchronized (map) {
                this.parseLevel(setting);
                this.parseMode(setting);
                this.parseModuleSettings(setting);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int level, Module module, String message) {
        if (!this.enabled(level, module)) {
            return;
        }
        if (this.mode == 2) {
            this.rotater.check();
        }
        StringBuffer msg = new StringBuffer();
        this.entryFormat.format(new Date(), msg, this.pos);
        if (this.printMem) {
            msg.append(" ");
            msg.append(String.valueOf(Runtime.getRuntime().freeMemory() / 1024L));
            msg.append("KB");
        }
        if (this.printModule) {
            msg.append(" [ ");
            msg.append(module.getModuleName());
            msg.append(" ]");
        }
        msg.append(" ");
        if (level == 4) {
            msg.append("CRITICAL: ");
        } else if (level == 3) {
            msg.append("error: ");
        } else if (level == 0) {
            msg.append("*dbg* ");
        }
        msg.append(message);
        PrintWriter printWriter = this.logWriter;
        synchronized (printWriter) {
            this.logWriter.println(msg);
            this.logWriter.flush();
        }
    }

    public void critical(Module module, String message) {
        this.log(4, module, message);
    }

    public void error(Module module, String message) {
        this.log(3, module, message);
    }

    public void info(Module module, String message) {
        this.log(2, module, message);
    }

    public void verbose(Module module, String message) {
        this.log(1, module, message);
    }

    public void debug(Module module, String message) {
        this.log(0, module, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enabled(int level, Module module) {
        Map map = this.moduleSettings;
        synchronized (map) {
            Integer moduleLevel = (Integer)this.moduleSettings.get(module.getModuleName());
            if (moduleLevel == null) {
                return level >= this.defaultLevel;
            }
            return level >= moduleLevel;
        }
    }

    protected void parseLevel(Setting setting) {
        String printMemAttr = setting.getAttribute("print_mem", "false");
        this.printMem = Boolean.valueOf(printMemAttr);
        String printModuleAttr = setting.getAttribute("print_module", "false");
        this.printModule = Boolean.valueOf(printModuleAttr);
        this.dateTemplate = setting.getAttribute("date_format");
        this.defaultLevel = Log.getLevel(setting.getAttribute("level", "info"));
        if (this.defaultLevel < 0) {
            this.defaultLevel = 2;
            this.error(this, "invalid 'level' attribute: " + setting);
        }
        this.verbose(this, "default log level is " + LEVEL_NAME[this.defaultLevel]);
    }

    protected void parseMode(Setting setting) throws ConfigException {
        String modeName = setting.getAttribute("mode", "file");
        this.logFileName = setting.getAttribute("file", this.defaultLogFile);
        File logFile = FileResolver.resolve(this.server.getHome(), this.logFileName);
        this.logFileName = logFile.getAbsolutePath();
        if (Log.getMode(modeName) != this.mode || Log.getMode(modeName) == 1) {
            switch (Log.getMode(modeName)) {
                case 1: {
                    if (this.logFileName.equals(this.curLogFileName)) break;
                    this.info(this, "directing output to " + this.logFileName);
                    this.open(this.logFileName);
                    this.mode = 1;
                    break;
                }
                case 2: {
                    try {
                        this.rotater = new Rotater(setting.getAttribute("frequency", ""));
                    }
                    catch (AnagramException ae) {
                        throw new ConfigException((Module)this, ae.getMessage(), setting);
                    }
                    this.info(this, "directing output to " + this.rotater.getCurrentFileName());
                    this.open(this.rotater.getCurrentFileName());
                    this.mode = 2;
                    break;
                }
                case -1: {
                    this.error(this, "invalid 'mode' attribute: " + setting);
                }
                case 0: {
                    this.info(this, "directing output to console");
                    this.consoleMode();
                }
            }
        }
    }

    protected void parseModuleSettings(Setting setting) {
        this.moduleSettings.clear();
        List modules = setting.getSubSettings("log_override");
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            Setting moduleSetting = (Setting)it.next();
            String moduleName = this.server.getModuleName() + "/" + moduleSetting.getAttribute("module");
            String levelName = moduleSetting.getAttribute("level");
            if (moduleName == "") {
                this.error(this, "missing 'name' attribute: " + moduleSetting);
                continue;
            }
            if (levelName == "") {
                this.error(this, "missing 'level' attribute: " + moduleSetting);
                continue;
            }
            int level = Log.getLevel(levelName);
            if (level < 0) {
                this.error(this, "invalid 'level' attribute: " + moduleSetting);
                continue;
            }
            this.verbose(this, "log level set to " + levelName + " for " + moduleName);
            this.moduleSettings.put(moduleName, new Integer(level));
        }
    }

    protected void open(String filename) {
        File logFile;
        File parent;
        if (this.logWriter != null && this.mode != 0) {
            this.logWriter.close();
        }
        if (this.entryFormat == null) {
            this.entryFormat = this.dateTemplate == null || this.dateTemplate.equals("") ? new SimpleDateFormat("MMM dd HH:mm:ss") : new SimpleDateFormat(this.dateTemplate);
        }
        if (!(parent = (logFile = FileResolver.resolve(this.server.getHome(), filename)).getParentFile()).exists()) {
            parent.mkdirs();
        }
        try {
            this.logWriter = new PrintWriter(new BufferedWriter(new FileWriter(logFile.getAbsolutePath(), true)));
            this.curLogFileName = logFile.getAbsolutePath();
        }
        catch (IOException ioe) {
            this.consoleMode();
            this.error(this, "couldn't open " + filename + " for logging " + ioe.getMessage());
        }
    }

    protected void consoleMode() {
        if (this.logWriter != null && this.mode != 0) {
            this.logWriter.close();
        }
        if (this.entryFormat == null) {
            this.entryFormat = this.dateTemplate == null || this.dateTemplate.equals("") ? new SimpleDateFormat("MMM dd HH:mm:ss") : new SimpleDateFormat(this.dateTemplate);
        }
        this.mode = 0;
        this.logWriter = new PrintWriter(new OutputStreamWriter(System.err));
        this.curLogFileName = "";
    }

    public static final int getLevel(String levelName) {
        for (int i = 0; i < LEVEL_NAME.length; ++i) {
            if (!LEVEL_NAME[i].equals(levelName)) continue;
            return i;
        }
        return -1;
    }

    protected static final int getMode(String modeName) {
        for (int i = 0; i < MODE_NAME.length; ++i) {
            if (!MODE_NAME[i].equals(modeName)) continue;
            return i;
        }
        return -1;
    }

    protected class Rotater {
        protected DateFormat fileFormat;
        protected Calendar cal = new GregorianCalendar();
        protected int value;
        protected int frequency;

        protected Rotater(String frequencyString) throws AnagramException {
            if (!Log.this.dateTemplate.equals("")) {
                Log.this.entryFormat = new SimpleDateFormat(Log.this.dateTemplate);
            } else if (frequencyString.equals("month")) {
                this.frequency = 2;
                this.fileFormat = new SimpleDateFormat(".MM-yyyy");
                Log.this.entryFormat = new SimpleDateFormat("MMM dd HH:mm:ss");
            } else if (frequencyString.equals("week")) {
                this.frequency = 3;
                this.fileFormat = new SimpleDateFormat(".MM-dd-yyyy");
                Log.this.entryFormat = new SimpleDateFormat("MMM dd HH:mm:ss");
            } else if (frequencyString.equals("day")) {
                this.frequency = 7;
                this.fileFormat = new SimpleDateFormat(".MM-dd-yyyy");
                Log.this.entryFormat = new SimpleDateFormat("HH:mm:ss");
            } else {
                throw new AnagramException("invalid rotation frequency " + frequencyString);
            }
            this.value = this.computeValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void check() {
            PrintWriter printWriter = Log.this.logWriter;
            synchronized (printWriter) {
                if (this.value != this.computeValue()) {
                    Log.this.open(this.getCurrentFileName());
                }
            }
        }

        protected int computeValue() {
            this.cal.setTime(new Date());
            return this.cal.get(this.frequency);
        }

        protected String getCurrentFileName() {
            String formatSuffix = this.fileFormat.format(new Date());
            return Log.this.logFileName + formatSuffix;
        }
    }
}

