/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.iges.anagram.AbstractModule;
import org.iges.anagram.AnagramException;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.ConfigException;
import org.iges.anagram.DirHandle;
import org.iges.anagram.Handle;
import org.iges.anagram.Module;
import org.iges.anagram.Privilege;
import org.iges.anagram.Setting;
import org.iges.anagram.service.ASCIIDataService;
import org.iges.anagram.service.AdminService;
import org.iges.anagram.service.BinaryDataService;
import org.iges.anagram.service.DASService;
import org.iges.anagram.service.DDSService;
import org.iges.anagram.service.DirectoryService;
import org.iges.anagram.service.HelpService;
import org.iges.anagram.service.InfoService;
import org.iges.anagram.service.Service;
import org.iges.anagram.service.THREDDSCatalogService;
import org.iges.anagram.service.UploadService;
import org.iges.anagram.service.VersionService;
import org.iges.anagram.service.XMLCatalogService;
import org.iges.util.FDSUtils;

public class Mapper
extends AbstractModule {
    public static String NO_CACHE = "/_nocache_/";
    protected Map services;

    public String getModuleID() {
        return "mapper";
    }

    public void configure(Setting setting) throws ConfigException {
        if (this.services == null) {
            this.createServices();
        }
        Iterator it = this.services.values().iterator();
        while (it.hasNext()) {
            Service service = (Service)it.next();
            Setting serviceSetting = null;
            try {
                serviceSetting = setting.getUniqueSubSetting(service.getModuleID());
            }
            catch (AnagramException ae) {
                throw new ConfigException(this, ae.getMessage());
            }
            boolean enabled = serviceSetting.getAttribute("enabled", "true").equals("true");
            service.setEnabled(enabled);
            service.configure(serviceSetting);
        }
    }

    protected void createServices() {
        this.services = new HashMap();
        this.services.put("admin", new AdminService());
        this.services.put("asc", new ASCIIDataService());
        this.services.put("ascii", this.services.get("asc"));
        this.services.put("das", new DASService());
        this.services.put("dds", new DDSService());
        this.services.put("dir", new DirectoryService());
        this.services.put("dods", new BinaryDataService());
        this.services.put("help", new HelpService());
        this.services.put("info", new InfoService());
        this.services.put("thredds", new THREDDSCatalogService());
        this.services.put("upload", new UploadService());
        this.services.put("ver", new VersionService());
        this.services.put("version", this.services.get("ver"));
        this.services.put("xml", new XMLCatalogService());
        Iterator it = this.services.values().iterator();
        while (it.hasNext()) {
            ((Module)it.next()).init(this.server, this);
        }
    }

    public ClientRequest map(HttpServletRequest request, HttpServletResponse response) {
        Privilege privilege = this.server.getPrivilegeMgr().getPrivilege(request);
        String url = FDSUtils.getServletPath(request);
        if (request.getQueryString() == null) {
            this.log.debug(this, "request URL is: " + url);
        } else {
            this.log.debug(this, "request URL is: " + url + "?" + request.getQueryString());
        }
        boolean useCache = !url.startsWith(NO_CACHE);
        Handle handle = this.server.getCatalog().getLocked(url);
        if (handle != null) {
            if (this.debug()) {
                this.log.debug(this, "got lock for handle: " + url);
            }
            return this.mapToHandle(request, response, handle, privilege, useCache);
        }
        return this.mapByExtension(request, response, url, privilege, useCache);
    }

    protected ClientRequest mapToHandle(HttpServletRequest request, HttpServletResponse response, Handle handle, Privilege privilege, boolean useCache) {
        Service service;
        if (handle instanceof DirHandle) {
            if (this.debug()) {
                this.debug(handle + " is a dir");
            }
            service = (Service)this.services.get("dir");
        } else {
            if (this.debug()) {
                this.debug(handle + " is a dataset");
            }
            service = (Service)this.services.get("info");
        }
        String dataPath = handle.getCompleteName();
        return new ClientRequest(request, response, privilege, service, service.getServiceName(), dataPath, handle, useCache);
    }

    protected ClientRequest mapByExtension(HttpServletRequest request, HttpServletResponse response, String url, Privilege privilege, boolean useCache) {
        int lastSlash;
        if (this.debug()) {
            this.debug("parsing extension");
        }
        if ((lastSlash = FDSUtils.lastIndexOf('/', url)) < 0) {
            lastSlash = 0;
        }
        String fileName = url.substring(lastSlash + 1);
        int lastDot = FDSUtils.lastIndexOf('.', fileName);
        String extension = null;
        extension = lastDot >= 0 ? fileName.substring(lastDot + 1) : "info";
        if (this.debug()) {
            this.debug("extension is " + extension);
        }
        Service service = (Service)this.services.get(extension);
        String dataPath = null;
        dataPath = lastDot >= 0 ? url.substring(0, url.length() - (extension.length() + 1)) : url;
        Handle handle = this.server.getCatalog().getLocked(dataPath);
        if (this.debug()) {
            this.log.debug(this, "got lock for handle: " + dataPath);
        }
        return new ClientRequest(request, response, privilege, service, extension, dataPath, handle, useCache);
    }
}

