/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.iges.anagram.AnagramException;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Server;
import org.iges.anagram.Setting;
import org.iges.anagram.filter.AnalysisFilter;
import org.iges.util.FDSUtils;
import org.w3c.dom.Element;

public class Privilege
extends Setting {
    protected SortedSet allowPaths;
    protected SortedSet denyPaths;
    protected SortedSet allowCommands;
    protected SortedSet denyCommands;
    protected String name;
    protected Privilege parent;

    public Privilege(String name, Element xml) {
        super(xml);
        this.name = name;
        this.allowPaths = this.sortPathTags("allow");
        this.denyPaths = this.sortPathTags("deny");
        this.allowCommands = this.sortCommandTags("allow");
        this.denyCommands = this.sortCommandTags("deny");
    }

    protected void setParent(Privilege parent) throws AnagramException {
        Privilege ancestor = parent;
        while (ancestor != null) {
            if (ancestor == this) {
                throw new AnagramException("circular relationship between privileges " + this.getName() + " and " + parent.getName());
            }
            ancestor = parent.getParent();
        }
        this.parent = parent;
    }

    protected Privilege getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getAttribute(String name, String defaultValue) {
        String value = super.getAttribute(name, "");
        if (value.equals("")) {
            value = this.parent == null ? defaultValue : this.getParent().getAttribute(name, defaultValue);
        }
        return value;
    }

    public long getNumAttribute(String name, long defaultValue) {
        long value = super.getNumAttribute(name, Long.MIN_VALUE);
        if (value == Long.MIN_VALUE) {
            value = this.parent == null ? defaultValue : this.getParent().getNumAttribute(name, defaultValue);
        }
        return value;
    }

    public boolean allowsPath(String path) throws ModuleException {
        if ((path = this.standardizePath(path)).indexOf(AnalysisFilter.ANALYSIS_PREFIX) < 0 || path.startsWith("http://")) {
            return this.allowsPath(path, null, null);
        }
        return Server.getServer().getTool().allowAnalysis(path, this);
    }

    protected boolean allowsPath(String path, String childAllowPath, String childDenyPath) {
        String localAllow = this.getClosestPathMatch(childAllowPath, this.allowPaths, path);
        String localDeny = this.getClosestPathMatch(childDenyPath, this.denyPaths, path);
        boolean allAllowed = this.allowPaths.contains("all");
        boolean allDenied = this.denyPaths.contains("all");
        if (allAllowed || allDenied) {
            if (localAllow == null) {
                if (allAllowed) {
                    return localDeny == null;
                }
                return false;
            }
            if (localDeny == null) {
                return true;
            }
            return localAllow.length() >= localDeny.length();
        }
        if (this.parent != null) {
            return this.parent.allowsPath(path, localAllow, localDeny);
        }
        if (localDeny == null) {
            return true;
        }
        if (localAllow == null) {
            return false;
        }
        return localAllow.length() >= localDeny.length();
    }

    public boolean everAllowsPath(String path) {
        path = this.standardizePath(path);
        try {
            if (this.allowsPath(path)) {
                return true;
            }
            return this.checkForAllowedSubPath(path);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean checkForAllowedSubPath(String path) {
        if (this.allowPaths.contains("all")) {
            return true;
        }
        Iterator it = this.allowPaths.headSet(path).iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!this.isParentPath(next, path)) continue;
            return true;
        }
        if (this.denyPaths.contains("all")) {
            return false;
        }
        if (this.parent != null) {
            return this.parent.checkForAllowedSubPath(path);
        }
        return false;
    }

    protected String getClosestPathMatch(String childMatch, SortedSet pathSet, String path) {
        String localMatch = null;
        Iterator it = pathSet.tailSet(path).iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!this.isParentPath(path, next)) continue;
            localMatch = next;
        }
        if (childMatch == null) {
            return localMatch;
        }
        if (localMatch == null) {
            return childMatch;
        }
        if (localMatch.length() >= childMatch.length()) {
            return localMatch;
        }
        return childMatch;
    }

    protected boolean isParentPath(String childPath, String parentPath) {
        if (childPath.equals(parentPath)) {
            return true;
        }
        if (childPath.startsWith(parentPath)) {
            char ch = childPath.charAt(parentPath.length());
            if (ch == '/') {
                return true;
            }
            return parentPath.startsWith("http:/") && ch == ':';
        }
        return false;
    }

    protected SortedSet sortPathTags(String tagName) {
        TreeSet returnVal = new TreeSet(Collections.reverseOrder());
        Iterator it = this.getSubSettings(tagName).iterator();
        while (it.hasNext()) {
            String path = ((Setting)it.next()).getAttribute("path");
            if (path.equals("")) continue;
            path = this.standardizePath(path);
            returnVal.add(path);
        }
        return returnVal;
    }

    protected String standardizePath(String path) {
        if (!((path = FDSUtils.stripSpacesFrom(path)).equals("") || path.equals("/") || path.startsWith("http:/") || path.equals("all"))) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    public boolean allowsCommand(String cmmd) throws AnagramException {
        cmmd = FDSUtils.compactSpacesFor(cmmd);
        return this.allowsCommand(cmmd, null, null);
    }

    protected boolean allowsCommand(String cmmd, String childAllowCommand, String childDenyCommand) {
        if (cmmd.toUpperCase().indexOf("SPAWN") >= 0) {
            return false;
        }
        String localAllow = this.getClosestCommandMatch(childAllowCommand, this.allowCommands, cmmd);
        String localDeny = this.getClosestCommandMatch(childDenyCommand, this.denyCommands, cmmd);
        boolean allAllowed = this.allowCommands.contains("all");
        boolean allDenied = this.denyCommands.contains("all");
        if (allAllowed || allDenied) {
            if (localAllow == null) {
                if (allAllowed) {
                    return localDeny == null;
                }
                return false;
            }
            if (localDeny == null) {
                return true;
            }
            return localAllow.length() >= localDeny.length();
        }
        if (this.parent != null) {
            return this.parent.allowsCommand(cmmd, localAllow, localDeny);
        }
        if (localDeny == null) {
            return true;
        }
        if (localAllow == null) {
            return false;
        }
        return localAllow.length() >= localDeny.length();
    }

    protected String getClosestCommandMatch(String childMatch, SortedSet cmmdSet, String cmmd) {
        String localMatch = null;
        Iterator it = cmmdSet.tailSet(cmmd).iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!this.isParentCommand(cmmd, next)) continue;
            localMatch = next;
        }
        if (childMatch == null) {
            return localMatch;
        }
        if (localMatch == null) {
            return childMatch;
        }
        if (localMatch.length() >= childMatch.length()) {
            return localMatch;
        }
        return childMatch;
    }

    protected boolean isParentCommand(String childCommand, String parentCommand) {
        if (childCommand.equals(parentCommand)) {
            return true;
        }
        if (childCommand.startsWith(parentCommand)) {
            char c = childCommand.charAt(parentCommand.length());
            return !(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z');
        }
        return false;
    }

    protected SortedSet sortCommandTags(String tagName) {
        TreeSet returnVal = new TreeSet(Collections.reverseOrder());
        Iterator it = this.getSubSettings(tagName).iterator();
        while (it.hasNext()) {
            String commands = ((Setting)it.next()).getAttribute("commands");
            if (commands.equals("")) continue;
            StringTokenizer cmmdList = new StringTokenizer(commands, ",");
            while (cmmdList.hasMoreTokens()) {
                String cmmd = cmmdList.nextToken();
                if (cmmd == null || cmmd.equals("")) continue;
                try {
                    cmmd = FDSUtils.compactSpacesFor(cmmd);
                }
                catch (AnagramException ae) {
                    continue;
                }
                returnVal.add(cmmd);
            }
        }
        return returnVal;
    }
}

