/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.iges.anagram.AbstractModule;
import org.iges.anagram.AnagramError;
import org.iges.anagram.AnagramException;
import org.iges.anagram.ConfigException;
import org.iges.anagram.Module;
import org.iges.anagram.Privilege;
import org.iges.anagram.Setting;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PrivilegeMgr
extends AbstractModule {
    protected SortedMap ipRanges;
    protected Map privileges;
    protected Document privilegeDocument;
    protected Privilege defaultPrivilege;

    public PrivilegeMgr() {
        try {
            DocumentBuilder blankBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.privilegeDocument = blankBuilder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new AnagramError("XML parser configuration error." + pce.getMessage());
        }
    }

    public final String getModuleID() {
        return "privilege_mgr";
    }

    public void configure(Setting setting) throws ConfigException {
        this.buildPrivileges(setting);
        this.buildInheritance(setting);
        this.buildIPRanges(setting);
        this.setDefaultPrivilege(setting);
    }

    public Privilege getPrivilege(HttpServletRequest request) {
        String requestIP = request.getRemoteAddr();
        Iterator it = this.ipRanges.keySet().iterator();
        while (it.hasNext()) {
            String mask = (String)it.next();
            if (!this.isIPInRange(requestIP, mask)) continue;
            return (Privilege)this.ipRanges.get(mask);
        }
        if (this.debug()) {
            this.log.debug(this, "returning default privilege");
        }
        return this.defaultPrivilege;
    }

    protected void buildPrivileges(Setting setting) {
        List privilegeSettings = setting.getSubSettings("privilege");
        this.privileges = new HashMap();
        Iterator it = privilegeSettings.iterator();
        while (it.hasNext()) {
            Setting current = (Setting)it.next();
            String name = current.getAttribute("name");
            if (name.equals("")) {
                this.log.error(this, "privilege tag has no name attribute; skipping");
                continue;
            }
            this.verbose("creating privilege level " + name);
            try {
                Element imported = (Element)this.privilegeDocument.importNode(current.getXML(), true);
                this.privileges.put(name, new Privilege(name, imported));
            }
            catch (DOMException de) {
                throw new AnagramError(de.getMessage());
            }
        }
    }

    protected void buildInheritance(Setting setting) throws ConfigException {
        List privilegeSettings = setting.getSubSettings("privilege");
        Iterator it = privilegeSettings.iterator();
        while (it.hasNext()) {
            Setting current = (Setting)it.next();
            String parentName = current.getAttribute("inherit");
            String name = current.getAttribute("name");
            Privilege privilege = (Privilege)this.privileges.get(name);
            if (privilege == null || parentName.equals("")) continue;
            Privilege parent = (Privilege)this.privileges.get(parentName);
            if (parent == null) {
                throw new ConfigException((Module)this, "inheriting from non-existent privilege", current);
            }
            try {
                this.verbose(name + " inherits from " + parent);
                privilege.setParent(parent);
            }
            catch (AnagramException ae) {
                throw new ConfigException((Module)this, ae.getMessage(), current);
            }
        }
    }

    protected void setDefaultPrivilege(Setting setting) throws ConfigException {
        if (setting.getAttribute("default").equals("")) {
            if (this.verbose()) {
                this.verbose("creating empty default privilege");
            }
            Element blankDefault = this.privilegeDocument.createElement("privilege");
            this.defaultPrivilege = new Privilege("default", blankDefault);
        } else {
            String defaultName = setting.getAttribute("default");
            this.defaultPrivilege = (Privilege)this.privileges.get(defaultName);
            if (this.defaultPrivilege == null) {
                throw new ConfigException((Module)this, "default attribute set to nonexistent privilege", setting);
            }
        }
    }

    protected void buildIPRanges(Setting setting) {
        this.ipRanges = new TreeMap(Collections.reverseOrder());
        List ipRangeSettings = setting.getSubSettings("ip_range");
        Iterator it = ipRangeSettings.iterator();
        while (it.hasNext()) {
            Setting current = (Setting)it.next();
            String mask = current.getAttribute("mask");
            if (mask.equals("")) {
                this.log.error(this, "ip_range tag has no mask attribute; skipping");
                continue;
            }
            String name = current.getAttribute("privilege");
            if (name.equals("")) {
                this.log.error(this, "ip_range tag has no privilege attribute; skipping");
                continue;
            }
            Privilege privilege = (Privilege)this.privileges.get(name);
            if (privilege == null) {
                this.log.error(this, "ip_range tag refers to non-existent privilege " + name + "; skipping");
                continue;
            }
            this.ipRanges.put(mask, privilege);
        }
    }

    protected boolean isIPInRange(String requestIP, String rangeIP) {
        byte[] maskedInputAddress = new byte[4];
        byte[] maskedCompareAddress = new byte[4];
        try {
            InetAddress compareIP;
            InetAddress inputIP;
            try {
                inputIP = InetAddress.getByName(requestIP);
            }
            catch (UnknownHostException uhe1) {
                throw new UnknownHostException("Incorrect input IP address");
            }
            byte[] inputAddress = inputIP.getAddress();
            StringTokenizer st = new StringTokenizer(rangeIP, "/");
            if (st.hasMoreTokens()) {
                try {
                    compareIP = InetAddress.getByName(st.nextToken());
                }
                catch (UnknownHostException uhe2) {
                    throw new UnknownHostException("Incorrect compare IP address");
                }
            } else {
                throw new UnknownHostException("No compare IP address");
            }
            byte[] compareAddress = compareIP.getAddress();
            if (st.hasMoreTokens()) {
                InetAddress subnetIP;
                try {
                    subnetIP = InetAddress.getByName(st.nextToken());
                }
                catch (UnknownHostException uhe3) {
                    throw new UnknownHostException("Incorret subnet IP address");
                }
                byte[] subnetAddress = subnetIP.getAddress();
                for (int i = 0; i < 4; ++i) {
                    if ((compareAddress[i] & subnetAddress[i]) == (inputAddress[i] & subnetAddress[i])) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    if (compareAddress[i] == inputAddress[i]) continue;
                    return false;
                }
            }
            return true;
        }
        catch (UnknownHostException uhe) {
            this.info("error:\"" + uhe.getMessage() + "\"");
            return false;
        }
    }
}

