/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.iges.anagram.AnagramException;
import org.iges.anagram.AnagramServlet;
import org.iges.anagram.Catalog;
import org.iges.anagram.ConfigException;
import org.iges.anagram.Log;
import org.iges.anagram.Mapper;
import org.iges.anagram.Module;
import org.iges.anagram.ModuleException;
import org.iges.anagram.PrivilegeMgr;
import org.iges.anagram.Setting;
import org.iges.anagram.Store;
import org.iges.anagram.Tool;
import org.iges.util.ExclusiveLock;
import org.iges.util.FileResolver;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class Server
implements Module {
    protected static Server server;
    protected ExclusiveLock synch;
    protected int outputLevel = 3;
    protected String implClass;
    protected String implName = "anagram";
    protected String implLongName;
    protected String implVersion;
    protected String implHome;
    protected String serverName;
    protected String siteHome;
    protected String serverHome;
    protected File configFile;
    protected long lastConfigTime;
    protected long startTime;
    protected Tool tool;
    protected Mapper mapper;
    protected Log log;
    protected Store store;
    protected Catalog catalog;
    protected PrivilegeMgr privilegeMgr;
    protected AnagramServlet servlet;

    public ExclusiveLock getSynch() {
        return this.synch;
    }

    public String getModuleID() {
        return this.implName;
    }

    public String getModuleName() {
        return this.implName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getSiteHomePage(String defaultHome) {
        if (this.siteHome.equals("")) {
            return defaultHome;
        }
        return this.siteHome;
    }

    public String getHome() {
        return this.serverHome;
    }

    public String getImplName() {
        return this.implLongName;
    }

    public String getImplVersion() {
        return this.implVersion;
    }

    public String getImplHomePage() {
        return this.implHome;
    }

    private Server(AnagramServlet servlet, ServletConfig servletConfig) throws ServletException {
        this.servlet = servlet;
        this.synch = new ExclusiveLock();
    }

    public static Server createServer(AnagramServlet servlet, ServletConfig servletConfig) throws ServletException {
        if (server == null) {
            server = new Server(servlet, servletConfig);
        }
        return server;
    }

    public static Server getServer() {
        return server;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        String outputSetting = this.getProperty(servletConfig, "anagram.output", "debug");
        for (int i = 0; i < 6; ++i) {
            if (!Log.LEVEL_NAME[i].equals(outputSetting)) continue;
            this.outputLevel = i;
            break;
        }
        this.log(1, "output level is " + Log.LEVEL_NAME[this.outputLevel]);
        this.implName = this.getProperty(servletConfig, "anagram.impl", "anagram");
        this.serverHome = this.getProperty(servletConfig, "anagram.home", servletConfig.getServletContext().getRealPath("/") + this.implName);
        this.startLog();
        this.log(2, "serverHome = " + this.serverHome);
        this.log(2, "anagram.impl = " + this.implName);
        this.implLongName = this.getProperty(servletConfig, "anagram.impl_long", "Anagram data server framework");
        this.implVersion = this.getProperty(servletConfig, "anagram.impl_version", "1.0");
        this.implClass = this.getProperty(servletConfig, "anagram.impl_class", "");
        this.implHome = this.getProperty(servletConfig, "anagram.impl_home", "http://www.iges.org/grads/gds");
        String configFilename = this.getProperty(servletConfig, "anagram.config", this.implName + ".xml");
        this.configFile = FileResolver.resolve(this.serverHome, configFilename);
        try {
            Setting serverSetting = this.loadConfig();
            this.createModules();
            this.configure(serverSetting);
            String msg = "started ok";
            if (this.log != null) {
                this.log(2, msg);
            }
            System.err.println("anagram: " + msg);
        }
        catch (ConfigException ce) {
            String msg = "invalid configuration: " + ce.getMessage();
            this.fail(msg, ce);
        }
        catch (Throwable t) {
            StringWriter debugInfo = new StringWriter();
            PrintWriter p = new PrintWriter(debugInfo);
            t.printStackTrace(p);
            String msg = "oops, exception " + t.getClass() + " was not caught.\n" + "please report this as a bug, along with " + "the following debug info:\n" + debugInfo.toString();
            this.fail(msg, t);
        }
    }

    protected void fail(String msg, Throwable t) throws ServletException {
        if (this.log != null) {
            this.log(3, msg);
        }
        System.err.println("anagram: " + msg);
        String failMsg = "startup failed. you must shut down Tomcat manually.";
        if (this.log != null) {
            this.log(4, failMsg + "\n\n");
        }
        System.err.println("anagram: " + failMsg);
        throw new ServletException("");
    }

    public void init(Server server, Module parent) {
    }

    public void reconfigure() throws ModuleException {
        try {
            Setting serverSetting = this.loadConfig();
            this.configure(serverSetting);
            String msg = "reconfigured ok";
            if (this.log != null) {
                this.log(2, msg);
            }
            System.err.println("anagram: " + msg);
        }
        catch (ConfigException ce) {
            String msg = "invalid configuration: " + ce.getMessage();
            System.err.println("anagram: " + msg);
            throw new ModuleException((Module)this, msg, ce);
        }
    }

    public void configure(Setting setting) throws ConfigException {
        this.lastConfigTime = this.startTime = System.currentTimeMillis();
        this.log(1, "starting configuration");
        this.serverName = setting.getAttribute("name", this.implLongName);
        this.siteHome = setting.getAttribute("home");
        if (this.siteHome.endsWith("/")) {
            this.siteHome = this.siteHome.substring(0, this.siteHome.length() - 1);
        }
        this.configModule(this.log, setting);
        this.configModule(this.store, setting);
        this.configModule(this.tool, setting);
        this.configModule(this.mapper, setting);
        this.configModule(this.privilegeMgr, setting);
        this.configModule(this.servlet, setting);
        this.configModule(this.catalog, setting);
        this.log(1, "finished configuration");
    }

    public long getLastConfigTime() {
        return this.lastConfigTime;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public AnagramServlet getServlet() {
        return this.servlet;
    }

    public Tool getTool() {
        return this.tool;
    }

    public Log getLog() {
        return this.log;
    }

    public Store getStore() {
        return this.store;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public PrivilegeMgr getPrivilegeMgr() {
        return this.privilegeMgr;
    }

    public void destroy() {
        this.catalog.destroy();
        this.tool.destroy();
        this.log(2, "shutting down\n\n");
    }

    protected String getProperty(ServletConfig config, String name, String defaultValue) {
        String value = config.getInitParameter(name);
        if (value != null) {
            this.log(1, "property " + name + " found as servlet param ");
            this.log(2, name + " = " + value);
            return value;
        }
        value = config.getServletContext().getInitParameter(name);
        if (value != null) {
            this.log(1, "property " + name + " found as servlet context param ");
            this.log(2, name + " = " + value);
            return value;
        }
        value = System.getProperty(name);
        if (value != null) {
            this.log(1, "property " + name + " found as system property ");
            this.log(2, name + " = " + value);
            return value;
        }
        this.log(1, "property " + name + " not found; using default");
        value = defaultValue;
        this.log(2, name + " = " + value);
        return value;
    }

    protected Setting loadConfig() throws ConfigException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xmlConfig = builder.parse(this.configFile);
            this.log(2, "loaded config file " + this.configFile.getAbsolutePath());
            return new Setting(this.implName, xmlConfig);
        }
        catch (SAXParseException spe) {
            throw new ConfigException(this, "couldn't parse config file at line " + spe.getLineNumber() + ": " + spe.getMessage());
        }
        catch (Exception e) {
            throw new ConfigException(this, "error parsing config file: " + e.getMessage());
        }
    }

    protected void startLog() {
        this.log = new Log();
        this.log.init(this, this);
    }

    protected void createModules() throws ConfigException {
        this.log(1, "creating tool " + this.implClass);
        try {
            this.tool = (Tool)Class.forName(this.implClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(this, "class not found: " + this.implClass);
        }
        catch (InstantiationException e) {
            throw new ConfigException(this, "class could not be instantiated: " + this.implClass);
        }
        catch (IllegalAccessException e) {
            throw new ConfigException(this, "class could not be instantiated: " + this.implClass);
        }
        catch (ClassCastException e) {
            throw new ConfigException(this, "class does not extend org.iges.anagram.tool.Tool: " + this.implClass);
        }
        this.tool.init(this, this);
        this.log(1, "creating mapper");
        this.mapper = new Mapper();
        this.mapper.init(this, this);
        this.log(1, "creating store");
        this.store = new Store();
        this.store.init(this, this);
        this.log(1, "creating catalog");
        this.catalog = new Catalog();
        this.catalog.init(this, this);
        this.log(1, "creating privilege mgr");
        this.privilegeMgr = new PrivilegeMgr();
        this.privilegeMgr.init(this, this);
        this.servlet.init(this, this);
    }

    protected void configModule(Module module, Setting setting) throws ConfigException {
        try {
            Setting moduleSetting = setting.getUniqueSubSetting(module.getModuleID());
            module.configure(moduleSetting);
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (AnagramException ae) {
            throw new ConfigException((Module)this, ae.getMessage(), setting);
        }
    }

    protected void log(int level, String msg) {
        if (this.log == null) {
            if (level >= this.outputLevel) {
                System.err.print("anagram: ");
                if (level >= 3) {
                    System.err.print("error: ");
                }
                System.err.println(msg);
            }
        } else {
            this.log.log(level, this, msg);
        }
    }
}

