/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import java.util.ArrayList;
import java.util.List;
import org.iges.anagram.AnagramException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class Setting {
    protected Element xml;

    public Setting(Element xml) {
        this.xml = xml;
    }

    public Setting(String name, Document document) throws AnagramException {
        NodeList xmlList = document.getElementsByTagName(name);
        this.xml = this.uniqueElement(name, document, xmlList);
    }

    public List getSubSettings(String name) {
        ArrayList<Setting> subSettings = new ArrayList<Setting>();
        NodeList xmlList = this.xml.getElementsByTagName(name);
        for (int i = 0; i < xmlList.getLength(); ++i) {
            subSettings.add(new Setting((Element)xmlList.item(i)));
        }
        return subSettings;
    }

    public Setting getUniqueSubSetting(String name) throws AnagramException {
        NodeList xmlList = this.xml.getElementsByTagName(name);
        Document document = this.xml.getOwnerDocument();
        return new Setting(this.uniqueElement(name, document, xmlList));
    }

    public Element getXML() {
        return this.xml;
    }

    public long getNumAttribute(String name, long defaultValue) {
        if (this.xml.getAttribute(name) == "") {
            return defaultValue;
        }
        try {
            return Long.valueOf(this.xml.getAttribute(name));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public String getAttribute(String name) {
        return this.getAttribute(name, "");
    }

    public String getAttribute(String name, String defaultValue) {
        if (this.xml.getAttribute(name) == "") {
            return defaultValue;
        }
        return this.xml.getAttribute(name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(this.xml.getTagName());
        NamedNodeMap map = this.xml.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            sb.append(" ");
            sb.append(((Attr)map.item(i)).getName());
            sb.append("=\"");
            sb.append(((Attr)map.item(i)).getValue());
            sb.append("\"");
        }
        List subSettings = this.getSubSettings("*");
        if (subSettings.size() == 0) {
            sb.append("/>");
        } else {
            sb.append(">");
        }
        return sb.toString();
    }

    protected Element uniqueElement(String name, Document document, NodeList tagList) throws AnagramException {
        if (tagList.getLength() < 1) {
            return document.createElement(name);
        }
        if (tagList.getLength() > 1) {
            throw new AnagramException("duplicate tags for " + name);
        }
        return (Element)tagList.item(0);
    }
}

