/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram;

import java.io.File;
import java.io.IOException;
import org.iges.anagram.AbstractModule;
import org.iges.anagram.ConfigException;
import org.iges.anagram.Module;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Setting;
import org.iges.util.FileResolver;

public class Store
extends AbstractModule {
    protected File baseDir;

    public String getModuleID() {
        return "store";
    }

    public void configure(Setting setting) throws ConfigException {
        String workDirName = setting.getAttribute("work_dir", "temp");
        this.baseDir = FileResolver.resolve(this.server.getHome(), workDirName);
        this.log.verbose(this, "temp dir is " + this.baseDir.getAbsolutePath());
        if (!this.baseDir.exists() && !this.baseDir.mkdirs()) {
            throw new ConfigException(this, "couldn't create temp dir " + this.baseDir.getAbsolutePath());
        }
    }

    public File get(Module module, String entryName, long staleTime) {
        File entryFile = this.get(module, entryName);
        if (entryFile.exists() && entryFile.lastModified() < staleTime) {
            entryFile.delete();
        }
        return entryFile;
    }

    public File get(Module module, String entryName) {
        File entryFile = this.resolve(module, entryName);
        if (!entryFile.exists()) {
            File entryDir = entryFile.getParentFile();
            this.mkdirs(entryDir);
        }
        return entryFile;
    }

    public File get(Module module, String prefix, String suffix) throws ModuleException {
        File prefixFile = this.resolve(module, prefix);
        File entryDir = prefixFile.getParentFile();
        this.mkdirs(entryDir);
        try {
            File entryFile = File.createTempFile(prefixFile.getName(), suffix, entryDir);
            return entryFile;
        }
        catch (IOException ioe) {
            throw new RuntimeException("couldn't create temp file for " + module + " using pattern " + prefix + " ... " + suffix + "; " + ioe.getClass());
        }
    }

    public void deleteFile(String fileName) {
        this.deleteFile(fileName, 0L);
    }

    public void deleteFile(String fileName, long time) {
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        if (!file.getAbsolutePath().startsWith(this.baseDir.getAbsolutePath())) {
            return;
        }
        if (file.exists() && (file.lastModified() <= time || time == 0L)) {
            file.delete();
            for (File parent = file.getParentFile(); parent != null && parent.exists() && parent.getAbsolutePath().startsWith(this.baseDir.getAbsolutePath()) && parent.listFiles().length <= 0; parent = parent.getParentFile()) {
                parent.delete();
            }
        }
    }

    protected void mkdirs(File entryDir) {
        if (!entryDir.exists()) {
            if (!entryDir.mkdirs()) {
                this.log.critical(this, "couldn't create directory " + entryDir.getAbsolutePath());
            } else if (this.verbose()) {
                this.log.verbose(this, "created dir " + entryDir.getAbsolutePath());
            }
        }
    }

    protected File resolve(Module module, String entryName) {
        File entryFile = new File(this.baseDir, module.getModuleName() + "/" + entryName);
        return entryFile;
    }

    public void clearCacheFor(Module module) {
        File moduleRoot = new File(this.baseDir, module.getModuleName());
        this.remove(moduleRoot);
    }

    protected void remove(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.remove(fileArray[i]);
                }
            }
            file.delete();
        }
    }
}

