/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.ConfigException;
import org.iges.anagram.Module;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Setting;
import org.iges.anagram.filter.Filter;

public class AbuseFilter
extends Filter {
    private Map ipList = new HashMap();
    private long lastCleaning;
    private static long staleTime = 86400000L;
    private int countWindowMins = 60;
    protected long defaultHitLimit;
    protected long defaultTimeout;

    public String getFilterName() {
        return "abuse";
    }

    public void configure(Setting setting) throws ConfigException {
        super.configure(setting);
        this.defaultHitLimit = setting.getNumAttribute("hits", 0L);
        if (this.debug()) {
            this.debug("default hit limit set to " + this.defaultHitLimit);
        }
        this.defaultTimeout = setting.getNumAttribute("timeout", 1L);
        if (this.debug()) {
            this.debug("default timeout set to " + this.defaultTimeout);
        }
    }

    protected void doFilter(ClientRequest clientRequest) throws ModuleException {
        long now = System.currentTimeMillis();
        long hitLimit = clientRequest.getPrivilege().getNumAttribute("abuse_hits", this.defaultHitLimit);
        if (hitLimit != 0L) {
            this.checkBlock(clientRequest, now, hitLimit);
        } else if (this.debug()) {
            this.debug("no hit limit set");
        }
        this.next.handle(clientRequest);
    }

    protected File blockFile(String ip) {
        return this.server.getStore().get(this, ip);
    }

    protected HitLimiter loadBlock(String ip) {
        if (this.debug()) {
            this.debug("checking for saved block for " + ip);
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.blockFile(ip))));
            HitLimiter returnVal = (HitLimiter)in.readObject();
            in.close();
            if (this.debug()) {
                this.debug("loaded block for " + ip);
            }
            return returnVal;
        }
        catch (IOException ioe) {
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    protected void saveBlock(String ip, HitLimiter limiter) {
        if (this.debug()) {
            this.debug("saving block for " + ip);
        }
        try {
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.blockFile(ip))));
            out.writeObject(limiter);
            out.close();
        }
        catch (IOException ioe) {
            this.error("failed writing abuse block for " + ip + " to disk");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkBlock(ClientRequest clientRequest, long now, long hitLimit) throws ModuleException {
        HitLimiter limiter;
        HttpServletRequest request = clientRequest.getHttpRequest();
        String clientIP = request.getRemoteAddr();
        long abuseTimeout = clientRequest.getPrivilege().getNumAttribute("abuse_timeout", this.defaultTimeout);
        if (this.debug()) {
            this.debug("checking whether " + clientIP + " is blocked");
        }
        if (this.debug()) {
            this.debug("hit limit is " + hitLimit + ", timeout is " + abuseTimeout);
        }
        Map map = this.ipList;
        synchronized (map) {
            limiter = (HitLimiter)this.ipList.get(clientIP);
            if (limiter == null) {
                limiter = this.loadBlock(clientIP);
                if (limiter == null) {
                    if (this.debug()) {
                        this.debug("starting hit count for " + clientIP);
                    }
                    limiter = new HitLimiter();
                }
                this.ipList.put(clientIP, limiter);
            }
        }
        boolean blocked = limiter.isBlocked(now, abuseTimeout);
        if (!blocked) {
            limiter.addHit(now);
            if (limiter.exceeded(now, hitLimit)) {
                this.info("limit of " + hitLimit + " hits per hour exceeded by " + clientIP + " (resolves to " + request.getRemoteHost() + ")");
                this.info("blocking " + clientIP + " for " + abuseTimeout + " hours");
                this.saveBlock(clientIP, limiter);
                blocked = true;
            }
        }
        if (blocked) {
            if (!this.blockFile(clientIP).exists()) {
                this.info("block file was deleted for " + clientIP + "; restarting hit count");
                this.ipList.remove(clientIP);
            } else {
                throw new ModuleException((Module)this, limiter.getMessage(abuseTimeout), "sent block message to client");
            }
        }
        this.cleanIPList(now, abuseTimeout);
    }

    private void cleanIPList(long now, long timeoutMins) {
        if (now - this.lastCleaning > staleTime) {
            if (this.debug()) {
                this.debug("looking for stale hit counters");
            }
            Iterator it = this.ipList.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                HitLimiter limiter = (HitLimiter)entry.getValue();
                if (!limiter.isStale(now, staleTime)) continue;
                if (this.debug()) {
                    this.debug("removing stale hit counter for " + entry.getKey());
                }
                it.remove();
            }
            this.lastCleaning = now;
        }
    }

    protected class HitLimiter
    implements Serializable {
        private long lastTimeMins;
        private long blockedTimeMins;
        private long[] hits;
        private String message;
        private long messageTimeout;

        HitLimiter() {
            this.hits = new long[AbuseFilter.this.countWindowMins];
            this.lastTimeMins = 0L;
            this.blockedTimeMins = 0L;
        }

        public String getMessage(long timeoutMins) {
            if (this.message == null || this.messageTimeout != timeoutMins) {
                this.messageTimeout = timeoutMins;
                this.message = "Sorry, your IP has been blocked because of excessive requests.\nPlease check that any scripts you are running function correctly and \nare as efficient as possible.\nAccess will be automatically restored after " + timeoutMins / 60L + " hours.\n" + "Contact the server administrator if you have questions.";
            }
            return this.message;
        }

        public boolean isBlocked(long now, long timeoutMins) {
            long nowMins = now / 60000L;
            if (this.blockedTimeMins != 0L) {
                return this.checkBlockedTime(nowMins, timeoutMins);
            }
            return false;
        }

        private boolean checkBlockedTime(long nowMins, long timeoutMins) {
            if (nowMins - this.blockedTimeMins > timeoutMins) {
                this.blockedTimeMins = 0L;
                this.message = null;
                return false;
            }
            return true;
        }

        public boolean exceeded(long now, long hitLimit) {
            long nowMins = now / 60000L;
            if (this.hitCount() > hitLimit) {
                this.blockedTimeMins = nowMins;
                return true;
            }
            return false;
        }

        public boolean isStale(long now, long staleTime) {
            long nowMins = now / 60000L;
            return nowMins - this.lastTimeMins > staleTime;
        }

        private long hitCount() {
            long count = 0L;
            for (int i = 0; i < this.hits.length; ++i) {
                count += this.hits[i];
            }
            if (AbuseFilter.this.debug()) {
                AbuseFilter.this.debug("cumulative hit count is " + count);
            }
            return count;
        }

        public void addHit(long now) {
            int bin;
            long nowMins = now / 60000L;
            this.updateBins(nowMins);
            int n = bin = (int)(nowMins % (long)AbuseFilter.this.countWindowMins);
            this.hits[n] = this.hits[n] + 1L;
            this.lastTimeMins = nowMins;
            if (AbuseFilter.this.debug()) {
                AbuseFilter.this.debug("adding hit. hits this minute: " + this.hits[bin]);
            }
        }

        private void updateBins(long nowMins) {
            int endBin;
            if (nowMins == this.lastTimeMins || this.lastTimeMins == 0L) {
                return;
            }
            if (nowMins - this.lastTimeMins >= (long)AbuseFilter.this.countWindowMins) {
                Arrays.fill(this.hits, 0L);
                return;
            }
            int startBin = (int)((this.lastTimeMins + 1L) % (long)AbuseFilter.this.countWindowMins);
            if (startBin >= (endBin = (int)((nowMins + 1L) % (long)AbuseFilter.this.countWindowMins))) {
                Arrays.fill(this.hits, startBin, this.hits.length, 0L);
                Arrays.fill(this.hits, 0, endBin, 0L);
            } else {
                Arrays.fill(this.hits, startBin, endBin, 0L);
            }
        }
    }
}

