/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.filter;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.ModuleException;
import org.iges.anagram.TempDataHandle;
import org.iges.anagram.filter.Filter;

public class AnalysisFilter
extends Filter {
    public static String ANALYSIS_PREFIX = "/_expr_";
    protected List applicable;
    protected List generating = new LinkedList();

    public AnalysisFilter() {
        this.applicable = Arrays.asList("dds", "das", "dods", "info", "asc", "ascii");
    }

    public String getFilterName() {
        return "analysis";
    }

    protected void doFilter(ClientRequest clientRequest) throws ModuleException {
        if (this.applicable.contains(clientRequest.getServiceName()) && clientRequest.getHandle() == null && clientRequest.getDataPath().indexOf(ANALYSIS_PREFIX) >= 0) {
            this.doAnalysis(clientRequest);
        } else if (this.debug()) {
            this.debug("no analysis to do");
        }
        this.next.handle(clientRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doAnalysis(ClientRequest clientRequest) throws ModuleException {
        String name = clientRequest.getDataPath();
        List list2 = this.generating;
        synchronized (list2) {
            while (this.generating.contains(name)) {
                if (this.debug()) {
                    this.log.debug(this, clientRequest + "waiting for analysis to complete");
                }
                try {
                    this.generating.wait(0L);
                }
                catch (InterruptedException ie) {}
            }
            if (this.server.getCatalog().contains(name)) {
                if (!this.debug()) return;
                this.log.debug(this, clientRequest + "analysis result already in cache");
                return;
            }
            this.log.info(this, "evaluating analysis expression: " + name);
            this.generating.add(name);
        }
        try {
            block14: {
                TempDataHandle result = this.server.getTool().doAnalysis(name, clientRequest.getHttpRequest(), clientRequest.getPrivilege());
                this.server.getCatalog().addTemp(result);
                clientRequest.setHandle(this.server.getCatalog().getLocked(clientRequest.getDataPath()));
                if (!this.debug()) break block14;
                this.log.debug(this, clientRequest + "finished analysis");
            }
            Object var7_6 = null;
            List list = this.generating;
            synchronized (list) {
                this.generating.remove(name);
                this.generating.notifyAll();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            List list = this.generating;
            synchronized (list) {
                this.generating.remove(name);
                this.generating.notifyAll();
                throw throwable;
            }
        }
    }
}

