/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.filter;

import org.iges.anagram.AbstractModule;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.ConfigException;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Setting;

public abstract class Filter
extends AbstractModule {
    protected Filter next;
    protected String filterName;
    protected String moduleID;
    protected boolean enabled = true;

    public String getModuleID() {
        if (this.moduleID == null) {
            this.moduleID = "filter-" + this.getFilterName();
        }
        return this.moduleID;
    }

    public void configure(Setting setting) throws ConfigException {
        this.enabled = setting.getAttribute("enabled", "true").equals("true");
        if (this.debug()) {
            this.debug(this.getModuleID() + " enabled = " + this.enabled);
        }
    }

    public abstract String getFilterName();

    public void setNext(Filter next) {
        this.next = next;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void handle(ClientRequest request) throws ModuleException {
        if (this.enabled) {
            if (this.debug()) {
                this.debug("running " + this.getModuleID());
            }
            this.doFilter(request);
        } else {
            if (this.debug()) {
                this.debug("skipping " + this.getModuleID());
            }
            if (this.next != null) {
                this.next.handle(request);
            }
        }
    }

    protected abstract void doFilter(ClientRequest var1) throws ModuleException;
}

