/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.filter;

import org.iges.anagram.ClientRequest;
import org.iges.anagram.ConfigException;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Setting;
import org.iges.anagram.filter.Filter;

public class OverloadFilter
extends Filter {
    protected int limit;
    protected int currentLoad;
    protected int maxLoad;

    public String getFilterName() {
        return "overload";
    }

    public void configure(Setting setting) throws ConfigException {
        super.configure(setting);
        this.limit = (int)setting.getNumAttribute("limit", 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ClientRequest clientRequest) throws ModuleException {
        OverloadFilter overloadFilter;
        OverloadFilter overloadFilter2 = this;
        synchronized (overloadFilter2) {
            if (this.limit > 0 && this.currentLoad >= this.limit) {
                this.fail("server is experiencing heavy load. please try again later.");
            }
            ++this.currentLoad;
            if (this.debug()) {
                this.debug("current load: " + this.currentLoad + " threads");
            }
            if (this.currentLoad > this.maxLoad) {
                this.maxLoad = this.currentLoad;
            }
        }
        try {
            try {
                this.next.handle(clientRequest);
            }
            catch (ModuleException me) {
                throw me;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Error e) {
                throw e;
            }
            Object var5_6 = null;
            overloadFilter = this;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            OverloadFilter overloadFilter3 = this;
            synchronized (overloadFilter3) {
                --this.currentLoad;
                throw throwable;
            }
        }
        synchronized (overloadFilter) {
            --this.currentLoad;
            return;
        }
    }
}

