/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.service;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.iges.anagram.AnagramException;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Privilege;
import org.iges.anagram.Setting;
import org.iges.anagram.service.Service;
import org.iges.util.ExclusiveLock;

public class AdminService
extends Service {
    protected String authCode;
    protected long timeout;

    public String getServiceName() {
        return "admin";
    }

    public void configure(Setting setting) {
        this.authCode = setting.getAttribute("auth", "");
        if (this.authCode.equals("") && this.verbose()) {
            this.verbose("no authorization code; admin service will be disabled");
        }
        this.timeout = setting.getNumAttribute("timeout", 60L);
        if (this.verbose()) {
            this.verbose("admin timeout set to " + this.timeout + " sec");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(ClientRequest clientRequest) throws ModuleException {
        String[] userAuth;
        Hashtable queryParams;
        HttpServletRequest request = clientRequest.getHttpRequest();
        HttpServletResponse response = clientRequest.getHttpResponse();
        Privilege privilege = clientRequest.getPrivilege();
        if (!request.getRemoteAddr().equals("127.0.0.1") && !privilege.getAttribute("admin_allowed", "false").equals("true")) {
            if (this.debug()) {
                this.debug("IP address " + request.getRemoteAddr() + " is not local, and is not authorized");
            }
            throw new ModuleException(this, "floo authorization failed");
        }
        if (request.getMethod().equals("POST")) {
            try {
                queryParams = HttpUtils.parsePostData((int)request.getIntHeader("Content-Length"), (ServletInputStream)request.getInputStream());
            }
            catch (IOException ioe) {
                queryParams = new Hashtable();
            }
        } else {
            queryParams = request.getQueryString() != null ? HttpUtils.parseQueryString((String)request.getQueryString()) : new Hashtable();
        }
        if (this.authCode.equals("")) {
            throw new ModuleException(this, "service not available");
        }
        if (this.debug()) {
            this.debug("parsed parameters for admin cmd");
        }
        if ((userAuth = (String[])queryParams.get("auth")) == null) {
            if (this.debug()) {
                this.debug("no userAuth given");
            }
            throw new ModuleException(this, "authorization failed");
        }
        if (!userAuth[0].equals(this.authCode)) {
            if (this.debug()) {
                this.debug("userAuth is " + userAuth[0]);
            }
            throw new ModuleException(this, "authorization failed");
        }
        String[] command = (String[])queryParams.get("cmd");
        if (command == null) {
            throw new ModuleException(this, "no command given");
        }
        if (command[0].equals("reload")) {
            ExclusiveLock exclusiveLock;
            if (this.debug()) {
                this.debug("attempting to get exclusive lock");
            }
            try {
                ExclusiveLock exclusiveLock2 = this.server.getSynch();
                synchronized (exclusiveLock2) {
                    if (this.debug()) {
                        this.debug("released non-exclusive lock");
                    }
                    if (!this.server.getSynch().tryLockExclusive(this.timeout * 1000L)) {
                        throw new ModuleException(this, "timed out after " + this.timeout + " seconds; server is currently in use");
                    }
                    if (this.debug()) {
                        this.debug("got an exclusive lock");
                    }
                }
                this.info("reconfiguring server");
                this.server.reconfigure();
                Object var11_12 = null;
                exclusiveLock = this.server.getSynch();
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                ExclusiveLock exclusiveLock2 = this.server.getSynch();
                synchronized (exclusiveLock2) {
                    this.server.getSynch().releaseExclusive();
                    if (this.debug()) {
                        this.debug("released exclusive lock");
                    }
                    throw throwable;
                }
            }
            synchronized (exclusiveLock) {
                this.server.getSynch().releaseExclusive();
                if (this.debug()) {
                    this.debug("released exclusive lock");
                }
            }
        } else {
            if (!command[0].equals("clear")) {
                throw new ModuleException(this, "unknown command " + command[0]);
            }
            this.info("removing all temporary catalog entries");
            try {
                this.server.getCatalog().clearTemp();
            }
            catch (AnagramException ae) {}
        }
        this.printReply(clientRequest, command[0]);
        if (this.debug()) {
            this.debug("sent admin cmd result to client");
        }
    }

    protected void printReply(ClientRequest request, String command) {
        request.getHttpResponse().setHeader("Cache-Control", "no-cache");
        String baseURL = this.getBaseURL(request);
        PrintStream page = this.startHTML(request);
        if (page == null) {
            return;
        }
        this.printHeader(page, "admin", "admin", null, baseURL);
        page.print("Command:<p>\n");
        page.print("<b>");
        page.print(command);
        page.print("</b><p>\n");
        page.print("performed successfully.");
        this.printFooter(page, null, 0L, baseURL);
    }
}

