/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.service;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.DataHandle;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Setting;
import org.iges.anagram.service.Service;

public class BinaryDataService
extends Service {
    public String getServiceName() {
        return "binary";
    }

    public void configure(Setting setting) {
    }

    public void handle(ClientRequest clientRequest) throws ModuleException {
        HttpServletRequest request = clientRequest.getHttpRequest();
        HttpServletResponse response = clientRequest.getHttpResponse();
        DataHandle data = this.getDataFromPath(clientRequest);
        response.setContentType("application/octet-stream");
        response.setHeader("XDODS-Server", "dods/3.2");
        response.setHeader("Content-Description", "dods_data");
        response.setDateHeader("Last-Modified", data.getCreateTime());
        String encoding = request.getHeader("Accept-Encoding");
        boolean useCompressed = encoding != null && encoding.equalsIgnoreCase("deflate");
        try {
            Object dataOut;
            if (useCompressed) {
                if (this.debug()) {
                    this.log.debug(this, clientRequest + "using compression");
                }
                response.setHeader("Content-Encoding", "deflate");
                dataOut = new DeflaterOutputStream((OutputStream)response.getOutputStream());
            } else {
                dataOut = response.getOutputStream();
            }
            this.server.getTool().writeBinaryData(data, clientRequest.getCE(), clientRequest.getPrivilege(), (OutputStream)dataOut, clientRequest.useCache());
            if (this.debug()) {
                this.debug("wrote binary data");
            }
            ((OutputStream)dataOut).flush();
            if (this.debug()) {
                this.debug("flushed stream");
            }
            if (useCompressed) {
                ((DeflaterOutputStream)dataOut).finish();
                if (this.debug()) {
                    this.debug("finished off compression");
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }
}

