/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.service;

import dods.dap.DODSException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.Setting;
import org.iges.anagram.service.ErrorService;

public class DODSErrorService
extends ErrorService {
    public String getServiceName() {
        return "error-dods";
    }

    public void configure(Setting setting) {
    }

    protected void sendErrorMsg(ClientRequest request, String msg) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)request.getHttpResponse().getOutputStream()));
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.setHeaders(request);
        this.sendDODSError(out, msg);
    }

    protected void sendUnexpectedErrorMsg(ClientRequest request, String debugInfo) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)request.getHttpResponse().getOutputStream()));
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.setHeaders(request);
        StringWriter msgString = new StringWriter();
        PrintWriter msg = new PrintWriter(msgString);
        msg.print("Oops! The server encountered an unexpected error ");
        msg.print("while serving the this request.\n");
        msg.print("Please report this error at\n\t");
        msg.print(this.server.getImplHomePage());
        msg.print("\nand include the following debug information:\n");
        msg.print(debugInfo);
        this.sendDODSError(out, msgString.toString());
    }

    protected void setHeaders(ClientRequest request) {
        request.getHttpResponse().setContentType("text/plain");
        request.getHttpResponse().setHeader("XDODS-Server", "3.1");
        request.getHttpResponse().setHeader("Cache-Control", "no-cache");
        request.getHttpResponse().setHeader("Content-Description", "dods_error");
    }

    protected void sendDODSError(PrintWriter out, String msg) {
        DODSException de = new DODSException(msg);
        de.print(out);
        out.close();
    }
}

