/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.service;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.DataHandle;
import org.iges.anagram.DirHandle;
import org.iges.anagram.Handle;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Privilege;
import org.iges.anagram.Setting;
import org.iges.anagram.ToolInfo;
import org.iges.anagram.service.Service;

public class DirectoryService
extends Service {
    public String getServiceName() {
        return "dir";
    }

    public void configure(Setting setting) {
    }

    public void handle(ClientRequest clientRequest) throws ModuleException {
        String path = clientRequest.getDataPath();
        Handle subDir = clientRequest.getHandle();
        Privilege privilege = clientRequest.getPrivilege();
        if (subDir == null || !(subDir instanceof DirHandle) || !privilege.everAllowsPath(subDir.getCompleteName())) {
            throw new ModuleException(this, "no directory called " + path);
        }
        long updateTime = this.server.getLastConfigTime();
        ArrayList dataHandles = new ArrayList();
        ArrayList subdirs = new ArrayList();
        subDir.getSynch().lock();
        Map entries = ((DirHandle)subDir).getEntries(false);
        Iterator sIt = entries.entrySet().iterator();
        while (sIt.hasNext()) {
            Map.Entry current = sIt.next();
            if (current.getValue() instanceof DirHandle) {
                subdirs.add(current.getValue());
                continue;
            }
            dataHandles.add(current.getValue());
            updateTime = Math.max(updateTime, ((DataHandle)current.getValue()).getCreateTime());
        }
        subDir.getSynch().release();
        clientRequest.getHttpResponse().setHeader("CacheControl", "no-cache");
        clientRequest.getHttpResponse().setDateHeader("Last-Modified", updateTime);
        PrintStream page = this.startHTML(clientRequest);
        if (page == null) {
            return;
        }
        int size = dataHandles.size() + subdirs.size();
        String windowTitle = "directory for " + subDir.getCompleteName();
        String pageTitle = windowTitle + " : " + size + " entries";
        String baseURL = this.getBaseURL(clientRequest);
        this.printHeader(page, windowTitle, pageTitle, subDir, baseURL);
        int i = 1;
        Iterator it = subdirs.iterator();
        while (it.hasNext()) {
            DirHandle current = (DirHandle)it.next();
            if (!privilege.everAllowsPath(current.getCompleteName())) {
                if (!this.debug()) continue;
                this.debug(current.getCompleteName() + " is forbidden");
                continue;
            }
            if (this.debug()) {
                this.debug(current.getCompleteName() + " is allowed");
            }
            page.print("<b>");
            page.print(i);
            page.print(": ");
            page.print(current.getName());
            page.print("/:</b> ");
            page.print("<a href=\"");
            page.print(baseURL);
            page.print(current.getCompleteName());
            page.print("\">");
            page.print("dir");
            page.print("</a><br><br>\n");
            ++i;
        }
        it = dataHandles.iterator();
        while (it.hasNext()) {
            DataHandle dataHandle = (DataHandle)it.next();
            if (!privilege.allowsPath(dataHandle.getCompleteName())) continue;
            dataHandle.getSynch().lock();
            page.print("<b>");
            page.print(i);
            page.print(": \n");
            page.print(dataHandle.getName());
            page.print(":</b>&nbsp;");
            ToolInfo info = dataHandle.getToolInfo();
            if (!dataHandle.isAvailable()) {
                page.print("<font color=\"#999999\">");
            }
            page.print(dataHandle.getDescription());
            page.print("\n&nbsp;\n");
            page.print("<a href=\"");
            page.print(baseURL);
            page.print(dataHandle.getCompleteName());
            page.print(".info\">info</a>&nbsp;\n");
            page.print("<a href=\"");
            page.print(baseURL);
            page.print(dataHandle.getCompleteName());
            page.print(".dds\">dds</a>&nbsp;\n");
            page.print("<a href=\"");
            page.print(baseURL);
            page.print(dataHandle.getCompleteName());
            page.print(".das\">das</a><br><br>\n");
            if (!dataHandle.isAvailable()) {
                page.print("</font>");
            }
            dataHandle.getSynch().release();
            ++i;
        }
        this.printFooter(page, subDir, updateTime, baseURL);
        page.flush();
        page.close();
    }
}

