/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.ModuleException;
import org.iges.anagram.service.Service;

public abstract class ErrorService
extends Service {
    public void handle(ClientRequest request) {
        throw new RuntimeException("not implemented");
    }

    public void handle(ClientRequest request, ModuleException me) {
        String msg = me.getMessage();
        this.log.error(me.getModule(), request + " " + msg);
        if (me.getClientMessage() != null) {
            msg = me.getClientMessage();
        }
        this.sendErrorMsg(request, msg);
    }

    public void handleUnexpected(ClientRequest request, Throwable t) {
        if (t instanceof OutOfMemoryError) {
            this.log.error(this, request + " ran out of available memory.\n" + "your server is not configured properly to handle " + " peak loads. please see documentation.\n");
            this.sendErrorMsg(request, "server is low on resources. please try again later.\n");
        } else {
            StringWriter debugInfo = new StringWriter();
            PrintWriter p = new PrintWriter(debugInfo);
            t.printStackTrace(p);
            this.log.error(this, request + "oops, exception " + t.getClass() + " was not caught.\n" + "please report this as a bug, along with " + "the following debug info:\n" + debugInfo.toString());
            this.sendUnexpectedErrorMsg(request, debugInfo.toString());
        }
    }

    protected abstract void sendErrorMsg(ClientRequest var1, String var2);

    protected abstract void sendUnexpectedErrorMsg(ClientRequest var1, String var2);
}

