/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.service;

import java.io.PrintStream;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Setting;
import org.iges.anagram.service.Service;

public class HelpService
extends Service {
    private String cachedResponse = null;

    public String getServiceName() {
        return "help";
    }

    public void configure(Setting setting) {
    }

    public void handle(ClientRequest clientRequest) throws ModuleException {
        PrintStream page = this.startHTML(clientRequest);
        if (page == null) {
            return;
        }
        String baseURL = this.getBaseURL(clientRequest);
        this.printHeader(page, "help", "help", null, baseURL);
        if (this.cachedResponse == null) {
            this.cachedResponse = this.buildResponse(baseURL);
        }
        page.print(this.cachedResponse);
        this.printFooter(page, null, 0L, baseURL);
        page.flush();
        page.close();
    }

    private String buildResponse(String baseURL) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("This server provides online access to, and analysis\n");
        buffer.append("of, scientific data, using the DODS protocol.\n");
        buffer.append("<p>For more information about: </p>\n");
        buffer.append("<ul>\n");
        buffer.append("  <li>the DODS protocol, how to access data on DODS servers, and how to obtain\n");
        buffer.append("DODS-enabled client software - see the&nbsp; <a href=\"http://unidata.ucar.edu/packages/dods\">\n");
        buffer.append("DODS home page</a>\n");
        buffer.append(".\n");
        buffer.append("  </li>\n");
        buffer.append("  <li>The ");
        buffer.append(this.server.getImplName());
        buffer.append(", and features specific to this server, ");
        buffer.append("such as remote analysis - see the\n");
        buffer.append("    <a href=\"");
        buffer.append(this.server.getImplHomePage());
        buffer.append("\">");
        buffer.append(this.server.getImplName());
        buffer.append(" home page</a>\n");
        buffer.append(" .<br>\n");
        buffer.append("  </li>\n");
        buffer.append("  <li>this site's data holdings, ");
        buffer.append("and other site-specific information - see\n");
        buffer.append("    <a href=\"");
        buffer.append(this.server.getSiteHomePage(baseURL));
        buffer.append("\">");
        buffer.append("this site's home page</a>\n");
        buffer.append(" .&nbsp;<br>\n");
        buffer.append("    <br>\n");
        buffer.append("  </li>\n");
        buffer.append("    <br>\n");
        buffer.append("</ul>\n");
        return buffer.toString();
    }
}

