/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.service;

import dods.dap.Attribute;
import dods.dap.AttributeTable;
import dods.dap.BaseType;
import dods.dap.BaseTypePrimitiveVector;
import dods.dap.DAS;
import dods.dap.DArray;
import dods.dap.DArrayDimension;
import dods.dap.DByte;
import dods.dap.DConstructor;
import dods.dap.DDS;
import dods.dap.DFloat32;
import dods.dap.DFloat64;
import dods.dap.DGrid;
import dods.dap.DInt16;
import dods.dap.DInt32;
import dods.dap.DList;
import dods.dap.DSequence;
import dods.dap.DString;
import dods.dap.DStructure;
import dods.dap.DUInt16;
import dods.dap.DUInt32;
import dods.dap.DURL;
import dods.dap.DVector;
import dods.dap.NoSuchVariableException;
import dods.dap.PrimitiveVector;
import dods.dap.Server.ServerDDS;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.DataHandle;
import org.iges.anagram.Module;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Setting;
import org.iges.anagram.service.Service;
import org.iges.util.Spooler;

public class InfoService
extends Service {
    protected long counter;

    public String getServiceName() {
        return "info";
    }

    public void configure(Setting setting) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ClientRequest clientRequest) throws ModuleException {
        HttpServletRequest request = clientRequest.getHttpRequest();
        HttpServletResponse response = clientRequest.getHttpResponse();
        DataHandle data = this.getDataFromPath(clientRequest);
        response.setContentType("text/html");
        response.setHeader("XDODS-Server", "3.1");
        response.setHeader("Content-Description", "dods_info");
        response.setDateHeader("Last-Modified", data.getCreateTime());
        String cacheName = "_infocache" + System.currentTimeMillis() + this.counter++;
        File cache = this.server.getStore().get((Module)this, cacheName, ".info");
        this.writeToCache(clientRequest, data, cache);
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(cache));
            Spooler.spool(in, (OutputStream)response.getOutputStream());
            ((InputStream)in).close();
        }
        catch (IOException ioe) {
        }
        finally {
            cache.delete();
        }
    }

    protected void writeToCache(ClientRequest clientRequest, DataHandle data, File cacheFile) throws ModuleException {
        HttpServletRequest request = clientRequest.getHttpRequest();
        HttpServletResponse response = clientRequest.getHttpResponse();
        ServerDDS myDDS = null;
        DAS myDAS = null;
        myDDS = this.server.getTool().getDDS(data, "", clientRequest.getPrivilege(), clientRequest.useCache());
        myDAS = this.server.getTool().getDAS(data, clientRequest.getPrivilege(), clientRequest.useCache());
        String global_attrs = this.buildGlobalAttributes(myDAS, myDDS);
        String variable_sum = this.buildVariableSummaries(myDAS, myDDS);
        PrintStream pw = null;
        try {
            pw = new PrintStream(new FileOutputStream(cacheFile));
        }
        catch (IOException ioe) {
            throw new ModuleException(this, "saving web info for " + data + " failed");
        }
        String baseURL = this.getBaseURL(clientRequest);
        String windowTitle = "info for " + data.getCompleteName();
        String pageTitle = windowTitle + " : " + "<a href=\"" + baseURL + data.getCompleteName() + ".dds\">dds</a>&nbsp;&nbsp;<a href=\"" + baseURL + data.getCompleteName() + ".das\">das</a>";
        this.printHeader(pw, windowTitle, pageTitle, data, baseURL);
        pw.print("<table><tbody><tr>\n");
        pw.print("<td valign=\"bottom\">");
        pw.print("<b>DODS URL:</b>\n");
        pw.print("</td>");
        pw.print("<td valign=\"bottom\">");
        pw.print(this.getSiteName(clientRequest) + baseURL + data.getCompleteName());
        pw.print("</td></tr></tbody></table></p>\n");
        pw.flush();
        this.server.getTool().writeWebInfo(data, clientRequest.getPrivilege(), pw, clientRequest.useCache());
        pw.print("<br><a href=\"");
        pw.print(baseURL);
        pw.print(this.server.getCatalog().getParent(data).getCompleteName());
        pw.print("\">back to parent directory</a><br><br>");
        pw.print("<hr><h2>complete metadata listing:</h2>\n");
        pw.print("<b>Global attributes:</b><p>");
        pw.print(global_attrs);
        pw.print("<hr>\n");
        pw.println(variable_sum);
        pw.print("<a href=\"#\">back to top</a><br>\n");
        this.printFooter(pw, null, data.getCreateTime(), baseURL);
        pw.flush();
        pw.close();
    }

    private String buildGlobalAttributes(DAS das, ServerDDS dds) {
        boolean found = false;
        StringBuffer ga = new StringBuffer("<table>\n");
        Enumeration edas = das.getNames();
        while (edas.hasMoreElements()) {
            String name = (String)edas.nextElement();
            if (!InfoService.nameIsGlobal(name) && InfoService.nameInDDS(name, (DDS)dds)) continue;
            AttributeTable attr = das.getAttributeTable(name);
            Enumeration e = attr.getNames();
            while (e.hasMoreElements()) {
                String aName = (String)e.nextElement();
                Attribute a = attr.getAttribute(aName);
                found = true;
                ga.append("\n<tr><td align=right valign=top><b>");
                ga.append(aName);
                ga.append("</b>:</td>\n");
                ga.append("<td align=left>");
                Enumeration es = a.getValues();
                while (es.hasMoreElements()) {
                    String val = (String)es.nextElement();
                    ga.append(val);
                    ga.append("<br>");
                }
                ga.append("</td></tr>\n");
            }
        }
        ga.append("</table>\n<p>\n");
        if (!found) {
            return "None found.";
        }
        return ga.toString();
    }

    private String buildVariableSummaries(DAS das, ServerDDS dds) {
        StringBuffer vs = new StringBuffer("<b>Variables</b><p>\n<table>\n");
        Enumeration e = dds.getVariables();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            vs.append("<tr>");
            vs.append(this.summarizeVariable(bt, das));
            vs.append("</tr>");
        }
        vs.append("</table>\n<p>\n");
        return vs.toString();
    }

    private String summarizeVariable(BaseType bt, DAS das) {
        DVector da;
        PrimitiveVector pv;
        BaseType bt2;
        StringBuffer vOut = new StringBuffer("<td align=right valign=top><b>" + bt.getName());
        vOut.append("</b>:</td>\n");
        vOut.append("<td align=left valign=top>" + InfoService.fancyTypeName(bt));
        vOut.append("<br>\n");
        AttributeTable attr = das.getAttributeTable(bt.getName());
        if (attr != null) {
            Enumeration e = attr.getNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Attribute a = attr.getAttribute(name);
                vOut.append(name + ": ");
                Enumeration es = a.getValues();
                while (es.hasMoreElements()) {
                    String val = (String)es.nextElement();
                    vOut.append(val);
                    if (!es.hasMoreElements()) continue;
                    vOut.append(", ");
                }
                vOut.append("\n<br>\n");
            }
        }
        if (bt instanceof DConstructor) {
            vOut.append("<table>\n");
            DConstructor dc = (DConstructor)bt;
            Enumeration e = dc.getVariables();
            while (e.hasMoreElements()) {
                bt2 = (BaseType)e.nextElement();
                vOut.append("<tr>\n");
                vOut.append(this.summarizeVariable(bt2, das));
                vOut.append("</tr>\n");
            }
            vOut.append("</table>\n");
        } else if (bt instanceof DVector && (pv = (da = (DVector)bt).getPrimitiveVector()) instanceof BaseTypePrimitiveVector && !((bt2 = pv.getTemplate()) instanceof DArray) && !(bt2 instanceof DString)) {
            vOut.append("<table>\n");
            vOut.append("<tr>\n");
            vOut.append(this.summarizeVariable(bt2, das));
            vOut.append("</tr>\n");
            vOut.append("</table>\n");
        }
        return vOut.toString();
    }

    public static boolean nameInDDS(String name, DDS dds) {
        try {
            dds.getVariable(name);
        }
        catch (NoSuchVariableException e) {
            return false;
        }
        return true;
    }

    public static boolean nameIsGlobal(String name) {
        String lcName = name.toLowerCase();
        if (lcName.indexOf("global") >= 0) {
            return true;
        }
        return lcName.indexOf("dods") >= 0;
    }

    public static String fancyTypeName(BaseType bt) {
        if (bt instanceof DByte) {
            return "8 bit Byte";
        }
        if (bt instanceof DUInt16) {
            return "16 bit Unsigned Integer";
        }
        if (bt instanceof DInt16) {
            return "16 bit Integer";
        }
        if (bt instanceof DUInt32) {
            return "32 bit Unsigned Integer";
        }
        if (bt instanceof DInt32) {
            return "32 bit Integer";
        }
        if (bt instanceof DFloat32) {
            return "32 bit Real";
        }
        if (bt instanceof DFloat64) {
            return "64 bit Real";
        }
        if (bt instanceof DURL) {
            return "URL";
        }
        if (bt instanceof DString) {
            return "String";
        }
        if (bt instanceof DArray) {
            DArray a = (DArray)bt;
            String type = "Array of " + InfoService.fancyTypeName(a.getPrimitiveVector().getTemplate()) + "s ";
            Enumeration e = a.getDimensions();
            while (e.hasMoreElements()) {
                DArrayDimension dad = (DArrayDimension)e.nextElement();
                type = type + "[" + dad.getName() + " = 0.." + (dad.getSize() - 1) + "]";
            }
            type = type + "\n";
            return type;
        }
        if (bt instanceof DList) {
            DList a = (DList)bt;
            String type = "List of " + InfoService.fancyTypeName(a.getPrimitiveVector().getTemplate()) + "s\n";
            return type;
        }
        if (bt instanceof DStructure) {
            return "Structure";
        }
        if (bt instanceof DSequence) {
            return "Sequence";
        }
        if (bt instanceof DGrid) {
            return "Grid";
        }
        return "UNKNOWN";
    }
}

