/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.service;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SimpleTimeZone;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import org.iges.anagram.AbstractModule;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.DataHandle;
import org.iges.anagram.DirHandle;
import org.iges.anagram.Handle;
import org.iges.anagram.ModuleException;

public abstract class Service
extends AbstractModule {
    protected SimpleDateFormat updateFormat;
    protected boolean enabled = true;
    protected String moduleID;

    public String getModuleID() {
        if (this.moduleID == null) {
            this.moduleID = "service-" + this.getServiceName();
        }
        return this.moduleID;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public abstract String getServiceName();

    public abstract void handle(ClientRequest var1) throws ModuleException;

    protected String getBaseURL(ClientRequest clientRequest) {
        return clientRequest.getHttpRequest().getContextPath();
    }

    protected PrintStream startHTML(ClientRequest clientRequest) {
        clientRequest.getHttpResponse().setContentType("text/html");
        try {
            return new PrintStream((OutputStream)clientRequest.getHttpResponse().getOutputStream());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    protected void printHeader(PrintStream p, String windowTitle, String pageTitle, Handle path, String baseURL) {
        p.print("<html>\n");
        p.print("<head>\n");
        p.print("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n");
        p.print("  <title>");
        p.print(this.server.getServerName());
        p.print(" - ");
        p.print(windowTitle);
        p.print("</title>\n");
        p.print("</head>\n");
        p.print(" <body bgcolor=\"#ffffff\">\n");
        p.print("<a href=\"");
        p.print(baseURL);
        p.print("\">");
        p.print(this.server.getServerName());
        p.print("</a>\n");
        if (path != null) {
            LinkedList<Handle> paths = new LinkedList<Handle>();
            paths.addFirst(path);
            while (!path.getCompleteName().equals("/")) {
                path = this.server.getCatalog().getParent(path);
                paths.addFirst(path);
            }
            Iterator it = paths.iterator();
            while (it.hasNext()) {
                Handle next = (Handle)it.next();
                p.print("- <a href=\"");
                p.print(baseURL + next.getCompleteName());
                p.print("\">");
                if (next.getCompleteName().equals("/")) {
                    p.print("top level</a>\n");
                    continue;
                }
                p.print(next.getName());
                p.print("</a>\n");
            }
        }
        p.print("<br>\n");
        p.print("<h2>");
        p.print(this.server.getServerName());
        p.print(" - ");
        p.print(pageTitle);
        p.print("</h2>\n");
        p.print("<hr><br>\n");
    }

    protected void printFooter(PrintStream p, Handle path, long updateTime, String baseURL) {
        if (path != null) {
            p.print("<a href=\"");
            p.print(baseURL);
            p.print(this.server.getCatalog().getParent(path).getCompleteName());
            p.print("\">back to parent directory</a><br>");
        }
        p.print("<br>\n");
        p.print("<hr><font size=\"-1\"><a href=\"");
        p.print(this.server.getImplHomePage());
        p.print("\">\n");
        p.print(this.server.getImplName());
        p.print("</a> ");
        p.print(this.server.getImplVersion());
        p.print(" (<a href=\"");
        p.print(baseURL);
        p.print("/.help\" target=\"_blank\">");
        p.print("help&nbsp;using&nbsp;this&nbsp;server</a>)\n");
        if (updateTime > 0L) {
            if (this.updateFormat == null) {
                this.updateFormat = new SimpleDateFormat("hh'Z' dd MMM yyyy");
                this.updateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
            }
            p.print(". This page last updated ");
            p.print(this.updateFormat.format(new Date(updateTime)));
        }
        p.print(". &nbsp;</font>\n");
        p.print("<br>\n");
        p.print("</body>\n");
        p.print("</html>\n");
    }

    protected DataHandle getDataFromPath(ClientRequest clientRequest) throws ModuleException {
        Handle handle = clientRequest.getHandle();
        if (handle == null || !clientRequest.getPrivilege().allowsPath(handle.getCompleteName())) {
            throw new ModuleException(this, clientRequest.getDataPath() + " is not an available dataset");
        }
        if (handle instanceof DirHandle) {
            throw new ModuleException(this, clientRequest.getDataPath() + " is a directory");
        }
        DataHandle data = (DataHandle)handle;
        if (data.isAvailable()) {
            return data;
        }
        throw new ModuleException(this, handle.getCompleteName() + " is temporarily unavailable");
    }

    protected Hashtable getQueryParams(ClientRequest clientRequest) {
        Hashtable queryParams;
        HttpServletRequest request = clientRequest.getHttpRequest();
        if (request.getMethod().equals("POST")) {
            try {
                queryParams = HttpUtils.parsePostData((int)request.getIntHeader("Content-Length"), (ServletInputStream)request.getInputStream());
            }
            catch (IOException ioe) {
                queryParams = new Hashtable();
            }
        } else {
            queryParams = request.getQueryString() != null ? HttpUtils.parseQueryString((String)request.getQueryString()) : new Hashtable();
        }
        return queryParams;
    }

    protected String getSiteName(ClientRequest clientRequest) {
        String detectedSiteName = "http://" + clientRequest.getHttpRequest().getServerName();
        if (clientRequest.getHttpRequest().getServerPort() != 80) {
            detectedSiteName = detectedSiteName + ":" + clientRequest.getHttpRequest().getServerPort();
        }
        String siteName = this.server.getSiteHomePage(detectedSiteName);
        return siteName;
    }
}

