/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.service;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.DataHandle;
import org.iges.anagram.DirHandle;
import org.iges.anagram.Handle;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Privilege;
import org.iges.anagram.Setting;
import org.iges.anagram.service.Service;
import org.iges.util.Spooler;

public class THREDDSCatalogService
extends Service {
    protected long counter;
    protected THREDDSPrinter v06Printer = new THREDDSv06Printer();
    protected THREDDSPrinter v10Printer = new THREDDSv10Printer();

    public String getServiceName() {
        return "thredds";
    }

    public void configure(Setting setting) {
        this.counter = 0L;
    }

    public void handle(ClientRequest clientRequest) throws ModuleException {
        HttpServletRequest request = clientRequest.getHttpRequest();
        HttpServletResponse response = clientRequest.getHttpResponse();
        Hashtable queryParams = this.getQueryParams(clientRequest);
        String[] clientVersion = (String[])queryParams.get("version");
        if (clientVersion != null && !clientVersion[0].equals("0.6")) {
            if (clientVersion[0].equals("1.0")) {
                throw new ModuleException(this, "THREDDS v1.0 support not yet enabled");
            }
            throw new ModuleException(this, "unsupported THREDDS version: " + clientVersion[0] + " (must be 0.6 or 1.0)");
        }
        THREDDSPrinter catalog = this.v06Printer;
        response.setContentType("text/xml");
        response.setDateHeader("Last-Modified", this.server.getLastConfigTime());
        File cache = null;
        try {
            PrintStream page = new PrintStream((OutputStream)response.getOutputStream());
            catalog.printHeader(page, this.getSiteName(clientRequest) + this.getBaseURL(clientRequest));
            cache = catalog.load(clientRequest.getPrivilege(), clientRequest.useCache());
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(cache));
            Spooler.spool(in, page);
            ((InputStream)in).close();
            if (!clientRequest.useCache()) {
                cache.delete();
            }
        }
        catch (IOException ioe) {
            if (cache != null) {
                cache.delete();
            }
            throw new ModuleException(this, "spooling THREDDS catalog failed");
        }
    }

    protected class THREDDSv10Printer
    extends THREDDSPrinter {
        protected THREDDSv10Printer() {
        }

        protected String getVersion() {
            return "1.0";
        }

        protected void printHeader(PrintStream page, String baseURL) {
            page.print("<?xml version=\"1.0\"?>\n");
            page.print("<catalog xmlns=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" version=\"1.0\" name=\"" + THREDDSCatalogService.this.server.getServerName() + "\" >\n");
            page.print("    <service name=\"" + THREDDSCatalogService.this.server.getModuleName() + "\" serviceType=\"DODS\" base=\"" + baseURL + "/\" />\n");
        }

        protected void printDataset(PrintStream page, DataHandle dataset, String indent, Privilege privilege, boolean useCache) {
            try {
                THREDDSCatalogService.this.server.getTool().writeTHREDDSTag(dataset, privilege, page, useCache);
            }
            catch (ModuleException me) {
                THREDDSCatalogService.this.error("no catalog info for " + dataset + ": " + me.getMessage());
                page.print(indent + "<dataset name=\"");
                page.print(dataset.getDescription() + "\"\n");
                page.print(indent + "         urlPath=\"");
                page.print(dataset.getCompleteName() + "\"\n");
                page.print(indent + "         serviceName=\"" + THREDDSCatalogService.this.server.getModuleName() + "\" />\n");
            }
        }

        protected void printFooter(PrintStream page) {
            page.print("</catalog>\n");
        }
    }

    protected class THREDDSv06Printer
    extends THREDDSPrinter {
        protected THREDDSv06Printer() {
        }

        protected String getVersion() {
            return "0.6";
        }

        protected void printHeader(PrintStream page, String baseURL) {
            page.print("<?xml version=\"1.0\"?>\n");
            page.print("<!DOCTYPE catalog SYSTEM \"http://www.unidata.ucar.edu/projects/THREDDS/xml/InvCatalog.0.6.dtd\">\n");
            page.print("<catalog xmlns=\"http://www.unidata.ucar.edu/thredds\"\n         xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n         version=\"0.6\" name=\"" + THREDDSCatalogService.this.server.getServerName() + "\" >\n");
            page.print("    <dataset name=\"" + THREDDSCatalogService.this.server.getServerName() + "\" >\n" + "        <service name=\"" + THREDDSCatalogService.this.server.getModuleName() + "\" serviceType=\"DODS\" base=\"" + baseURL + "\" />\n");
        }

        protected void printDataset(PrintStream page, DataHandle dataset, String indent, Privilege privilege, boolean useCache) {
            page.print(indent + "<dataset name=\"");
            page.print(dataset.getDescription() + "\"\n");
            page.print(indent + "         urlPath=\"");
            page.print(dataset.getCompleteName() + "\"\n");
            page.print(indent + "         serviceName=\"" + THREDDSCatalogService.this.server.getModuleName() + "\" />\n");
        }

        protected void printFooter(PrintStream page) {
            page.print("    </dataset>\n</catalog>\n");
        }
    }

    protected abstract class THREDDSPrinter {
        protected THREDDSPrinter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected File load(Privilege privilege, boolean useCache) throws ModuleException {
            File cache = null;
            try {
                String cacheName;
                THREDDSCatalogService tHREDDSCatalogService = THREDDSCatalogService.this;
                synchronized (tHREDDSCatalogService) {
                    cacheName = "catalog-" + this.getVersion() + System.currentTimeMillis() + THREDDSCatalogService.this.counter++ + ".xml";
                }
                cache = THREDDSCatalogService.this.server.getStore().get(THREDDSCatalogService.this, cacheName);
                if (THREDDSCatalogService.this.debug()) {
                    THREDDSCatalogService.this.debug("generating new THREDDS catalog (version " + this.getVersion() + ")");
                }
                PrintStream print = new PrintStream(new FileOutputStream(cache));
                this.printCatalog(print, privilege, useCache);
                print.close();
            }
            catch (IOException ioe) {
                cache.delete();
                throw new ModuleException(THREDDSCatalogService.this, "saving THREDDS catalog version " + this.getVersion() + " failed");
            }
            return cache;
        }

        protected void printCatalog(PrintStream page, Privilege privilege, boolean useCache) throws ModuleException {
            DirHandle root = (DirHandle)THREDDSCatalogService.this.server.getCatalog().getLocked("/");
            try {
                this.printDir(page, root, "        ", privilege, useCache);
            }
            catch (ModuleException me) {
                throw me;
            }
            finally {
                root.getSynch().release();
            }
            this.printFooter(page);
            page.flush();
        }

        protected abstract String getVersion();

        protected abstract void printHeader(PrintStream var1, String var2);

        protected abstract void printFooter(PrintStream var1);

        protected abstract void printDataset(PrintStream var1, DataHandle var2, String var3, Privilege var4, boolean var5);

        protected void printDir(PrintStream page, DirHandle dir, String indent, Privilege privilege, boolean useCache) throws ModuleException {
            Collection datasets = dir.getEntries(false).values();
            Iterator it = datasets.iterator();
            while (it.hasNext()) {
                Handle handle = (Handle)it.next();
                handle.getSynch().lock();
                if (handle instanceof DirHandle) {
                    DirHandle subdir = (DirHandle)handle;
                    if (privilege.everAllowsPath(subdir.getCompleteName())) {
                        page.print(indent + "<dataset name=\"");
                        page.print(subdir.getName() + "\" >\n");
                        this.printDir(page, subdir, indent + "    ", privilege, useCache);
                        page.print(indent + "</dataset>\n");
                    }
                } else {
                    DataHandle dataHandle = (DataHandle)handle;
                    if (privilege.allowsPath(dataHandle.getCompleteName())) {
                        this.printDataset(page, dataHandle, indent, privilege, useCache);
                    }
                }
                handle.getSynch().release();
            }
        }
    }
}

