/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Setting;
import org.iges.anagram.TempDataHandle;
import org.iges.anagram.service.Service;

public class UploadService
extends Service {
    protected List generating;

    public String getServiceName() {
        return "upload";
    }

    public void configure(Setting setting) {
        this.generating = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(ClientRequest clientRequest) throws ModuleException {
        List list;
        String name;
        String prefix = clientRequest.getDataPath();
        if (!prefix.startsWith("/_upload_")) {
            throw new ModuleException(this, "path for uploaded dataset must begin with '_upload_'");
        }
        List list2 = this.generating;
        synchronized (list2) {
            int counter = 0;
            do {
                name = prefix + "_" + ++counter;
            } while (this.server.getCatalog().contains(name) || this.generating.contains(name));
            this.log.info(this, "storing upload: " + name);
            this.generating.add(name);
        }
        HttpServletRequest request = clientRequest.getHttpRequest();
        HttpServletResponse response = clientRequest.getHttpResponse();
        try {
            ServletInputStream uploadStream;
            long uploadSize = request.getIntHeader("Content-Length");
            if (uploadSize <= 0L) {
                throw new ModuleException(this, "Content-Length <= 0 in request");
            }
            try {
                uploadStream = request.getInputStream();
            }
            catch (IOException ioe) {
                throw new ModuleException(this, "can't read request content");
            }
            TempDataHandle handle = this.server.getTool().doUpload(name, (InputStream)uploadStream, uploadSize, clientRequest.getPrivilege());
            this.server.getCatalog().addTemp(handle);
            if (this.debug()) {
                this.log.debug(this, clientRequest + "finished upload");
            }
            try {
                PrintWriter page = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
                page.println(name + " created successfully.");
                page.flush();
            }
            catch (IOException ioe) {
            }
            Object var12_14 = null;
            list = this.generating;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            List list3 = this.generating;
            synchronized (list3) {
                this.generating.remove(name);
                this.generating.notifyAll();
                throw throwable;
            }
        }
        synchronized (list) {
            this.generating.remove(name);
            this.generating.notifyAll();
            return;
        }
    }
}

