/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.service;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.Setting;
import org.iges.anagram.service.ErrorService;

public class WebErrorService
extends ErrorService {
    public String getServiceName() {
        return "error-html";
    }

    public void configure(Setting setting) {
    }

    protected void sendErrorMsg(ClientRequest request, String msg) {
        if (request.getHttpResponse().isCommitted()) {
            try {
                PrintStream out = new PrintStream((OutputStream)request.getHttpResponse().getOutputStream());
                this.sendErrorText(out, request, msg);
                out.close();
            }
            catch (IOException ioe) {}
        } else {
            request.getHttpResponse().setHeader("Cache-Control", "no-cache");
            String baseURL = this.getBaseURL(request);
            PrintStream out = this.startHTML(request);
            if (out == null) {
                return;
            }
            this.printHeader(out, "error", "error", null, baseURL);
            this.sendErrorHTML(out, request.getURL(), msg);
            this.printFooter(out, null, 0L, baseURL);
            out.close();
        }
    }

    protected void sendUnexpectedErrorMsg(ClientRequest request, String debugInfo) {
        if (request.getHttpResponse().isCommitted()) {
            try {
                PrintStream out = new PrintStream((OutputStream)request.getHttpResponse().getOutputStream());
                this.sendErrorText(out, request, debugInfo);
                out.close();
            }
            catch (IOException ioe) {}
        } else {
            request.getHttpResponse().setHeader("Cache-Control", "no-cache");
            String baseURL = this.getBaseURL(request);
            PrintStream out = this.startHTML(request);
            if (out == null) {
                return;
            }
            this.printHeader(out, "error", "error", null, this.getBaseURL(request));
            this.sendUnexpectedHTML(out, request, debugInfo);
            this.printFooter(out, null, 0L, baseURL);
            out.close();
        }
    }

    protected void sendErrorHTML(PrintStream out, String url, String msg) {
        out.print("The server could not fulfill this request:<p>");
        out.print("<b>");
        out.print(url);
        out.print("</b><p>");
        out.print(" because of the following error:<p>\n");
        out.print("<b>");
        out.print(msg);
        out.print("</b><p>\n");
        out.print("Check the syntax of your request, ");
        out.print("or click <a href=\".help\">here</a> for help ");
        out.print("using the server.\n");
    }

    protected void sendUnexpectedHTML(PrintStream out, ClientRequest request, String debugInfo) {
        out.print("Oops! The server encountered an unexpected error while serving the this request:<p>");
        out.print("<b>");
        out.print(request.getURL());
        out.print("</b><p>");
        out.print("Please report this error to <a href=\"");
        out.print(this.server.getImplHomePage());
        out.print("\">");
        out.print(this.server.getImplHomePage());
        out.print("</a>");
        out.print(", and include the following debug information:<p>\n");
        out.print("<code>");
        out.print(new Date(System.currentTimeMillis()));
        out.print(": ");
        out.print(request);
        out.print("\n");
        out.print(debugInfo);
        out.print("</code>");
    }

    protected void sendErrorText(PrintStream out, ClientRequest request, String debugInfo) {
        out.print("\n\n");
        out.print("Error during request processing.\n");
        out.print("Please report this error to\n\t");
        out.print(this.server.getImplHomePage());
        out.print("\nand include the following debug information:\n");
        out.print(new Date(System.currentTimeMillis()));
        out.print(": ");
        out.print(request);
        out.print("\n");
        out.print(debugInfo);
    }
}

