/*
 * Decompiled with CFR 0.152.
 */
package org.iges.anagram.service;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.iges.anagram.ClientRequest;
import org.iges.anagram.DataHandle;
import org.iges.anagram.DirHandle;
import org.iges.anagram.Handle;
import org.iges.anagram.ModuleException;
import org.iges.anagram.Setting;
import org.iges.anagram.service.Service;

public class XMLCatalogService
extends Service {
    public String getServiceName() {
        return "xml";
    }

    public void configure(Setting setting) {
    }

    public void handle(ClientRequest clientRequest) throws ModuleException {
        PrintWriter page;
        HttpServletRequest request = clientRequest.getHttpRequest();
        HttpServletResponse response = clientRequest.getHttpResponse();
        try {
            page = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        catch (IOException ioe) {
            return;
        }
        String baseURL = "http://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        StringBuffer buffer = new StringBuffer("");
        DirHandle root = (DirHandle)this.server.getCatalog().getLocked("/");
        Collection datasets = root.getEntries(true).values();
        response.setHeader("CacheControl", "no-cache");
        buffer.append("<?xml version=\"1.0\"?>\n  <serverdirectory count=\"");
        buffer.append(datasets.size());
        buffer.append("\">\n");
        Iterator it = datasets.iterator();
        int i = 1;
        while (it.hasNext()) {
            Handle handle = (Handle)it.next();
            if (handle instanceof DirHandle) continue;
            DataHandle dataset = (DataHandle)handle;
            dataset.getSynch().lock();
            if (clientRequest.getPrivilege().allowsPath(dataset.getCompleteName())) {
                buffer.append("    <dataset protocol=\"dods\" rank=\"");
                buffer.append(i);
                buffer.append("\">\n");
                buffer.append("      <name>");
                buffer.append(dataset.getCompleteName());
                buffer.append("</name>\n");
                buffer.append("      <description>");
                buffer.append(dataset.getDescription());
                buffer.append("</description>\n");
                buffer.append("      <dods>");
                buffer.append(baseURL);
                buffer.append(dataset.getCompleteName());
                buffer.append("</dods>\n");
                buffer.append("      <dds>");
                buffer.append(baseURL);
                buffer.append(dataset.getCompleteName());
                buffer.append(".dds</dds>\n");
                buffer.append("      <das>");
                buffer.append(baseURL);
                buffer.append(dataset.getCompleteName());
                buffer.append(".das</das>\n");
                buffer.append("   </dataset>\n");
            }
            dataset.getSynch().release();
            ++i;
        }
        buffer.append("</serverdirectory>\n");
        root.getSynch().release();
        page.println(buffer);
        page.flush();
    }
}

