/*
 * Decompiled with CFR 0.152.
 */
package org.iges.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.iges.util.Range;

public class Bounds {

    public static class World
    extends Base {
        public Range.Double lon;
        public Range.Double lat;
        public Range.Double lev;
        public Range.Date time;

        public World(Range.Double _lon, Range.Double _lat, Range.Double _lev, Range.Date _time) {
            this.lon = _lon;
            this.lat = _lat;
            this.lev = _lev;
            this.time = _time;
        }

        public World(String list) throws IllegalArgumentException {
            StringTokenizer st = new StringTokenizer(list);
            double[] bounds = new double[6];
            int i = 0;
            try {
                for (i = 0; i < 6; ++i) {
                    bounds[i] = Double.valueOf(st.nextToken());
                }
                this.lon = new Range.Double(bounds[0], bounds[1]);
                this.lat = new Range.Double(bounds[2], bounds[3]);
                this.lev = new Range.Double(bounds[4], bounds[5]);
                String minDateString = st.nextToken();
                String maxDateString = st.nextToken();
                this.time = new Range.Date(minDateString, maxDateString);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("invalid number format in bounds expression (element " + (i + 1) + ")");
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException("not enough elements in bounds expression");
            }
        }

        public String toString() {
            return "/x=" + this.lon.min + ":" + this.lon.max + "/y=" + this.lat.min + ":" + this.lat.max + "/z=" + this.lev.min + ":" + this.lev.max + "/t=" + this.time.minString + ":" + this.time.maxString;
        }
    }

    public static class Grid
    extends Base {
        public Range.Long x;
        public Range.Long y;
        public Range.Long z;
        public Range.Long t;

        public Grid(long xMin, long xMax, long yMin, long yMax, long zMin, long zMax, long tMin, long tMax) {
            this.x = new Range.Long(xMin, xMax);
            this.y = new Range.Long(yMin, yMax);
            this.z = new Range.Long(zMin, zMax);
            this.t = new Range.Long(tMin, tMax);
        }

        public Grid(Range.Long x, Range.Long y, Range.Long z, Range.Long t) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
        }

        public Grid(String list, boolean zeroBased) throws IllegalArgumentException {
            StringTokenizer st = new StringTokenizer(list);
            long[] bounds = new long[8];
            int i = 0;
            try {
                for (i = 0; i < 8; ++i) {
                    long value = Long.valueOf(st.nextToken());
                    bounds[i] = zeroBased ? value + 1L : value;
                }
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("invalid number format in bounds expression (element " + (i + 1) + ")" + list);
            }
            catch (NullPointerException npe) {
                throw new IllegalArgumentException("not enough elements in bounds expression");
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException("not enough elements in bounds expression");
            }
            this.x = new Range.Long(bounds[0], bounds[1]);
            this.y = new Range.Long(bounds[2], bounds[3]);
            this.z = new Range.Long(bounds[4], bounds[5]);
            this.t = new Range.Long(bounds[6], bounds[7]);
        }

        public boolean equals(Grid grid) {
            return this.x.equals(grid.x) && this.y.equals(grid.y) && this.y.equals(grid.z) && this.y.equals(grid.t);
        }

        public Grid union(Grid grid) {
            return new Grid(this.x.union(grid.x), this.y.union(grid.y), this.z.union(grid.z), this.t.union(grid.t));
        }

        public long getSize() {
            return (Math.abs(this.x.max - this.x.min) + 1L) * (Math.abs(this.y.max - this.y.min) + 1L) * (Math.abs(this.z.max - this.z.min) + 1L) * (Math.abs(this.t.max - this.t.min) + 1L);
        }

        public String toString() {
            return "/i=" + this.x.min + ":" + this.x.max + "/j=" + this.y.min + ":" + this.y.max + "/k=" + this.z.min + ":" + this.z.max + "/l=" + this.t.min + ":" + this.t.max;
        }
    }

    public static abstract class Base {
        public abstract String toString();
    }
}

