/*
 * Decompiled with CFR 0.152.
 */
package org.iges.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ExclusiveLock {
    protected Thread exclusive = null;
    protected int numExclusiveRequests = 0;
    protected Map locks;
    protected Map storedLocks;
    private static boolean DEBUG = false;

    public ExclusiveLock() {
        this.locks = new HashMap();
        this.storedLocks = new HashMap();
    }

    public ExclusiveLock(int expectedMaxLocks) {
        this.locks = new HashMap(expectedMaxLocks);
        this.storedLocks = new HashMap(expectedMaxLocks);
    }

    public synchronized void lockExclusive() {
        if (this.isLockedExclusive()) {
            ++this.numExclusiveRequests;
            if (DEBUG) {
                this.debug("locked ex " + this.numExclusiveRequests);
            }
            return;
        }
        if (this.isLocked()) {
            int numLockRequests = (Integer)this.locks.get(Thread.currentThread());
            this.storedLocks.put(Thread.currentThread(), new Integer(numLockRequests));
            this.locks.remove(Thread.currentThread());
            if (this.locks.size() == 0) {
                this.notifyAll();
            }
        }
        while (this.exclusive != null) {
            if (DEBUG) {
                this.debug("block on ex for ex");
            }
            try {
                this.wait(0L);
            }
            catch (InterruptedException ie) {}
        }
        this.exclusive = Thread.currentThread();
        while (this.locks.size() > 0) {
            if (DEBUG) {
                this.debug("block on non-ex for ex");
            }
            try {
                this.wait(0L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.numExclusiveRequests = 1;
        if (DEBUG) {
            this.debug("locked ex 1");
        }
    }

    public synchronized boolean isLockedExclusive() {
        return this.exclusive == Thread.currentThread();
    }

    public synchronized boolean tryLockExclusive() {
        if (this.isLockedExclusive()) {
            ++this.numExclusiveRequests;
            if (DEBUG) {
                this.debug("locked ex " + this.numExclusiveRequests);
            }
            return true;
        }
        if (this.exclusive == null && (this.locks.size() == 0 || this.locks.size() == 1 && this.locks.containsKey(Thread.currentThread()))) {
            if (this.locks.size() == 1 && this.locks.containsKey(Thread.currentThread())) {
                int numLockRequests = (Integer)this.locks.get(Thread.currentThread());
                this.storedLocks.put(Thread.currentThread(), new Integer(numLockRequests));
                this.locks.remove(Thread.currentThread());
            }
            this.exclusive = Thread.currentThread();
            this.numExclusiveRequests = 1;
            if (DEBUG) {
                this.debug("try for ex succeeded");
            }
            return true;
        }
        if (DEBUG) {
            this.debug("try for ex failed");
        }
        return false;
    }

    public synchronized boolean tryLockExclusive(long timeout) {
        if (this.isLockedExclusive()) {
            ++this.numExclusiveRequests;
            return true;
        }
        if (DEBUG) {
            this.debug("trying " + timeout + "ms for ex");
        }
        long start = System.currentTimeMillis();
        long remaining = timeout;
        while (remaining > 0L) {
            if (this.tryLockExclusive()) {
                return true;
            }
            if (DEBUG) {
                this.debug("waiting " + remaining + "ms for ex");
            }
            try {
                this.wait(remaining);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            remaining = timeout - (System.currentTimeMillis() - start);
        }
        if (DEBUG) {
            this.debug("timed out waiting for ex");
        }
        return false;
    }

    public synchronized boolean isLocked() {
        return this.locks.containsKey(Thread.currentThread());
    }

    public synchronized void lock() {
        while (!this.tryLock()) {
            if (DEBUG) {
                this.debug("block for non-ex");
            }
            try {
                this.wait(0L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void releaseAll() {
        boolean notify = false;
        if (this.isLockedExclusive()) {
            this.exclusive = null;
            this.numExclusiveRequests = 0;
            this.storedLocks.remove(Thread.currentThread());
            if (DEBUG) {
                this.debug("released ex all");
            }
            notify = true;
        }
        if (this.isLocked()) {
            this.locks.remove(Thread.currentThread());
            if (DEBUG) {
                this.debug("released non-ex all");
            }
            if (this.locks.size() == 0) {
                notify = true;
            }
        }
        if (notify) {
            this.notifyAll();
        }
    }

    public synchronized void release() {
        if (this.isLocked()) {
            int numLockRequests = (Integer)this.locks.get(Thread.currentThread());
            if (--numLockRequests > 0) {
                this.locks.put(Thread.currentThread(), new Integer(numLockRequests));
            } else {
                this.locks.remove(Thread.currentThread());
                if (this.locks.size() == 0) {
                    this.notifyAll();
                }
            }
            if (DEBUG) {
                this.debug("released non-ex " + (numLockRequests + 1));
            }
        }
    }

    public synchronized void releaseExclusive() {
        if (this.isLockedExclusive()) {
            --this.numExclusiveRequests;
            if (this.numExclusiveRequests <= 0) {
                this.exclusive = null;
                this.numExclusiveRequests = 0;
                if (this.storedLocks.containsKey(Thread.currentThread())) {
                    int numLockRequests = (Integer)this.storedLocks.get(Thread.currentThread());
                    this.storedLocks.remove(Thread.currentThread());
                    this.locks.put(Thread.currentThread(), new Integer(numLockRequests));
                }
                this.notifyAll();
            }
            if (DEBUG) {
                this.debug("released ex " + (this.numExclusiveRequests + 1));
            }
        }
    }

    public synchronized boolean tryLock() {
        if (this.isLockedExclusive()) {
            return true;
        }
        if (this.isLocked()) {
            int numLockRequests = 0;
            if (this.locks.containsKey(Thread.currentThread())) {
                numLockRequests = (Integer)this.locks.get(Thread.currentThread());
            }
            this.locks.put(Thread.currentThread(), new Integer(++numLockRequests));
            if (DEBUG) {
                this.debug("locked non-ex " + numLockRequests);
            }
            return true;
        }
        if (this.exclusive == null) {
            this.locks.put(Thread.currentThread(), new Integer(1));
            if (DEBUG) {
                this.debug("locked non-ex 1");
            }
            return true;
        }
        return false;
    }

    public synchronized String toString() {
        boolean hasLock = false;
        StringBuffer sb = new StringBuffer();
        sb.append(this.hashCode());
        Iterator it = this.locks.keySet().iterator();
        if (this.exclusive != null) {
            sb.append(" ex = ");
            sb.append(this.exclusive.getName());
            hasLock = true;
        }
        if (this.locks.size() > 0) {
            sb.append(" non-ex = [ ");
            while (it.hasNext()) {
                sb.append(((Thread)it.next()).getName());
                sb.append(" ");
            }
            sb.append("]");
            hasLock = true;
        }
        if (!hasLock) {
            sb.append(" no locks");
        }
        return sb.toString();
    }

    private void debug(String msg) {
        System.err.println("(" + Thread.currentThread().getName() + "/" + (int)((double)System.currentTimeMillis() % 1000000.0) + ")" + this + " --- " + msg);
    }
}

