/*
 * Decompiled with CFR 0.152.
 */
package org.iges.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.iges.anagram.AnagramException;
import org.iges.anagram.filter.AnalysisFilter;

public class FDSUtils {
    protected static final char[] HEXCODE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static String[] ferretCommands = new String[]{"let", "define", "set", "use", "list", "show", "save", "cancel", "go", "file", "frame", "fill", "exit", "contour", "alias", "help", "label", "load", "load", "message", "plot", "pplus", "quit", "repeat", "shade", "spawn", "spaw", "spa", "sp", "statistics", "unalias", "user", "vector", "wire"};
    protected static Set ferretCommandsSet = new HashSet();

    public static String getServletPath(HttpServletRequest request) {
        if (request == null) {
            return "/";
        }
        String url = request.getRequestURI();
        if (url == null) {
            return "/";
        }
        String contextPath = request.getContextPath();
        if (contextPath != null && !contextPath.equals("/") && url.startsWith(contextPath)) {
            url = url.substring(contextPath.length());
        }
        url = FDSUtils.decodeURL(url);
        return url;
    }

    public static String decodeURL(String url) {
        if (url != null) {
            url = url.replaceAll("\\+", "%2B");
            url = URLDecoder.decode(url);
        }
        return url;
    }

    public static String encodeURL(String url) {
        int exprPos;
        if (url != null && (exprPos = url.indexOf("_expr_")) >= 0) {
            String exprURL;
            String ce;
            String baseURL = url.substring(0, exprPos);
            int cePos = url.indexOf("?");
            if (cePos < 0) {
                ce = "";
                exprURL = url.substring(exprPos);
            } else {
                ce = url.substring(cePos);
                exprURL = url.substring(exprPos, cePos);
            }
            exprURL = URLEncoder.encode(exprURL);
            exprURL = exprURL.replaceAll("\\+", "%20");
            url = baseURL + exprURL + ce;
        }
        return url;
    }

    public static int lastIndexOf(char ch, String exp) {
        Stack stack = new Stack();
        int state = 0;
        int lastIndex = -1;
        for (int i = 0; i < exp.length(); ++i) {
            char curCh = exp.charAt(i);
            if (stack.empty() && state == 0 && ch == curCh) {
                lastIndex = i;
            }
            try {
                state = FDSUtils.nextState(curCh, state, stack);
            }
            catch (Exception e) {
                return -1;
            }
            if (!stack.empty() || state != 0 || ch != curCh) continue;
            lastIndex = i;
        }
        try {
            FDSUtils.reportFinalState(state, stack);
        }
        catch (AnagramException ae) {
            return -1;
        }
        return lastIndex;
    }

    public static String stripSpacesFrom(String str) {
        int i;
        int startIndex = 0;
        int endIndex = str.length() - 1;
        for (i = 0; i <= endIndex; ++i) {
            if (str.charAt(i) == ' ') continue;
            startIndex = i;
            break;
        }
        for (i = endIndex; i >= startIndex; --i) {
            if (str.charAt(i) == ' ') continue;
            endIndex = i;
            break;
        }
        str = str.substring(startIndex, endIndex + 1);
        return str;
    }

    public static String compactSpacesFor(String str) throws AnagramException {
        StringBuffer returnVal = new StringBuffer();
        Stack stack = new Stack();
        int state = 0;
        int posLastSpace = -1;
        str = FDSUtils.stripSpacesFrom(str);
        for (int i = 0; i < str.length(); ++i) {
            char curCh = str.charAt(i);
            try {
                state = FDSUtils.nextState(curCh, state, stack);
            }
            catch (Exception e) {
                throw new AnagramException(e.getMessage());
            }
            if (state == 0 && curCh == ' ') {
                if (i > posLastSpace + 1) {
                    returnVal.append(' ');
                }
                posLastSpace = i;
                continue;
            }
            returnVal.append(curCh);
        }
        return returnVal.toString();
    }

    public static void parseFullString(String fullStr) throws AnagramException {
        Stack stack = new Stack();
        int state = 0;
        for (int i = 0; i < fullStr.length(); ++i) {
            char curCh = fullStr.charAt(i);
            try {
                state = FDSUtils.nextState(curCh, state, stack);
                continue;
            }
            catch (Exception e) {
                throw new AnagramException(e.getMessage());
            }
        }
        FDSUtils.reportFinalState(state, stack);
    }

    public static int firstIndexOf(char ch, String exp) throws AnagramException {
        return FDSUtils.firstIndexOf(ch, exp, 0);
    }

    public static int firstIndexOf(char ch, String exp, int startIndex) throws AnagramException {
        Stack stack = new Stack();
        int state = 0;
        for (int i = 0; i < exp.length(); ++i) {
            char curCh = exp.charAt(i);
            if (stack.empty() && state == 0 && ch == curCh && i >= startIndex) {
                return i;
            }
            try {
                state = FDSUtils.nextState(curCh, state, stack);
            }
            catch (Exception e) {
                throw new AnagramException(e.getMessage());
            }
            if (!stack.empty() || state != 0 || ch != curCh || i < startIndex) continue;
            return i;
        }
        FDSUtils.reportFinalState(state, stack);
        return -1;
    }

    protected static int nextState(char curCh, int state, Stack stack) throws Exception {
        if (state == 2 || state == 4 || state == 6) {
            state = state == 2 ? 1 : (state == 4 ? 3 : 5);
        } else {
            switch (curCh) {
                case '{': {
                    if (state != 0) break;
                    stack.push("{");
                    break;
                }
                case '}': {
                    String popCh;
                    if (state != 0 || (popCh = (String)stack.pop()).equals("{")) break;
                    throw new AnagramException("" + popCh + " is not matched.");
                }
                case '[': {
                    if (state != 0) break;
                    stack.push("[");
                    break;
                }
                case ']': {
                    String popCh;
                    if (state != 0 || (popCh = (String)stack.pop()).equals("[")) break;
                    throw new AnagramException("" + popCh + " is not matched.");
                }
                case '(': {
                    if (state != 0) break;
                    stack.push("(");
                    break;
                }
                case ')': {
                    String popCh;
                    if (state != 0 || (popCh = (String)stack.pop()).equals("(")) break;
                    throw new AnagramException("" + popCh + " is not matched.");
                }
                case '\"': {
                    if (state == 0) {
                        state = 1;
                        break;
                    }
                    if (state != 1) break;
                    state = 0;
                    break;
                }
                case '\'': {
                    if (state == 0) {
                        state = 3;
                        break;
                    }
                    if (state != 3) break;
                    state = 0;
                    break;
                }
                case '`': {
                    if (state == 0) {
                        state = 5;
                        break;
                    }
                    if (state != 5) break;
                    state = 0;
                    break;
                }
                case '\\': {
                    if (state == 1) {
                        state = 2;
                        break;
                    }
                    if (state == 3) {
                        state = 4;
                        break;
                    }
                    if (state != 5) break;
                    state = 6;
                    break;
                }
            }
        }
        return state;
    }

    protected static void reportFinalState(int state, Stack stack) throws AnagramException {
        if (state != 0) {
            if (state == 1 || state == 2) {
                throw new AnagramException("\"\" pairs are not matched.");
            }
            if (state == 3 || state == 4) {
                throw new AnagramException("'' pairs are not matched.");
            }
            throw new AnagramException("`` pairs are not matched.");
        }
        if (!stack.empty()) {
            String peepCh = (String)stack.peek();
            if (peepCh.equals("{")) {
                throw new AnagramException("{ is not matched.");
            }
            if (peepCh.equals("[")) {
                throw new AnagramException("[ is not matched.");
            }
            throw new AnagramException("( is not matched.");
        }
    }

    public static boolean isFerretCommand(String exp) {
        StringTokenizer st = new StringTokenizer(exp, " /");
        if (st.hasMoreTokens()) {
            String next = st.nextToken();
            return ferretCommandsSet.contains(next);
        }
        return false;
    }

    public static String MD5Encode(String str) {
        String returnVal = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] mdArr = md.digest(str.getBytes("UTF-16"));
            returnVal = FDSUtils.toHexString(mdArr);
        }
        catch (Exception e) {
            returnVal = URLEncoder.encode(str.substring(AnalysisFilter.ANALYSIS_PREFIX.length())).replaceAll("\\*", "x");
        }
        return returnVal;
    }

    protected static String toHexString(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            chars[2 * i] = HEXCODE[(bytes[i] & 0xF0) >>> 4];
            chars[2 * i + 1] = HEXCODE[bytes[i] & 0xF];
        }
        return new String(chars);
    }

    static {
        for (int i = 0; i < ferretCommands.length; ++i) {
            ferretCommandsSet.add(ferretCommands[i]);
        }
    }
}

