/*
 * Decompiled with CFR 0.152.
 */
package org.iges.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;

public class Range {
    public static String printFerretDate(java.util.Date date) {
        SimpleDateFormat ferretFormat = new SimpleDateFormat("yyyy:M:d:H:m");
        return ferretFormat.format(date);
    }

    public static java.util.Date parseFerretFormat(String dateString) throws IllegalArgumentException {
        SimpleDateFormat ctlFormat;
        SimpleDateFormat ctlHourFormat;
        ParsePosition pos;
        SimpleDateFormat minuteFormat = new SimpleDateFormat("yyyy:M:d:H:m z");
        java.util.Date parsedDate = minuteFormat.parse(dateString = dateString.toLowerCase() + " GMT", pos = new ParsePosition(0));
        if (parsedDate == null) {
            SimpleDateFormat hourFormat = new SimpleDateFormat("yyyy:M:d:H z");
            parsedDate = hourFormat.parse(dateString, pos);
        }
        if (parsedDate == null) {
            ctlHourFormat = new SimpleDateFormat("H:m'z'ddMMMyyyy z");
            parsedDate = ctlHourFormat.parse(dateString, pos);
        }
        if (parsedDate == null) {
            ctlHourFormat = new SimpleDateFormat("H'z'ddMMMyyyy z");
            parsedDate = ctlHourFormat.parse(dateString, pos);
        }
        if (parsedDate == null) {
            ctlFormat = new SimpleDateFormat("ddMMMyyyy z");
            parsedDate = ctlFormat.parse(dateString, pos);
        }
        if (parsedDate == null) {
            ctlFormat = new SimpleDateFormat("MMMyyyy z");
            parsedDate = ctlFormat.parse(dateString, pos);
        }
        if (parsedDate == null) {
            throw new IllegalArgumentException("Can't parse date string: " + dateString);
        }
        return parsedDate;
    }

    public static class Date {
        public java.util.Date min;
        public java.util.Date max;
        public String minString;
        public String maxString;

        public Date(String _minString, String _maxString) {
            this.minString = _minString;
            this.maxString = _maxString;
        }

        protected void parseDates() {
            this.min = Range.parseFerretFormat(this.minString);
            this.max = Range.parseFerretFormat(this.maxString);
            if (this.min == null) {
                throw new IllegalArgumentException(this.minString + " is not a valid Ferret date");
            }
            if (this.max == null) {
                throw new IllegalArgumentException(this.maxString + " is not a valid Ferret date");
            }
        }

        public boolean contains(Date range) throws IllegalArgumentException {
            this.parseDates();
            return this.min.getTime() <= range.min.getTime() && this.max.getTime() >= range.max.getTime();
        }

        public boolean overlaps(Date range) throws IllegalArgumentException {
            this.parseDates();
            return range.min.getTime() <= this.max.getTime() && range.max.getTime() >= this.min.getTime();
        }

        public String toString() {
            return "(" + this.min + ", " + this.max + ")";
        }
    }

    public static class Long {
        public long min;
        public long max;

        public Long(long _min, long _max) {
            this.min = _min;
            this.max = _max;
        }

        public boolean contains(Long range) {
            return this.min <= range.min && this.max >= range.max;
        }

        public boolean overlaps(Long range) {
            return range.min <= this.max && range.max >= this.min;
        }

        public Long union(Long range) {
            return new Long(Math.min(this.min, range.min), Math.max(this.max, range.max));
        }

        public long size() {
            return this.max - this.min + 1L;
        }

        public String toString() {
            return "(" + this.min + ", " + this.max + ")";
        }
    }

    public static class Double {
        public double min;
        public double max;

        public Double(double _min, double _max) {
            this.min = _min;
            this.max = _max;
        }

        public boolean contains(Double range) {
            return this.min <= range.min && this.max >= range.max;
        }

        public boolean overlaps(Double range) {
            return range.min <= this.max && range.max >= this.min;
        }

        public boolean equals(Double range) {
            return this.min == range.min && this.max == range.max;
        }

        public String toString() {
            return "(" + this.min + ", " + this.max + ")";
        }
    }
}

