/*
 * Decompiled with CFR 0.152.
 */
package org.iges.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class Spooler {
    private static final boolean DEBUG = false;

    public static long spool(Reader r, Writer w) throws IOException {
        return Spooler.spool(r, w, 1024);
    }

    public static long spool(Reader r, Writer w, int bufferSize) throws IOException {
        char[] buf = new char[bufferSize];
        int bytesRead = 0;
        long totalBytesRead = 0L;
        while ((bytesRead = r.read(buf)) >= 0) {
            w.write(buf, 0, bytesRead);
            totalBytesRead += (long)bytesRead;
        }
        return totalBytesRead;
    }

    public static long spool(InputStream in, OutputStream out) throws IOException {
        return Spooler.spool(in, out, 1024);
    }

    public static long spool(InputStream in, OutputStream out, int bufferSize) throws IOException {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("invalid buffer size " + bufferSize);
        }
        byte[] buf = new byte[bufferSize];
        int bytesRead = 0;
        long totalBytesWritten = 0L;
        while ((bytesRead = in.read(buf)) >= 0) {
            out.write(buf, 0, bytesRead);
            totalBytesWritten += (long)bytesRead;
        }
        return totalBytesWritten;
    }

    public static long spool(long totalBytesToWrite, InputStream in, OutputStream out, int bufferSize) throws IOException {
        long bytesLeft;
        byte[] buf = new byte[bufferSize];
        int bytesRead = 0;
        long totalBytesWritten = 0L;
        while (true) {
            if ((bytesRead = in.read(buf)) < 0) {
                throw new IOException("ran out of input while spooling " + totalBytesToWrite + " bytes");
            }
            bytesLeft = totalBytesToWrite - totalBytesWritten;
            if (bytesLeft <= (long)bytesRead) break;
            out.write(buf, 0, bytesRead);
            totalBytesWritten += (long)bytesRead;
        }
        out.write(buf, 0, (int)bytesLeft);
        return totalBytesWritten += bytesLeft;
    }
}

