/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AncillaryData;
import edu.wisc.ssec.mcidas.Calibrator;
import edu.wisc.ssec.mcidas.ConversionUtility;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class CalibratorGvar
implements Calibrator {
    protected static final int NUM_BANDS_IMAGER = 5;
    protected static final int NUM_BANDS_SOUNDER = 18;
    protected static final int NUM_VIS_DETECTORS = 8;
    protected static final int NUM_IR_DETECTORS = 2;
    protected static final int NUM_IR_BANDS = 4;
    protected static final int LOOKUP_TABLE_SZ_IMGR = 1024;
    protected static final int LOOKUP_TABLE_SZ_SNDR = 32768;
    protected static int curCalType = 0;
    protected static int index = 0;
    protected float[] visBiasCoef = new float[8];
    protected float[] visGain1Coef = new float[8];
    protected float[] visGain2Coef = new float[8];
    protected float visRadToAlb = 0.0f;
    protected float[][] irBiasCoef = new float[2][4];
    protected float[][] irGainCoef = new float[2][4];
    protected float[] sBiasCoef = new float[18];
    protected float[] sGainCoef = new float[18];
    protected float[][] lookupTable;
    private static float gain = 0.0f;
    private static float bias = 0.0f;
    private static int scale = 1;
    private static int bandNum = 0;
    private static int sid = 0;

    public CalibratorGvar(DataInputStream dis, AncillaryData ad, int[] calBlock) throws IOException {
        this(ad.getSensorId(), calBlock);
    }

    public CalibratorGvar(int sensorId, int[] calBlock) {
        int calIndex = 0;
        sid = sensorId;
        if (sid % 2 == 0) {
            int i;
            this.lookupTable = new float[5][1024];
            for (i = 0; i < 5; ++i) {
                for (int j = 0; j < 1024; ++j) {
                    this.lookupTable[i][j] = Float.NaN;
                }
            }
            for (i = 0; i < 8; ++i) {
                this.visBiasCoef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            for (i = 0; i < 8; ++i) {
                this.visGain1Coef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            for (i = 0; i < 8; ++i) {
                this.visGain2Coef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            this.visRadToAlb = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
            ++calIndex;
            for (i = 0; i < 4; ++i) {
                this.irBiasCoef[0][(i + 2) % 4] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            for (i = 0; i < 4; ++i) {
                this.irBiasCoef[1][(i + 2) % 4] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            for (i = 0; i < 4; ++i) {
                this.irGainCoef[0][(i + 2) % 4] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            for (i = 0; i < 4; ++i) {
                this.irGainCoef[1][(i + 2) % 4] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
        } else {
            int i;
            this.lookupTable = new float[19][32768];
            for (i = 0; i < 19; ++i) {
                for (int j = 0; j < 32768; ++j) {
                    this.lookupTable[i][j] = Float.NaN;
                }
            }
            for (i = 0; i < 4; ++i) {
                this.visBiasCoef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            for (i = 0; i < 4; ++i) {
                this.visGain1Coef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            for (i = 0; i < 4; ++i) {
                this.visGain2Coef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            this.visRadToAlb = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
            ++calIndex;
            for (i = 0; i < 18; ++i) {
                this.sBiasCoef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            for (i = 0; i < 18; ++i) {
                this.sGainCoef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
        }
    }

    public int setCalType(int calType) {
        if (calType < 1 || calType > 5) {
            return -1;
        }
        curCalType = calType;
        return 0;
    }

    public abstract float radToTemp(float var1, int var2, int var3);

    public float[] calibrate(float[] inputData, int band, int calTypeOut) {
        float[] outputData = new float[inputData.length];
        for (int i = 0; i < inputData.length; ++i) {
            outputData[i] = this.calibrate(inputData[i], band, calTypeOut);
        }
        return outputData;
    }

    public float calibrate(float inputPixel, int band, int calTypeOut) {
        float outputData = 0.0f;
        if (band != bandNum) {
            bandNum = band;
            if (sid % 2 == 0) {
                if (band == 1) {
                    gain = this.visGain1Coef[0];
                    bias = this.visBiasCoef[0];
                } else {
                    gain = this.irGainCoef[0][band - 2];
                    bias = this.irBiasCoef[0][band - 2];
                }
                scale = 32;
            } else {
                if (band == 19) {
                    gain = this.visGain1Coef[0];
                    bias = this.visBiasCoef[0];
                } else {
                    gain = this.sGainCoef[band - 1];
                    bias = this.sBiasCoef[band - 1];
                }
                scale = 2;
            }
        }
        if (!Float.isNaN(this.lookupTable[band - 1][index = curCalType == 5 ? (int)inputPixel + 128 : (int)inputPixel / scale])) {
            return this.lookupTable[band - 1][index];
        }
        switch (curCalType) {
            case 1: {
                outputData = inputPixel;
                if (calTypeOut == 1) break;
                if (sid % 2 == 0) {
                    outputData = inputPixel / (float)scale;
                }
                outputData = (outputData - bias) / gain;
                if (calTypeOut == 2) break;
                outputData = this.radToTemp(outputData, band, sid);
                if (calTypeOut == 4) break;
                outputData = outputData >= 242.0f ? (float)Math.max(660 - (int)(outputData * 2.0f), 0) : (float)Math.min(418 - (int)outputData, 255);
                if (calTypeOut != 5) break;
                break;
            }
            case 2: {
                outputData = inputPixel;
                break;
            }
            case 3: {
                outputData = inputPixel;
                break;
            }
            case 4: {
                outputData = inputPixel;
                break;
            }
            case 5: {
                outputData = inputPixel;
            }
        }
        this.lookupTable[band - 1][CalibratorGvar.index] = outputData;
        return outputData;
    }
}

