/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.ImageTools;
import loci.formats.LogTools;
import loci.formats.RandomAccessStream;
import loci.formats.TiffIFDEntry;
import loci.formats.TiffRational;
import loci.formats.UnknownTagException;
import loci.formats.codec.AdobeDeflateCodec;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.LZWCodec;
import loci.formats.codec.LuraWaveCodec;
import loci.formats.codec.PackbitsCodec;

public final class TiffTools {
    private static final boolean DEBUG = false;
    public static final int BYTES_PER_ENTRY = 12;
    public static final int BIG_TIFF_BYTES_PER_ENTRY = 20;
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_TIFF = 1;
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int FLOAT = 11;
    public static final int DOUBLE = 12;
    public static final int LONG8 = 16;
    public static final int SLONG8 = 17;
    public static final int IFD8 = 18;
    public static final int[] BYTES_PER_ELEMENT = new int[]{-1, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8, -1, -1, -1, -1, 8, 8, 8};
    public static final int NEW_SUBFILE_TYPE = 254;
    public static final int SUBFILE_TYPE = 255;
    public static final int IMAGE_WIDTH = 256;
    public static final int IMAGE_LENGTH = 257;
    public static final int BITS_PER_SAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTOMETRIC_INTERPRETATION = 262;
    public static final int THRESHHOLDING = 263;
    public static final int CELL_WIDTH = 264;
    public static final int CELL_LENGTH = 265;
    public static final int FILL_ORDER = 266;
    public static final int DOCUMENT_NAME = 269;
    public static final int IMAGE_DESCRIPTION = 270;
    public static final int MAKE = 271;
    public static final int MODEL = 272;
    public static final int STRIP_OFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLES_PER_PIXEL = 277;
    public static final int ROWS_PER_STRIP = 278;
    public static final int STRIP_BYTE_COUNTS = 279;
    public static final int MIN_SAMPLE_VALUE = 280;
    public static final int MAX_SAMPLE_VALUE = 281;
    public static final int X_RESOLUTION = 282;
    public static final int Y_RESOLUTION = 283;
    public static final int PLANAR_CONFIGURATION = 284;
    public static final int PAGE_NAME = 285;
    public static final int X_POSITION = 286;
    public static final int Y_POSITION = 287;
    public static final int FREE_OFFSETS = 288;
    public static final int FREE_BYTE_COUNTS = 289;
    public static final int GRAY_RESPONSE_UNIT = 290;
    public static final int GRAY_RESPONSE_CURVE = 291;
    public static final int T4_OPTIONS = 292;
    public static final int T6_OPTIONS = 293;
    public static final int RESOLUTION_UNIT = 296;
    public static final int PAGE_NUMBER = 297;
    public static final int TRANSFER_FUNCTION = 301;
    public static final int SOFTWARE = 305;
    public static final int DATE_TIME = 306;
    public static final int ARTIST = 315;
    public static final int HOST_COMPUTER = 316;
    public static final int PREDICTOR = 317;
    public static final int WHITE_POINT = 318;
    public static final int PRIMARY_CHROMATICITIES = 319;
    public static final int COLOR_MAP = 320;
    public static final int HALFTONE_HINTS = 321;
    public static final int TILE_WIDTH = 322;
    public static final int TILE_LENGTH = 323;
    public static final int TILE_OFFSETS = 324;
    public static final int TILE_BYTE_COUNTS = 325;
    public static final int INK_SET = 332;
    public static final int INK_NAMES = 333;
    public static final int NUMBER_OF_INKS = 334;
    public static final int DOT_RANGE = 336;
    public static final int TARGET_PRINTER = 337;
    public static final int EXTRA_SAMPLES = 338;
    public static final int SAMPLE_FORMAT = 339;
    public static final int S_MIN_SAMPLE_VALUE = 340;
    public static final int S_MAX_SAMPLE_VALUE = 341;
    public static final int TRANSFER_RANGE = 342;
    public static final int JPEG_PROC = 512;
    public static final int JPEG_INTERCHANGE_FORMAT = 513;
    public static final int JPEG_INTERCHANGE_FORMAT_LENGTH = 514;
    public static final int JPEG_RESTART_INTERVAL = 515;
    public static final int JPEG_LOSSLESS_PREDICTORS = 517;
    public static final int JPEG_POINT_TRANSFORMS = 518;
    public static final int JPEG_Q_TABLES = 519;
    public static final int JPEG_DC_TABLES = 520;
    public static final int JPEG_AC_TABLES = 521;
    public static final int Y_CB_CR_COEFFICIENTS = 529;
    public static final int Y_CB_CR_SUB_SAMPLING = 530;
    public static final int Y_CB_CR_POSITIONING = 531;
    public static final int REFERENCE_BLACK_WHITE = 532;
    public static final int COPYRIGHT = 33432;
    public static final int UNCOMPRESSED = 1;
    public static final int CCITT_1D = 2;
    public static final int GROUP_3_FAX = 3;
    public static final int GROUP_4_FAX = 4;
    public static final int LZW = 5;
    public static final int JPEG = 7;
    public static final int PACK_BITS = 32773;
    public static final int PROPRIETARY_DEFLATE = 32946;
    public static final int DEFLATE = 8;
    public static final int THUNDERSCAN = 32809;
    public static final int NIKON = 34713;
    public static final int LURAWAVE = -1;
    public static final int WHITE_IS_ZERO = 0;
    public static final int BLACK_IS_ZERO = 1;
    public static final int RGB = 2;
    public static final int RGB_PALETTE = 3;
    public static final int TRANSPARENCY_MASK = 4;
    public static final int CMYK = 5;
    public static final int Y_CB_CR = 6;
    public static final int CIE_LAB = 8;
    public static final int CFA_ARRAY = -32733;
    public static final int MAGIC_NUMBER = 42;
    public static final int BIG_TIFF_MAGIC_NUMBER = 43;
    public static final int LITTLE = 73;
    public static final int BIG = 77;

    private TiffTools() {
    }

    public static boolean isValidHeader(byte[] block) {
        return TiffTools.checkHeader(block) != null;
    }

    public static Boolean checkHeader(byte[] block) {
        boolean bigEndian;
        if (block.length < 4) {
            return null;
        }
        boolean littleEndian = block[0] == 73 && block[1] == 73;
        boolean bl = bigEndian = block[0] == 77 && block[1] == 77;
        if (!littleEndian && !bigEndian) {
            return null;
        }
        short magic = DataTools.bytesToShort(block, 2, littleEndian);
        if (magic != 42 && magic != 43) {
            return null;
        }
        return new Boolean(littleEndian);
    }

    public static boolean isBigTiff(Hashtable ifd) throws FormatException {
        return (Boolean)TiffTools.getIFDValue(ifd, 1, false, Boolean.class);
    }

    public static boolean isLittleEndian(Hashtable ifd) throws FormatException {
        return (Boolean)TiffTools.getIFDValue(ifd, 0, true, Boolean.class);
    }

    public static Hashtable[] getIFDs(RandomAccessStream in) throws IOException {
        Hashtable ifd;
        Boolean result = TiffTools.checkHeader(in);
        if (result == null) {
            return null;
        }
        in.seek(2L);
        boolean bigTiff = in.readShort() == 43;
        long offset = TiffTools.getFirstOffset(in, bigTiff);
        long ifdMax = (in.length() - 8L) / 18L;
        Vector<Hashtable> v = new Vector<Hashtable>();
        for (long ifdNum = 0L; ifdNum < ifdMax && (ifd = TiffTools.getIFD(in, ifdNum, offset, bigTiff)) != null && ifd.size() > 1; ++ifdNum) {
            v.add(ifd);
            long l = offset = bigTiff ? in.readLong() : (long)in.readInt();
            if (offset <= 0L || offset >= in.length()) break;
        }
        Object[] ifds = new Hashtable[v.size()];
        v.copyInto(ifds);
        return ifds;
    }

    public static Hashtable getFirstIFD(RandomAccessStream in) throws IOException {
        Boolean result = TiffTools.checkHeader(in);
        if (result == null) {
            return null;
        }
        long offset = TiffTools.getFirstOffset(in);
        return TiffTools.getIFD(in, 0L, offset);
    }

    public static TiffIFDEntry getFirstIFDEntry(RandomAccessStream in, int tag) throws IOException {
        Boolean result = TiffTools.checkHeader(in);
        if (result == null) {
            return null;
        }
        long offset = TiffTools.getFirstOffset(in);
        in.seek(offset);
        int numEntries = in.readShort() & 0xFFFF;
        for (int i = 0; i < numEntries; ++i) {
            in.seek(offset + 2L + (long)(12 * i));
            int entryTag = in.readShort() & 0xFFFF;
            if (entryTag != tag) continue;
            int entryType = in.readShort() & 0xFFFF;
            int valueCount = in.readInt();
            if (valueCount < 0) {
                throw new RuntimeException("Count of '" + valueCount + "' unexpected.");
            }
            int valueOffset = in.readInt();
            return new TiffIFDEntry(entryTag, entryType, valueCount, valueOffset);
        }
        throw new UnknownTagException();
    }

    public static Boolean checkHeader(RandomAccessStream in) throws IOException {
        in.seek(0L);
        byte[] header = new byte[4];
        in.readFully(header);
        Boolean b = TiffTools.checkHeader(header);
        if (b != null) {
            in.order(b);
        }
        return b;
    }

    public static long getFirstOffset(RandomAccessStream in) throws IOException {
        return TiffTools.getFirstOffset(in, false);
    }

    public static long getFirstOffset(RandomAccessStream in, boolean bigTiff) throws IOException {
        if (bigTiff) {
            in.skipBytes(4);
        }
        return bigTiff ? in.readLong() : (long)in.readInt();
    }

    public static Hashtable getIFD(RandomAccessStream in, long ifdNum, long offset) throws IOException {
        return TiffTools.getIFD(in, ifdNum, offset, false);
    }

    public static Hashtable getIFD(RandomAccessStream in, long ifdNum, long offset, boolean bigTiff) throws IOException {
        long numEntries;
        Hashtable<Integer, Object> ifd = new Hashtable<Integer, Object>();
        ifd.put(new Integer(0), new Boolean(in.isLittleEndian()));
        ifd.put(new Integer(1), new Boolean(bigTiff));
        in.seek(offset);
        long l = numEntries = bigTiff ? in.readLong() : (long)(in.readShort() & 0xFFFF);
        if (numEntries == 0L || numEntries == 1L) {
            return ifd;
        }
        int bytesPerEntry = bigTiff ? 20 : 12;
        int baseOffset = bigTiff ? 8 : 2;
        int threshhold = bigTiff ? 8 : 4;
        int i = 0;
        while ((long)i < numEntries) {
            int j;
            int count;
            in.seek(offset + (long)baseOffset + (long)(bytesPerEntry * i));
            int tag = in.readShort() & 0xFFFF;
            int type = in.readShort() & 0xFFFF;
            int n = count = bigTiff ? (int)(in.readLong() & 0xFFFFFFFFFFFFFFFFL) : in.readInt();
            if (count < 0) {
                return null;
            }
            Object value = null;
            if (type == 1) {
                if (count > threshhold) {
                    long pointer = bigTiff ? in.readLong() : (long)in.readInt();
                    in.seek(pointer);
                }
                if (count == 1) {
                    value = new Short(in.readByte());
                } else {
                    short[] bytes = new short[count];
                    for (j = 0; j < count; ++j) {
                        bytes[j] = in.readByte();
                        if (bytes[j] >= 0) continue;
                        int n2 = j;
                        bytes[n2] = (short)(bytes[n2] + 255);
                    }
                    value = bytes;
                }
            } else if (type == 2) {
                byte[] ascii = new byte[count];
                if (count > threshhold) {
                    long pointer = bigTiff ? in.readLong() : (long)in.readInt();
                    in.seek(pointer);
                }
                in.read(ascii);
                int nullCount = 0;
                for (int j2 = 0; j2 < count; ++j2) {
                    if (ascii[j2] != 0 && j2 != count - 1) continue;
                    ++nullCount;
                }
                String[] strings = nullCount == 1 ? null : new String[nullCount];
                Object s = null;
                int c = 0;
                int ndx = -1;
                for (int j3 = 0; j3 < count; ++j3) {
                    if (ascii[j3] == 0) {
                        s = new String(ascii, ndx + 1, j3 - ndx - 1);
                        ndx = j3;
                    } else {
                        s = j3 == count - 1 ? new String(ascii, ndx + 1, j3 - ndx) : null;
                    }
                    if (strings == null || s == null) continue;
                    strings[c++] = s;
                }
                value = strings == null ? s : strings;
            } else if (type == 3) {
                if (count > threshhold / 2) {
                    long pointer = bigTiff ? in.readLong() : (long)in.readInt();
                    in.seek(pointer);
                }
                if (count == 1) {
                    value = new Integer(in.readShort());
                } else {
                    int[] shorts = new int[count];
                    for (j = 0; j < count; ++j) {
                        shorts[j] = in.readShort() & 0xFFFF;
                    }
                    value = shorts;
                }
            } else if (type == 4) {
                if (count > threshhold / 4) {
                    long pointer = bigTiff ? in.readLong() : (long)in.readInt();
                    in.seek(pointer);
                }
                if (count == 1) {
                    value = new Long(in.readInt());
                } else {
                    long[] longs = new long[count];
                    for (j = 0; j < count; ++j) {
                        longs[j] = in.readInt();
                    }
                    value = longs;
                }
            } else if (type == 16 || type == 17 || type == 18) {
                if (count > threshhold / 8) {
                    long pointer = bigTiff ? in.readLong() : (long)in.readInt();
                    in.seek(pointer);
                }
                if (count == 1) {
                    value = new Long(in.readLong());
                } else {
                    long[] longs = new long[count];
                    for (j = 0; j < count; ++j) {
                        longs[j] = in.readLong();
                    }
                    value = longs;
                }
            } else if (type == 5 || type == 10) {
                long pointer;
                long l2 = pointer = bigTiff ? in.readLong() : (long)in.readInt();
                if (count > threshhold / 8) {
                    in.seek(pointer);
                }
                if (count == 1) {
                    value = new TiffRational(in.readInt(), in.readInt());
                } else {
                    TiffRational[] rationals = new TiffRational[count];
                    for (int j4 = 0; j4 < count; ++j4) {
                        rationals[j4] = new TiffRational(in.readInt(), in.readInt());
                    }
                    value = rationals;
                }
            } else if (type == 6 || type == 7) {
                if (count > threshhold) {
                    long pointer = bigTiff ? in.readLong() : (long)in.readInt();
                    in.seek(pointer);
                }
                if (count == 1) {
                    value = new Byte(in.readByte());
                } else {
                    byte[] sbytes = new byte[count];
                    in.readFully(sbytes);
                    value = sbytes;
                }
            } else if (type == 8) {
                if (count > threshhold / 2) {
                    long pointer = bigTiff ? in.readLong() : (long)in.readInt();
                    in.seek(pointer);
                }
                if (count == 1) {
                    value = new Short(in.readShort());
                } else {
                    short[] sshorts = new short[count];
                    for (j = 0; j < count; ++j) {
                        sshorts[j] = in.readShort();
                    }
                    value = sshorts;
                }
            } else if (type == 9) {
                if (count > threshhold / 4) {
                    long pointer = bigTiff ? in.readLong() : (long)in.readInt();
                    in.seek(pointer);
                }
                if (count == 1) {
                    value = new Integer(in.readInt());
                } else {
                    int[] slongs = new int[count];
                    for (j = 0; j < count; ++j) {
                        slongs[j] = in.readInt();
                    }
                    value = slongs;
                }
            } else if (type == 11) {
                if (count > threshhold / 4) {
                    long pointer = bigTiff ? in.readLong() : (long)in.readInt();
                    in.seek(pointer);
                }
                if (count == 1) {
                    value = new Float(in.readFloat());
                } else {
                    float[] floats = new float[count];
                    for (j = 0; j < count; ++j) {
                        floats[j] = in.readFloat();
                    }
                    value = floats;
                }
            } else if (type == 12) {
                long pointer = bigTiff ? in.readLong() : (long)in.readInt();
                in.seek(pointer);
                if (count == 1) {
                    value = new Double(in.readDouble());
                } else {
                    double[] doubles = new double[count];
                    for (int j5 = 0; j5 < count; ++j5) {
                        doubles[j5] = in.readDouble();
                    }
                    value = doubles;
                }
            }
            if (value != null) {
                ifd.put(new Integer(tag), value);
            }
            ++i;
        }
        in.seek(offset + (long)baseOffset + (long)bytesPerEntry * numEntries);
        return ifd;
    }

    public static String getIFDTagName(int tag) {
        return TiffTools.getFieldName(tag);
    }

    public static String getIFDTypeName(int type) {
        return TiffTools.getFieldName(type);
    }

    public static String getFieldName(int value) {
        Field[] fields = TiffTools.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                if (fields[i].getInt(null) != value) continue;
                return fields[i].getName();
            }
            catch (IllegalAccessException exc) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return "" + value;
    }

    public static Object getIFDValue(Hashtable ifd, int tag) {
        return ifd.get(new Integer(tag));
    }

    public static Object getIFDValue(Hashtable ifd, int tag, boolean checkNull, Class checkClass) throws FormatException {
        Object value = ifd.get(new Integer(tag));
        if (checkNull && value == null) {
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry not found");
        }
        if (checkClass != null && value != null && !checkClass.isInstance(value)) {
            Class<?> cType = checkClass.getComponentType();
            Object array = null;
            if (cType == value.getClass()) {
                array = Array.newInstance(value.getClass(), 1);
                Array.set(array, 0, value);
            }
            if (cType == Boolean.TYPE && value instanceof Boolean) {
                array = Array.newInstance(Boolean.TYPE, 1);
                Array.setBoolean(array, 0, (Boolean)value);
            } else if (cType == Byte.TYPE && value instanceof Byte) {
                array = Array.newInstance(Byte.TYPE, 1);
                Array.setByte(array, 0, (Byte)value);
            } else if (cType == Character.TYPE && value instanceof Character) {
                array = Array.newInstance(Character.TYPE, 1);
                Array.setChar(array, 0, ((Character)value).charValue());
            } else if (cType == Double.TYPE && value instanceof Double) {
                array = Array.newInstance(Double.TYPE, 1);
                Array.setDouble(array, 0, (Double)value);
            } else if (cType == Float.TYPE && value instanceof Float) {
                array = Array.newInstance(Float.TYPE, 1);
                Array.setFloat(array, 0, ((Float)value).floatValue());
            } else if (cType == Integer.TYPE && value instanceof Integer) {
                array = Array.newInstance(Integer.TYPE, 1);
                Array.setInt(array, 0, (Integer)value);
            } else if (cType == Long.TYPE && value instanceof Long) {
                array = Array.newInstance(Long.TYPE, 1);
                Array.setLong(array, 0, (Long)value);
            } else if (cType == Short.TYPE && value instanceof Short) {
                array = Array.newInstance(Short.TYPE, 1);
                Array.setShort(array, 0, (Short)value);
            }
            if (array != null) {
                return array;
            }
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected " + checkClass.getName());
        }
        return value;
    }

    public static long getIFDLongValue(Hashtable ifd, int tag, boolean checkNull, long defaultValue) throws FormatException {
        long value = defaultValue;
        Number number = (Number)TiffTools.getIFDValue(ifd, tag, checkNull, Number.class);
        if (number != null) {
            value = number.longValue();
        }
        return value;
    }

    public static int getIFDIntValue(Hashtable ifd, int tag) {
        int value = -1;
        try {
            value = TiffTools.getIFDIntValue(ifd, tag, false, -1);
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return value;
    }

    public static int getIFDIntValue(Hashtable ifd, int tag, boolean checkNull, int defaultValue) throws FormatException {
        int value = defaultValue;
        Number number = (Number)TiffTools.getIFDValue(ifd, tag, checkNull, Number.class);
        if (number != null) {
            value = number.intValue();
        }
        return value;
    }

    public static TiffRational getIFDRationalValue(Hashtable ifd, int tag, boolean checkNull) throws FormatException {
        return (TiffRational)TiffTools.getIFDValue(ifd, tag, checkNull, TiffRational.class);
    }

    public static long[] getIFDLongArray(Hashtable ifd, int tag, boolean checkNull) throws FormatException {
        Object value = TiffTools.getIFDValue(ifd, tag, checkNull, null);
        long[] results = null;
        if (value instanceof long[]) {
            results = (long[])value;
        } else if (value instanceof Number) {
            results = new long[]{((Number)value).longValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new long[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].longValue();
            }
        } else if (value instanceof int[]) {
            int[] integers = (int[])value;
            results = new long[integers.length];
            for (int i = 0; i < integers.length; ++i) {
                results[i] = integers[i];
            }
        } else if (value != null) {
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, long[], Number[] or int[])");
        }
        return results;
    }

    public static int[] getIFDIntArray(Hashtable ifd, int tag, boolean checkNull) throws FormatException {
        Object value = TiffTools.getIFDValue(ifd, tag, checkNull, null);
        int[] results = null;
        if (value instanceof int[]) {
            results = (int[])value;
        } else if (value instanceof Number) {
            results = new int[]{((Number)value).intValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new int[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].intValue();
            }
        } else if (value != null) {
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, int[] or Number[])");
        }
        return results;
    }

    public static short[] getIFDShortArray(Hashtable ifd, int tag, boolean checkNull) throws FormatException {
        Object value = TiffTools.getIFDValue(ifd, tag, checkNull, null);
        short[] results = null;
        if (value instanceof short[]) {
            results = (short[])value;
        } else if (value instanceof Number) {
            results = new short[]{((Number)value).shortValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new short[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].shortValue();
            }
        } else if (value != null) {
            throw new FormatException(TiffTools.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, short[] or Number[])");
        }
        return results;
    }

    public static String getComment(String id) throws FormatException, IOException {
        RandomAccessStream in = new RandomAccessStream(id);
        Hashtable ifd = TiffTools.getFirstIFD(in);
        in.close();
        Object o = TiffTools.getIFDValue(ifd, 270);
        String comment = null;
        if (o instanceof String) {
            comment = (String)o;
        } else if (o instanceof String[]) {
            String[] s = (String[])o;
            if (s.length > 0) {
                comment = s[0];
            }
        } else if (o != null) {
            comment = o.toString();
        }
        if (comment != null) {
            comment = comment.replaceAll("\r\n", "\n");
            comment = comment.replaceAll("\r", "\n");
        }
        return comment;
    }

    public static byte[][] getSamples(Hashtable ifd, RandomAccessStream in) throws FormatException, IOException {
        int samplesPerPixel = TiffTools.getSamplesPerPixel(ifd);
        int photoInterp = TiffTools.getPhotometricInterpretation(ifd);
        int bpp = TiffTools.getBitsPerSample(ifd)[0];
        while (bpp % 8 != 0) {
            ++bpp;
        }
        long width = TiffTools.getImageWidth(ifd);
        long length = TiffTools.getImageLength(ifd);
        byte[] b = new byte[(int)(width * length * (long)samplesPerPixel * (long)(bpp /= 8))];
        TiffTools.getSamples(ifd, in, b);
        byte[][] samples = new byte[samplesPerPixel][(int)(width * length * (long)bpp)];
        for (int i = 0; i < samplesPerPixel; ++i) {
            System.arraycopy(b, (int)((long)i * width * length * (long)bpp), samples[i], 0, samples[i].length);
        }
        b = null;
        return samples;
    }

    public static byte[] getSamples(Hashtable ifd, RandomAccessStream in, byte[] buf) throws FormatException, IOException {
        int i;
        boolean lastBitsZero;
        long maxValue;
        boolean littleEndian = TiffTools.isLittleEndian(ifd);
        in.order(littleEndian);
        long imageWidth = TiffTools.getImageWidth(ifd);
        long imageLength = TiffTools.getImageLength(ifd);
        int[] bitsPerSample = TiffTools.getBitsPerSample(ifd);
        int samplesPerPixel = TiffTools.getSamplesPerPixel(ifd);
        int compression = TiffTools.getCompression(ifd);
        int photoInterp = TiffTools.getPhotometricInterpretation(ifd);
        long[] stripOffsets = TiffTools.getStripOffsets(ifd);
        long[] stripByteCounts = TiffTools.getStripByteCounts(ifd);
        long[] rowsPerStripArray = TiffTools.getRowsPerStrip(ifd);
        boolean fakeByteCounts = stripByteCounts == null;
        boolean fakeRPS = rowsPerStripArray == null;
        boolean isTiled = stripOffsets == null;
        long[] maxes = TiffTools.getIFDLongArray(ifd, 281, false);
        long l = maxValue = maxes == null ? 0L : maxes[0];
        if (isTiled) {
            stripOffsets = TiffTools.getIFDLongArray(ifd, 324, true);
            stripByteCounts = TiffTools.getIFDLongArray(ifd, 325, true);
            rowsPerStripArray = new long[]{imageLength};
        } else if (fakeByteCounts) {
            stripByteCounts = new long[stripOffsets.length];
            if (stripByteCounts.length == 1) {
                stripByteCounts[0] = imageWidth * imageLength * (long)(bitsPerSample[0] / 8);
            } else {
                stripByteCounts[0] = stripOffsets[0];
                for (int i2 = 1; i2 < stripByteCounts.length; ++i2) {
                    stripByteCounts[i2] = stripOffsets[i2] - stripByteCounts[i2 - 1];
                }
            }
        }
        boolean bl = lastBitsZero = bitsPerSample[bitsPerSample.length - 1] == 0;
        if (fakeRPS && !isTiled) {
            int i3;
            rowsPerStripArray = new long[bitsPerSample.length];
            long temp = stripByteCounts[0];
            stripByteCounts = new long[bitsPerSample.length];
            for (i3 = 0; i3 < stripByteCounts.length; ++i3) {
                stripByteCounts[i3] = temp;
            }
            temp = bitsPerSample[0];
            if (temp == 0L) {
                temp = 8L;
            }
            bitsPerSample = new int[bitsPerSample.length];
            for (i3 = 0; i3 < bitsPerSample.length; ++i3) {
                bitsPerSample[i3] = (int)temp;
            }
            temp = stripOffsets[0];
            if (bitsPerSample[0] > 64) {
                byte[] bps = new byte[2];
                byte[] stripOffs = new byte[4];
                byte[] byteCounts = new byte[4];
                if (littleEndian) {
                    bps[0] = (byte)(bitsPerSample[0] & 0xFF);
                    bps[1] = (byte)(bitsPerSample[0] >>> 8 & 0xFF);
                    int ndx = stripOffsets.length - 1;
                    stripOffs[0] = (byte)(stripOffsets[ndx] & 0xFFL);
                    stripOffs[1] = (byte)(stripOffsets[ndx] >>> 8 & 0xFFL);
                    stripOffs[2] = (byte)(stripOffsets[ndx] >>> 16 & 0xFFL);
                    stripOffs[3] = (byte)(stripOffsets[ndx] >>> 24 & 0xFFL);
                    ndx = stripByteCounts.length - 1;
                    byteCounts[0] = (byte)(stripByteCounts[ndx] & 0xFFL);
                    byteCounts[1] = (byte)(stripByteCounts[ndx] >>> 8 & 0xFFL);
                    byteCounts[2] = (byte)(stripByteCounts[ndx] >>> 16 & 0xFFL);
                    byteCounts[3] = (byte)(stripByteCounts[ndx] >>> 24 & 0xFFL);
                } else {
                    bps[1] = (byte)(bitsPerSample[0] >>> 16 & 0xFF);
                    bps[0] = (byte)(bitsPerSample[0] >>> 24 & 0xFF);
                    stripOffs[3] = (byte)(stripOffsets[0] & 0xFFL);
                    stripOffs[2] = (byte)(stripOffsets[0] >>> 8 & 0xFFL);
                    stripOffs[1] = (byte)(stripOffsets[0] >>> 16 & 0xFFL);
                    stripOffs[0] = (byte)(stripOffsets[0] >>> 24 & 0xFFL);
                    byteCounts[3] = (byte)(stripByteCounts[0] & 0xFFL);
                    byteCounts[2] = (byte)(stripByteCounts[0] >>> 8 & 0xFFL);
                    byteCounts[1] = (byte)(stripByteCounts[0] >>> 16 & 0xFFL);
                    byteCounts[0] = (byte)(stripByteCounts[0] >>> 24 & 0xFFL);
                }
                bitsPerSample[0] = DataTools.bytesToInt(bps, !littleEndian);
                stripOffsets[0] = DataTools.bytesToInt(stripOffs, !littleEndian);
                stripByteCounts[0] = DataTools.bytesToInt(byteCounts, !littleEndian);
            }
            if (rowsPerStripArray.length == 1 && stripByteCounts[0] != imageWidth * imageLength * (long)(bitsPerSample[0] / 8) && compression == 1) {
                for (int i4 = 0; i4 < stripByteCounts.length; ++i4) {
                    stripByteCounts[i4] = imageWidth * imageLength * (long)(bitsPerSample[i4] / 8);
                    stripOffsets[0] = (int)(in.length() - stripByteCounts[0] - 48L * imageWidth);
                    if (i4 != 0) {
                        stripOffsets[i4] = stripOffsets[i4 - 1] + stripByteCounts[i4];
                    }
                    in.seek((int)stripOffsets[i4]);
                    in.read(buf, (int)((long)i4 * imageWidth), (int)imageWidth);
                    boolean isZero = true;
                    int j = 0;
                    while ((long)j < imageWidth) {
                        if (buf[(int)((long)i4 * imageWidth + (long)j)] != 0) {
                            isZero = false;
                            break;
                        }
                        ++j;
                    }
                    block7: while (isZero) {
                        int n = i4;
                        stripOffsets[n] = stripOffsets[n] - imageWidth;
                        in.seek((int)stripOffsets[i4]);
                        in.read(buf, (int)((long)i4 * imageWidth), (int)imageWidth);
                        j = 0;
                        while ((long)j < imageWidth) {
                            if (buf[(int)((long)i4 * imageWidth + (long)j)] != 0) {
                                isZero = false;
                                int n2 = i4;
                                stripOffsets[n2] = stripOffsets[n2] - (stripByteCounts[i4] - imageWidth);
                                continue block7;
                            }
                            ++j;
                        }
                    }
                }
            }
            for (int i5 = 0; i5 < bitsPerSample.length; ++i5) {
                if (i5 < bitsPerSample.length) {
                    if (i5 == samplesPerPixel) {
                        bitsPerSample[i5] = 0;
                        lastBitsZero = true;
                    }
                    if (bitsPerSample[i5] != 0) {
                        rowsPerStripArray[i5] = stripByteCounts[i5] / (imageWidth * (long)(bitsPerSample[i5] / 8));
                        continue;
                    }
                    if (bitsPerSample[i5] == 0 && i5 > 0) {
                        rowsPerStripArray[i5] = stripByteCounts[i5] / (imageWidth * (long)(bitsPerSample[i5 - 1] / 8));
                        bitsPerSample[i5] = bitsPerSample[i5 - 1];
                        continue;
                    }
                    throw new FormatException("BitsPerSample is 0");
                }
                if (i5 < bitsPerSample.length) continue;
                rowsPerStripArray[i5] = stripByteCounts[i5] / (imageWidth * (long)(bitsPerSample[bitsPerSample.length - 1] / 8));
            }
        }
        if (lastBitsZero) {
            bitsPerSample[bitsPerSample.length - 1] = 0;
        }
        TiffRational xResolution = TiffTools.getIFDRationalValue(ifd, 282, false);
        TiffRational yResolution = TiffTools.getIFDRationalValue(ifd, 283, false);
        int planarConfig = TiffTools.getIFDIntValue(ifd, 284, false, 1);
        int resolutionUnit = TiffTools.getIFDIntValue(ifd, 296, false, 2);
        if (xResolution == null || yResolution == null) {
            resolutionUnit = 0;
        }
        int[] colorMap = TiffTools.getIFDIntArray(ifd, 320, false);
        int predictor = TiffTools.getIFDIntValue(ifd, 317, false, 1);
        if (photoInterp == 6) {
            int[] tempColorMap = TiffTools.getIFDIntArray(ifd, 529, false);
            int[] refBlackWhite = TiffTools.getIFDIntArray(ifd, 532, false);
            colorMap = new int[tempColorMap.length + refBlackWhite.length];
            System.arraycopy(tempColorMap, 0, colorMap, 0, tempColorMap.length);
            System.arraycopy(refBlackWhite, 0, colorMap, tempColorMap.length, refBlackWhite.length);
        }
        for (int i6 = 0; i6 < samplesPerPixel; ++i6) {
            if (bitsPerSample[i6] < 1) {
                throw new FormatException("Illegal BitsPerSample (" + bitsPerSample[i6] + ")");
            }
            if (bitsPerSample[i6] % 2 == 0 || bitsPerSample[i6] == 1) continue;
            throw new FormatException("Sorry, unsupported BitsPerSample (" + bitsPerSample[i6] + ")");
        }
        if (bitsPerSample.length < samplesPerPixel) {
            throw new FormatException("BitsPerSample length (" + bitsPerSample.length + ") does not match SamplesPerPixel (" + samplesPerPixel + ")");
        }
        if (photoInterp == 4) {
            throw new FormatException("Sorry, Transparency Mask PhotometricInterpretation is not supported");
        }
        if (photoInterp == 6) {
            throw new FormatException("Sorry, YCbCr PhotometricInterpretation is not supported");
        }
        if (photoInterp == 8) {
            throw new FormatException("Sorry, CIELAB PhotometricInterpretation is not supported");
        }
        if (photoInterp != 0 && photoInterp != 1 && photoInterp != 2 && photoInterp != 3 && photoInterp != 5 && photoInterp != 6 && photoInterp != -32733) {
            throw new FormatException("Unknown PhotometricInterpretation (" + photoInterp + ")");
        }
        long rowsPerStrip = rowsPerStripArray[0];
        for (int i7 = 1; i7 < rowsPerStripArray.length; ++i7) {
            if (rowsPerStrip == rowsPerStripArray[i7]) continue;
            throw new FormatException("Sorry, non-uniform RowsPerStrip is not supported");
        }
        long numStrips = (imageLength + rowsPerStrip - 1L) / rowsPerStrip;
        if (isTiled || fakeRPS) {
            numStrips = stripOffsets.length;
        }
        if (planarConfig == 2) {
            numStrips *= (long)samplesPerPixel;
        }
        if ((long)stripOffsets.length < numStrips && !fakeRPS) {
            throw new FormatException("StripOffsets length (" + stripOffsets.length + ") does not match expected " + "number of strips (" + numStrips + ")");
        }
        if (fakeRPS) {
            numStrips = stripOffsets.length;
        }
        if ((long)stripByteCounts.length < numStrips) {
            throw new FormatException("StripByteCounts length (" + stripByteCounts.length + ") does not match expected " + "number of strips (" + numStrips + ")");
        }
        if (imageWidth > Integer.MAX_VALUE || imageLength > Integer.MAX_VALUE || imageWidth * imageLength > Integer.MAX_VALUE) {
            throw new FormatException("Sorry, ImageWidth x ImageLength > 2147483647 is not supported (" + imageWidth + " x " + imageLength + ")");
        }
        int numSamples = (int)(imageWidth * imageLength);
        if (planarConfig != 1 && planarConfig != 2) {
            throw new FormatException("Unknown PlanarConfiguration (" + planarConfig + ")");
        }
        if (photoInterp == -32733) {
            int[] tempMap = new int[colorMap.length + 2];
            System.arraycopy(colorMap, 0, tempMap, 0, colorMap.length);
            tempMap[tempMap.length - 2] = (int)imageWidth;
            tempMap[tempMap.length - 1] = (int)imageLength;
            colorMap = tempMap;
        }
        if (stripOffsets.length > 1 && stripOffsets[stripOffsets.length - 1] == stripOffsets[stripOffsets.length - 2]) {
            long[] tmp = stripOffsets;
            stripOffsets = new long[tmp.length - 1];
            System.arraycopy(tmp, 0, stripOffsets, 0, stripOffsets.length);
            --numStrips;
        }
        short[][] samples = new short[samplesPerPixel][numSamples];
        byte[] altBytes = new byte[]{};
        if (bitsPerSample[0] == 16) {
            boolean bl2 = littleEndian = !littleEndian;
        }
        if (isTiled) {
            long tileWidth = TiffTools.getIFDLongValue(ifd, 322, true, 0L);
            long tileLength = TiffTools.getIFDLongValue(ifd, 323, true, 0L);
            byte[] data = new byte[(int)(imageWidth * imageLength * (long)samplesPerPixel * (long)(bitsPerSample[0] / 8))];
            int row = 0;
            int col = 0;
            int bytes = bitsPerSample[0] / 8;
            for (int i8 = 0; i8 < stripOffsets.length; ++i8) {
                byte[] b = new byte[(int)stripByteCounts[i8]];
                in.seek(stripOffsets[i8]);
                in.read(b);
                b = TiffTools.uncompress(b, compression);
                int ext = (int)((long)b.length / (tileWidth * tileLength));
                int rowBytes = (int)(tileWidth * (long)ext);
                if (tileWidth + (long)col > imageWidth) {
                    rowBytes = (int)((imageWidth - (long)col) * (long)ext);
                }
                int j = 0;
                while ((long)j < tileLength && (long)(row + j) < imageLength) {
                    System.arraycopy(b, rowBytes * j, data, (int)((long)(row + j) * imageWidth * (long)ext + (long)(ext * col)), rowBytes);
                    ++j;
                }
                if ((long)(col += (int)tileWidth) < imageWidth) continue;
                row += (int)tileLength;
                col = 0;
            }
            TiffTools.undifference(data, bitsPerSample, imageWidth, planarConfig, predictor);
            TiffTools.unpackBytes(samples, 0, data, bitsPerSample, photoInterp, colorMap, littleEndian, maxValue, planarConfig, 0, 1, imageWidth);
        } else {
            int overallOffset = 0;
            int strip = 0;
            int row = 0;
            while ((long)strip < numStrips) {
                try {
                    in.seek((int)stripOffsets[strip]);
                    if (stripByteCounts[strip] > Integer.MAX_VALUE) {
                        throw new FormatException("Sorry, StripByteCounts > 2147483647 is not supported");
                    }
                    byte[] bytes = new byte[(int)stripByteCounts[strip]];
                    in.read(bytes);
                    if (compression != 32773) {
                        bytes = TiffTools.uncompress(bytes, compression);
                        TiffTools.undifference(bytes, bitsPerSample, imageWidth, planarConfig, predictor);
                        int offset = (int)(imageWidth * (long)row);
                        if (planarConfig == 2) {
                            offset = overallOffset / samplesPerPixel;
                        }
                        TiffTools.unpackBytes(samples, offset, bytes, bitsPerSample, photoInterp, colorMap, littleEndian, maxValue, planarConfig, strip, (int)numStrips, imageWidth);
                        overallOffset += bytes.length / bitsPerSample.length;
                    } else {
                        byte[] tempPackBits = new byte[altBytes.length];
                        System.arraycopy(altBytes, 0, tempPackBits, 0, altBytes.length);
                        altBytes = new byte[altBytes.length + bytes.length];
                        System.arraycopy(tempPackBits, 0, altBytes, 0, tempPackBits.length);
                        System.arraycopy(bytes, 0, altBytes, tempPackBits.length, bytes.length);
                    }
                }
                catch (Exception e) {
                    if (strip == 0) {
                        if (e instanceof FormatException) {
                            throw (FormatException)e;
                        }
                        throw new FormatException(e);
                    }
                    byte[] bytes = new byte[samples[0].length];
                    TiffTools.undifference(bytes, bitsPerSample, imageWidth, planarConfig, predictor);
                    int offset = (int)(imageWidth * (long)row);
                    if (planarConfig == 2) {
                        offset = overallOffset / samplesPerPixel;
                    }
                    TiffTools.unpackBytes(samples, offset, bytes, bitsPerSample, photoInterp, colorMap, littleEndian, maxValue, planarConfig, strip, (int)numStrips, imageWidth);
                    overallOffset += bytes.length / bitsPerSample.length;
                }
                ++strip;
                row = (int)((long)row + rowsPerStrip);
            }
        }
        if (altBytes.length != 0) {
            altBytes = TiffTools.uncompress(altBytes, compression);
            TiffTools.undifference(altBytes, bitsPerSample, imageWidth, planarConfig, predictor);
            TiffTools.unpackBytes(samples, (int)imageWidth, altBytes, bitsPerSample, photoInterp, colorMap, littleEndian, maxValue, planarConfig, 0, 1, imageWidth);
        }
        if (bitsPerSample[0] == 12) {
            bitsPerSample[0] = 16;
        }
        if (photoInterp == -32733) {
            samples = ImageTools.demosaic(samples, (int)imageWidth, (int)imageLength);
        }
        if (bitsPerSample[0] == 16) {
            int pt = 0;
            for (i = 0; i < samplesPerPixel; ++i) {
                for (int j = 0; j < numSamples; ++j) {
                    buf[pt++] = (byte)((samples[i][j] & 0xFF00) >> 8);
                    buf[pt++] = (byte)(samples[i][j] & 0xFF);
                }
            }
        } else if (bitsPerSample[0] == 32) {
            int pt = 0;
            for (i = 0; i < samplesPerPixel; ++i) {
                for (int j = 0; j < numSamples; ++j) {
                    buf[pt++] = (byte)((samples[i][j] & 0xFF000000) >> 24);
                    buf[pt++] = (byte)((samples[i][j] & 0xFF0000) >> 16);
                    buf[pt++] = (byte)((samples[i][j] & 0xFF00) >> 8);
                    buf[pt++] = (byte)(samples[i][j] & 0xFF);
                }
            }
        } else {
            for (int i9 = 0; i9 < samplesPerPixel; ++i9) {
                for (int j = 0; j < numSamples; ++j) {
                    buf[j + i9 * numSamples] = (byte)samples[i9][j];
                }
            }
        }
        return buf;
    }

    public static BufferedImage getImage(Hashtable ifd, RandomAccessStream in) throws FormatException, IOException {
        byte[][] samples = TiffTools.getSamples(ifd, in);
        int[] bitsPerSample = TiffTools.getBitsPerSample(ifd);
        long imageWidth = TiffTools.getImageWidth(ifd);
        long imageLength = TiffTools.getImageLength(ifd);
        int samplesPerPixel = TiffTools.getSamplesPerPixel(ifd);
        int photoInterp = TiffTools.getPhotometricInterpretation(ifd);
        if (bitsPerSample[0] == 16 || bitsPerSample[0] == 12) {
            int len = samples.length == 2 ? 3 : samples.length;
            short[][] sampleData = new short[len][samples[0].length / 2];
            for (int i = 0; i < samplesPerPixel; ++i) {
                ShortBuffer sampleBuf = ByteBuffer.wrap(samples[i]).asShortBuffer();
                sampleBuf.get(sampleData[i]);
            }
            return ImageTools.makeImage(sampleData, (int)imageWidth, (int)imageLength);
        }
        if (bitsPerSample[0] == 24) {
            int[][] intData = new int[samplesPerPixel][samples[0].length / 3];
            for (int i = 0; i < samplesPerPixel; ++i) {
                for (int j = 0; j < intData[i].length; ++j) {
                    intData[i][j] = DataTools.bytesToInt(samples[i], j * 3, 3, TiffTools.isLittleEndian(ifd));
                }
            }
            return ImageTools.makeImage(intData, (int)imageWidth, (int)imageLength);
        }
        if (bitsPerSample[0] == 32) {
            int type = TiffTools.getIFDIntValue(ifd, 339);
            if (type == 3) {
                float[][] floatData = new float[samplesPerPixel][samples[0].length / 4];
                for (int i = 0; i < samplesPerPixel; ++i) {
                    floatData[i] = (float[])DataTools.makeDataArray(samples[i], 4, true, TiffTools.isLittleEndian(ifd));
                }
                return ImageTools.makeImage(floatData, (int)imageWidth, (int)imageLength);
            }
            int[][] intData = new int[samplesPerPixel][samples[0].length / 4];
            for (int i = 0; i < samplesPerPixel; ++i) {
                IntBuffer sampleBuf = ByteBuffer.wrap(samples[i]).asIntBuffer();
                sampleBuf.get(intData[i]);
            }
            byte[][] shortData = new byte[samplesPerPixel][intData[0].length];
            for (int i = 0; i < samplesPerPixel; ++i) {
                for (int j = 0; j < shortData[0].length; ++j) {
                    shortData[i][j] = (byte)intData[i][j];
                }
            }
            return ImageTools.makeImage(shortData, (int)imageWidth, (int)imageLength);
        }
        if (samplesPerPixel == 1) {
            return ImageTools.makeImage(samples[0], (int)imageWidth, (int)imageLength, 1, false);
        }
        return ImageTools.makeImage(samples, (int)imageWidth, (int)imageLength);
    }

    public static void planarUnpack(short[][] samples, int startIndex, byte[] bytes, int[] bitsPerSample, int photoInterp, boolean littleEndian, int strip, int numStrips) throws FormatException {
        int numChannels = bitsPerSample.length;
        if (bitsPerSample[bitsPerSample.length - 1] == 0) {
            --numChannels;
        }
        int channelNum = strip / (numStrips / numChannels);
        startIndex = strip % (numStrips / numChannels) * bytes.length;
        int index = 0;
        int counter = 0;
        for (int j = 0; j < bytes.length; ++j) {
            int ndx;
            int numBytes = bitsPerSample[0] / 8;
            if (bitsPerSample[0] % 8 != 0) {
                int ndx2;
                if (index == bytes.length) {
                    --index;
                }
                int b = bytes[index];
                ++index;
                int offset = bitsPerSample[0] * (samples.length * j + channelNum) % 8;
                if (offset <= 8 - bitsPerSample[0] % 8) {
                    --index;
                }
                if (channelNum == 0) {
                    ++counter;
                }
                if (counter % 4 == 0 && channelNum == 0) {
                    ++index;
                }
                if ((ndx2 = startIndex + j) >= samples[channelNum].length) {
                    ndx2 = samples[channelNum].length - 1;
                }
                samples[channelNum][ndx2] = (short)(b < 0 ? 256 + b : b);
                if (photoInterp != 0 && photoInterp != 5) continue;
                samples[channelNum][ndx2] = (short)(Integer.MAX_VALUE - samples[channelNum][ndx2]);
                continue;
            }
            if (numBytes == 1) {
                float b = bytes[index];
                ++index;
                ndx = startIndex + j;
                if (ndx >= samples[channelNum].length) continue;
                samples[channelNum][ndx] = (short)(b < 0.0f ? 256.0f + b : b);
                if (photoInterp == 0) {
                    samples[channelNum][ndx] = (short)(65535 - samples[channelNum][ndx] & 0xFFFF);
                    continue;
                }
                if (photoInterp != 5) continue;
                samples[channelNum][ndx] = (short)(Integer.MAX_VALUE - samples[channelNum][ndx]);
                continue;
            }
            byte[] b = new byte[numBytes];
            if (numBytes + index < bytes.length) {
                System.arraycopy(bytes, index, b, 0, numBytes);
            } else {
                System.arraycopy(bytes, bytes.length - numBytes, b, 0, numBytes);
            }
            index += numBytes;
            ndx = startIndex + j;
            if (ndx >= samples[0].length) {
                ndx = samples[0].length - 1;
            }
            samples[channelNum][ndx] = (short)DataTools.bytesToLong(b, !littleEndian);
            if (photoInterp == 0) {
                long max = 1L;
                for (int q = 0; q < numBytes; ++q) {
                    max *= 8L;
                }
                samples[channelNum][ndx] = (short)(max - (long)samples[channelNum][ndx]);
                continue;
            }
            if (photoInterp != 5) continue;
            samples[channelNum][ndx] = (short)(Integer.MAX_VALUE - samples[channelNum][ndx]);
        }
    }

    public static void unpackBytes(short[][] samples, int startIndex, byte[] bytes, int[] bitsPerSample, int photoInterp, int[] colorMap, boolean littleEndian, long maxValue, int planar, int strip, int numStrips, long imageWidth) throws FormatException {
        boolean bps16;
        if (planar == 2) {
            TiffTools.planarUnpack(samples, startIndex, bytes, bitsPerSample, photoInterp, littleEndian, strip, numStrips);
            return;
        }
        int totalBits = 0;
        for (int i = 0; i < bitsPerSample.length; ++i) {
            totalBits += bitsPerSample[i];
        }
        int sampleCount = 8 * bytes.length / totalBits;
        if (startIndex + sampleCount > samples[0].length) {
            int trunc = startIndex + sampleCount - samples[0].length;
            sampleCount -= trunc;
        }
        int bps0 = bitsPerSample[0];
        int bpsPow = (int)Math.pow(2.0, bps0);
        int numBytes = bps0 / 8;
        boolean noDiv8 = bps0 % 8 != 0;
        boolean bps8 = bps0 == 8;
        boolean bl = bps16 = bps0 == 16;
        if (photoInterp == -32733) {
            imageWidth = colorMap[colorMap.length - 2];
        }
        int row = 0;
        int col = 0;
        if (imageWidth != 0L) {
            row = startIndex / (int)imageWidth;
        }
        int cw = 0;
        int ch = 0;
        if (photoInterp == -32733) {
            byte[] c = new byte[]{(byte)colorMap[0], (byte)colorMap[1]};
            cw = DataTools.bytesToInt(c, littleEndian);
            c[0] = (byte)colorMap[2];
            c[1] = (byte)colorMap[3];
            ch = DataTools.bytesToInt(c, littleEndian);
            int[] tmp = colorMap;
            colorMap = new int[tmp.length - 6];
            System.arraycopy(tmp, 4, colorMap, 0, colorMap.length);
        }
        int index = 0;
        int count = 0;
        BitBuffer bb = new BitBuffer(bytes);
        byte[] copyByteArray = new byte[numBytes];
        ByteBuffer nioBytes = MappedByteBuffer.wrap(bytes);
        if (!littleEndian) {
            nioBytes.order(ByteOrder.LITTLE_ENDIAN);
        }
        for (int j = 0; j < sampleCount; ++j) {
            for (int i = 0; i < samples.length; ++i) {
                int q;
                int ndx;
                if (noDiv8) {
                    ndx = startIndex + j;
                    short s = 0;
                    if (i == 0 && (photoInterp == -32733 || photoInterp == 3) || photoInterp != -32733 && photoInterp != 3) {
                        s = (short)bb.getBits(bps0);
                        if ((long)ndx % imageWidth == imageWidth - 1L) {
                            bb.skipBits(imageWidth * (long)bps0 * (long)sampleCount % 8L);
                        }
                    }
                    short b = s;
                    if (photoInterp != -32733) {
                        samples[i][ndx] = s;
                    }
                    if (photoInterp == 0 || photoInterp == 5) {
                        samples[i][ndx] = (short)(Integer.MAX_VALUE - samples[i][ndx]);
                        continue;
                    }
                    if (photoInterp != -32733 || i != 0) continue;
                    int pixelIndex = (int)((long)(row + count / cw) * imageWidth + (long)col + (long)(count % cw));
                    samples[colorMap[count]][pixelIndex] = s;
                    if (++count != colorMap.length) continue;
                    count = 0;
                    if ((long)(col += cw * ch) == imageWidth) {
                        col = cw;
                        continue;
                    }
                    if ((long)col <= imageWidth) continue;
                    row += ch;
                    col = 0;
                    continue;
                }
                if (bps8) {
                    int b = bytes[index] & 0xFF;
                    ++index;
                    int ndx2 = startIndex + j;
                    samples[i][ndx2] = (short)(b < 0 ? Integer.MAX_VALUE + b : b);
                    if (photoInterp == 0) {
                        samples[i][ndx2] = (short)(65535 - samples[i][ndx2] & 0xFFFF);
                        continue;
                    }
                    if (photoInterp == 5) {
                        samples[i][ndx2] = (short)(Integer.MAX_VALUE - samples[i][ndx2]);
                        continue;
                    }
                    if (photoInterp != 6 || i != bitsPerSample.length - 1) continue;
                    int lumaRed = colorMap[0];
                    int lumaGreen = colorMap[1];
                    int lumaBlue = colorMap[2];
                    int red = samples[2][ndx2] * (2 - 2 * lumaRed) + samples[0][ndx2];
                    int blue = samples[1][ndx2] * (2 - 2 * lumaBlue) + samples[0][ndx2];
                    int green = samples[0][ndx2] - lumaBlue * blue - lumaRed * red;
                    if (lumaGreen != 0) {
                        green /= lumaGreen;
                    }
                    samples[0][ndx2] = (short)(red - colorMap[4]);
                    samples[1][ndx2] = (short)(green - colorMap[6]);
                    samples[2][ndx2] = (short)(blue - colorMap[8]);
                    continue;
                }
                if (bps16) {
                    ndx = startIndex + j;
                    samples[i][ndx] = numBytes + index < bytes.length ? nioBytes.getShort(index) : nioBytes.getShort(bytes.length - numBytes);
                    index += numBytes;
                    if (photoInterp == 0) {
                        long max = 1L;
                        for (q = 0; q < numBytes; ++q) {
                            max *= 8L;
                        }
                        samples[i][ndx] = (short)(max - (long)samples[i][ndx]);
                        continue;
                    }
                    if (photoInterp != 5) continue;
                    samples[i][ndx] = (short)(Integer.MAX_VALUE - samples[i][ndx]);
                    continue;
                }
                if (numBytes + index < bytes.length) {
                    System.arraycopy(bytes, index, copyByteArray, 0, numBytes);
                } else {
                    System.arraycopy(bytes, bytes.length - numBytes, copyByteArray, 0, numBytes);
                }
                index += numBytes;
                ndx = startIndex + j;
                samples[i][ndx] = (short)DataTools.bytesToLong(copyByteArray, !littleEndian);
                if (photoInterp == 0) {
                    long max = 1L;
                    for (q = 0; q < numBytes; ++q) {
                        max *= 8L;
                    }
                    samples[i][ndx] = (short)(max - (long)samples[i][ndx]);
                    continue;
                }
                if (photoInterp != 5) continue;
                samples[i][ndx] = (short)(Integer.MAX_VALUE - samples[i][ndx]);
            }
        }
    }

    public static byte[] uncompress(byte[] input, int compression) throws FormatException, IOException {
        if (compression < 0) {
            compression += 65536;
        }
        if (compression == 1) {
            return input;
        }
        if (compression == 2) {
            throw new FormatException("Sorry, CCITT Group 3 1-Dimensional Modified Huffman run length encoding compression mode is not supported");
        }
        if (compression == 3) {
            throw new FormatException("Sorry, CCITT T.4 bi-level encoding (Group 3 Fax) compression mode is not supported");
        }
        if (compression == 4) {
            throw new FormatException("Sorry, CCITT T.6 bi-level encoding (Group 4 Fax) compression mode is not supported");
        }
        if (compression == 5) {
            return new LZWCodec().decompress(input);
        }
        if (compression == 7) {
            throw new FormatException("Sorry, JPEG compression mode is not supported");
        }
        if (compression == 32773) {
            return new PackbitsCodec().decompress(input);
        }
        if (compression == 32946 || compression == 8) {
            return new AdobeDeflateCodec().decompress(input);
        }
        if (compression == 32809) {
            throw new FormatException("Sorry, Thunderscan compression mode is not supported");
        }
        if (compression == 34713) {
            throw new FormatException("Sorry, Nikon compression mode is not supported; we hope to support it in the future");
        }
        if (compression == -1) {
            return new LuraWaveCodec().decompress(input);
        }
        throw new FormatException("Unknown Compression type (" + compression + ")");
    }

    public static void undifference(byte[] input, int[] bitsPerSample, long width, int planarConfig, int predictor) throws FormatException {
        if (predictor == 2) {
            int len = bitsPerSample.length;
            if (bitsPerSample[len - 1] == 0) {
                len = 1;
            }
            for (int b = 0; b < input.length; ++b) {
                if ((long)(b / len) % width == 0L) continue;
                int n = b;
                input[n] = (byte)(input[n] + input[b - len]);
            }
        } else if (predictor != 1) {
            throw new FormatException("Unknown Predictor (" + predictor + ")");
        }
    }

    public static void putIFDValue(Hashtable ifd, int tag, Object value) {
        ifd.put(new Integer(tag), value);
    }

    public static void putIFDValue(Hashtable ifd, int tag, short value) {
        TiffTools.putIFDValue(ifd, tag, new Short(value));
    }

    public static void putIFDValue(Hashtable ifd, int tag, int value) {
        TiffTools.putIFDValue(ifd, tag, new Integer(value));
    }

    public static void putIFDValue(Hashtable ifd, int tag, long value) {
        TiffTools.putIFDValue(ifd, tag, new Long(value));
    }

    public static void writeIFDValue(DataOutput ifdOut, ByteArrayOutputStream extraBuf, DataOutputStream extraOut, int offset, int tag, Object value) throws FormatException, IOException {
        if (value instanceof Short) {
            value = new short[]{(Short)value};
        } else if (value instanceof Integer) {
            value = new int[]{(Integer)value};
        } else if (value instanceof Long) {
            value = new long[]{(Long)value};
        } else if (value instanceof TiffRational) {
            value = new TiffRational[]{(TiffRational)value};
        } else if (value instanceof Float) {
            value = new float[]{((Float)value).floatValue()};
        } else if (value instanceof Double) {
            value = new double[]{(Double)value};
        }
        ifdOut.writeShort(tag);
        if (value instanceof short[]) {
            short[] q = (short[])value;
            ifdOut.writeShort(1);
            ifdOut.writeInt(q.length);
            if (q.length <= 4) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    ifdOut.writeByte(q[i]);
                }
                for (i = q.length; i < 4; ++i) {
                    ifdOut.writeByte(0);
                }
            } else {
                ifdOut.writeInt(offset + extraBuf.size());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte(q[i]);
                }
            }
        } else if (value instanceof String) {
            char[] q = ((String)value).toCharArray();
            ifdOut.writeShort(2);
            ifdOut.writeInt(q.length + 1);
            if (q.length < 4) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    ifdOut.writeByte(q[i]);
                }
                for (i = q.length; i < 4; ++i) {
                    ifdOut.writeByte(0);
                }
            } else {
                ifdOut.writeInt(offset + extraBuf.size());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte(q[i]);
                }
                extraOut.writeByte(0);
            }
        } else if (value instanceof int[]) {
            int[] q = (int[])value;
            ifdOut.writeShort(3);
            ifdOut.writeInt(q.length);
            if (q.length <= 2) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    ifdOut.writeShort(q[i]);
                }
                for (i = q.length; i < 2; ++i) {
                    ifdOut.writeShort(0);
                }
            } else {
                ifdOut.writeInt(offset + extraBuf.size());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeShort(q[i]);
                }
            }
        } else if (value instanceof long[]) {
            long[] q = (long[])value;
            ifdOut.writeShort(4);
            ifdOut.writeInt(q.length);
            if (q.length <= 1) {
                if (q.length == 1) {
                    ifdOut.writeInt((int)q[0]);
                } else {
                    ifdOut.writeInt(0);
                }
            } else {
                ifdOut.writeInt(offset + extraBuf.size());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeInt((int)q[i]);
                }
            }
        } else if (value instanceof TiffRational[]) {
            Object[] q = value;
            ifdOut.writeShort(5);
            ifdOut.writeInt(q.length);
            ifdOut.writeInt(offset + extraBuf.size());
            for (int i = 0; i < q.length; ++i) {
                extraOut.writeInt((int)((TiffRational)q[i]).getNumerator());
                extraOut.writeInt((int)((TiffRational)q[i]).getDenominator());
            }
        } else if (value instanceof float[]) {
            float[] q = (float[])value;
            ifdOut.writeShort(11);
            ifdOut.writeInt(q.length);
            if (q.length <= 1) {
                if (q.length == 1) {
                    ifdOut.writeFloat(q[0]);
                } else {
                    ifdOut.writeInt(0);
                }
            } else {
                ifdOut.writeInt(offset + extraBuf.size());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeFloat(q[i]);
                }
            }
        } else if (value instanceof double[]) {
            double[] q = (double[])value;
            ifdOut.writeShort(12);
            ifdOut.writeInt(q.length);
            ifdOut.writeInt(offset + extraBuf.size());
            for (int i = 0; i < q.length; ++i) {
                extraOut.writeDouble(q[i]);
            }
        } else {
            throw new FormatException("Unknown IFD value type (" + value.getClass().getName() + "): " + value);
        }
    }

    public static void overwriteIFDValue(RandomAccessFile raf, int ifd, int tag, Object value) throws FormatException, IOException {
        int i;
        byte[] header = new byte[4];
        raf.seek(0L);
        raf.readFully(header);
        if (!TiffTools.isValidHeader(header)) {
            throw new FormatException("Invalid TIFF header");
        }
        boolean little = header[0] == 73 && header[1] == 73;
        long offset = 4L;
        int num = 0;
        for (i = 0; i <= ifd; ++i) {
            offset = DataTools.read4UnsignedBytes(raf, little);
            if (offset <= 0L) {
                throw new FormatException("No such IFD (" + ifd + " of " + i + ")");
            }
            raf.seek(offset);
            num = DataTools.read2UnsignedBytes(raf, little);
            if (i >= ifd) continue;
            raf.seek(offset + 2L + (long)(12 * num));
        }
        for (i = 0; i < num; ++i) {
            int oldTag = DataTools.read2UnsignedBytes(raf, little);
            int oldType = DataTools.read2UnsignedBytes(raf, little);
            int oldCount = DataTools.read4SignedBytes(raf, little);
            int oldOffset = DataTools.read4SignedBytes(raf, little);
            if (oldTag != tag) continue;
            ByteArrayOutputStream ifdBuf = new ByteArrayOutputStream(14);
            DataOutputStream ifdOut = new DataOutputStream(ifdBuf);
            ByteArrayOutputStream extraBuf = new ByteArrayOutputStream();
            DataOutputStream extraOut = new DataOutputStream(extraBuf);
            TiffTools.writeIFDValue(ifdOut, extraBuf, extraOut, oldOffset, tag, value);
            byte[] bytes = ifdBuf.toByteArray();
            byte[] extra = extraBuf.toByteArray();
            int newTag = DataTools.bytesToInt(bytes, 0, 2, false);
            int newType = DataTools.bytesToInt(bytes, 2, 2, false);
            int newCount = DataTools.bytesToInt(bytes, 4, false);
            int newOffset = DataTools.bytesToInt(bytes, 8, false);
            boolean terminate = false;
            if (extra.length != 0) {
                if ((long)(oldOffset + oldCount * BYTES_PER_ELEMENT[oldType]) == raf.length()) {
                    newOffset = oldOffset;
                    terminate = true;
                } else {
                    newOffset = newCount <= oldCount ? oldOffset : (int)raf.length();
                }
            }
            raf.seek(raf.getFilePointer() - 10L);
            DataTools.writeShort(raf, newType, little);
            DataTools.writeInt(raf, newCount, little);
            DataTools.writeInt(raf, newOffset, little);
            if (extra.length > 0) {
                raf.seek(newOffset);
                raf.write(extra);
            }
            if (terminate) {
                raf.setLength(raf.getFilePointer());
            }
            return;
        }
        throw new FormatException("Tag not found (" + TiffTools.getIFDTagName(tag) + ")");
    }

    public static void overwriteComment(String id, Object value) throws FormatException, IOException {
        RandomAccessFile raf = new RandomAccessFile(id, "rw");
        TiffTools.overwriteIFDValue(raf, 0, 270, value);
        raf.close();
    }

    public static long writeImage(BufferedImage img, Hashtable ifd, OutputStream out, int offset, boolean last) throws FormatException, IOException {
        if (img == null) {
            throw new FormatException("Image is null");
        }
        Object values = ImageTools.getPixelBytes(img, false);
        int width = img.getWidth();
        int height = img.getHeight();
        if (((byte[][])values).length < 1 || ((byte[][])values).length > 3) {
            throw new FormatException("Image has an unsupported number of range components (" + ((byte[][])values).length + ")");
        }
        if (((byte[][])values).length == 2) {
            values = new byte[][]{values[0], values[1], new byte[values[0].length]};
        }
        int bytesPerPixel = values[0].length / (width * height);
        if (ifd == null) {
            ifd = new Hashtable();
        }
        TiffTools.putIFDValue(ifd, 256, width);
        TiffTools.putIFDValue(ifd, 257, height);
        if (TiffTools.getIFDValue(ifd, 258) == null) {
            int bps = 8 * bytesPerPixel;
            int[] bpsArray = new int[((byte[][])values).length];
            Arrays.fill(bpsArray, bps);
            TiffTools.putIFDValue(ifd, 258, bpsArray);
        }
        if (img.getRaster().getTransferType() == 4) {
            TiffTools.putIFDValue(ifd, 339, 3);
        }
        if (TiffTools.getIFDValue(ifd, 259) == null) {
            TiffTools.putIFDValue(ifd, 259, 1);
        }
        if (TiffTools.getIFDValue(ifd, 262) == null) {
            TiffTools.putIFDValue(ifd, 262, ((byte[][])values).length == 1 ? 1 : 2);
        }
        if (TiffTools.getIFDValue(ifd, 277) == null) {
            TiffTools.putIFDValue(ifd, 277, ((byte[][])values).length);
        }
        if (TiffTools.getIFDValue(ifd, 282) == null) {
            TiffTools.putIFDValue(ifd, 282, new TiffRational(1L, 1L));
        }
        if (TiffTools.getIFDValue(ifd, 283) == null) {
            TiffTools.putIFDValue(ifd, 283, new TiffRational(1L, 1L));
        }
        if (TiffTools.getIFDValue(ifd, 296) == null) {
            TiffTools.putIFDValue(ifd, 296, 1);
        }
        if (TiffTools.getIFDValue(ifd, 305) == null) {
            TiffTools.putIFDValue(ifd, 305, "LOCI Bio-Formats");
        }
        if (TiffTools.getIFDValue(ifd, 270) == null) {
            TiffTools.putIFDValue(ifd, 270, "");
        }
        int stripSize = 8192;
        int rowsPerStrip = stripSize / (width * bytesPerPixel);
        int stripsPerImage = (height + rowsPerStrip - 1) / rowsPerStrip;
        int[] bps = (int[])TiffTools.getIFDValue(ifd, 258, true, [I.class);
        ByteArrayOutputStream[] stripBuf = new ByteArrayOutputStream[stripsPerImage];
        DataOutputStream[] stripOut = new DataOutputStream[stripsPerImage];
        for (int i = 0; i < stripsPerImage; ++i) {
            stripBuf[i] = new ByteArrayOutputStream(stripSize);
            stripOut[i] = new DataOutputStream(stripBuf[i]);
        }
        for (int y = 0; y < height; ++y) {
            int strip = y / rowsPerStrip;
            for (int x = 0; x < width; ++x) {
                int ndx = y * width * bytesPerPixel + x * bytesPerPixel;
                for (int c = 0; c < ((byte[][])values).length; ++c) {
                    byte q = values[c][ndx];
                    if (bps[c] == 8) {
                        stripOut[strip].writeByte(q);
                        continue;
                    }
                    if (bps[c] == 16) {
                        stripOut[strip].writeByte(q);
                        stripOut[strip].writeByte(values[c][ndx + 1]);
                        continue;
                    }
                    if (bps[c] == 32) {
                        for (int i = 0; i < 4; ++i) {
                            stripOut[strip].writeByte(values[c][ndx + i]);
                        }
                        continue;
                    }
                    throw new FormatException("Unsupported bits per sample value (" + bps[c] + ")");
                }
            }
        }
        int planarConfig = TiffTools.getIFDIntValue(ifd, 284, false, 1);
        int predictor = TiffTools.getIFDIntValue(ifd, 317, false, 1);
        int compression = TiffTools.getIFDIntValue(ifd, 259, false, 1);
        byte[][] strips = new byte[stripsPerImage][];
        for (int i = 0; i < stripsPerImage; ++i) {
            strips[i] = stripBuf[i].toByteArray();
            TiffTools.difference(strips[i], bps, width, planarConfig, predictor);
            strips[i] = TiffTools.compress(strips[i], compression);
        }
        long[] stripByteCounts = new long[stripsPerImage];
        long[] stripOffsets = new long[stripsPerImage];
        TiffTools.putIFDValue(ifd, 273, stripOffsets);
        TiffTools.putIFDValue(ifd, 278, rowsPerStrip);
        TiffTools.putIFDValue(ifd, 279, stripByteCounts);
        Object[] keys = ifd.keySet().toArray();
        Arrays.sort(keys);
        int ifdBytes = 2 + 12 * keys.length + 4;
        long pixelBytes = 0L;
        for (int i = 0; i < stripsPerImage; ++i) {
            stripByteCounts[i] = strips[i].length;
            stripOffsets[i] = pixelBytes + (long)offset + (long)ifdBytes;
            pixelBytes += stripByteCounts[i];
        }
        ByteArrayOutputStream ifdBuf = new ByteArrayOutputStream(ifdBytes);
        DataOutputStream ifdOut = new DataOutputStream(ifdBuf);
        ByteArrayOutputStream extraBuf = new ByteArrayOutputStream();
        DataOutputStream extraOut = new DataOutputStream(extraBuf);
        offset = (int)((long)offset + ((long)ifdBytes + pixelBytes));
        ifdOut.writeShort(keys.length);
        for (int k = 0; k < keys.length; ++k) {
            Object key = keys[k];
            if (!(key instanceof Integer)) {
                throw new FormatException("Malformed IFD tag (" + key + ")");
            }
            if ((Integer)key == 0) continue;
            Object value = ifd.get(key);
            TiffTools.writeIFDValue(ifdOut, extraBuf, extraOut, offset, (Integer)key, value);
        }
        ifdOut.writeInt(last ? 0 : offset + extraBuf.size());
        byte[] ifdArray = ifdBuf.toByteArray();
        byte[] extraArray = extraBuf.toByteArray();
        long numBytes = ifdArray.length + extraArray.length;
        out.write(ifdArray);
        for (int i = 0; i < strips.length; ++i) {
            out.write(strips[i]);
            numBytes += (long)strips[i].length;
        }
        out.write(extraArray);
        return numBytes;
    }

    public static long getImageWidth(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDLongValue(ifd, 256, true, 0L);
    }

    public static long getImageLength(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDLongValue(ifd, 257, true, 0L);
    }

    public static int[] getBitsPerSample(Hashtable ifd) throws FormatException {
        int[] bitsPerSample = TiffTools.getIFDIntArray(ifd, 258, false);
        if (bitsPerSample == null) {
            bitsPerSample = new int[]{1};
        }
        return bitsPerSample;
    }

    public static int getSamplesPerPixel(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDIntValue(ifd, 277, false, 1);
    }

    public static int getCompression(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDIntValue(ifd, 259, false, 1);
    }

    public static int getPhotometricInterpretation(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDIntValue(ifd, 262, true, 0);
    }

    public static long[] getStripOffsets(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDLongArray(ifd, 273, false);
    }

    public static long[] getStripByteCounts(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDLongArray(ifd, 279, false);
    }

    public static long[] getRowsPerStrip(Hashtable ifd) throws FormatException {
        return TiffTools.getIFDLongArray(ifd, 278, false);
    }

    public static byte[] compress(byte[] input, int compression) throws FormatException, IOException {
        if (compression == 1) {
            return input;
        }
        if (compression == 2) {
            throw new FormatException("Sorry, CCITT Group 3 1-Dimensional Modified Huffman run length encoding compression mode is not supported");
        }
        if (compression == 3) {
            throw new FormatException("Sorry, CCITT T.4 bi-level encoding (Group 3 Fax) compression mode is not supported");
        }
        if (compression == 4) {
            throw new FormatException("Sorry, CCITT T.6 bi-level encoding (Group 4 Fax) compression mode is not supported");
        }
        if (compression == 5) {
            LZWCodec c = new LZWCodec();
            return c.compress(input, 0, 0, null, null);
        }
        if (compression == 7) {
            throw new FormatException("Sorry, JPEG compression mode is not supported");
        }
        if (compression == 32773) {
            throw new FormatException("Sorry, PackBits compression mode is not supported");
        }
        throw new FormatException("Unknown Compression type (" + compression + ")");
    }

    public static void difference(byte[] input, int[] bitsPerSample, long width, int planarConfig, int predictor) throws FormatException {
        if (predictor == 2) {
            for (int b = input.length - 1; b >= 0; --b) {
                if ((long)(b / bitsPerSample.length) % width == 0L) continue;
                int n = b;
                input[n] = (byte)(input[n] - input[b - bitsPerSample.length]);
            }
        } else if (predictor != 1) {
            throw new FormatException("Unknown Predictor (" + predictor + ")");
        }
    }

    public static void debug(String message) {
        LogTools.println(System.currentTimeMillis() + ": " + message);
    }
}

