/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.HashMap;
import visad.ContourQuad;
import visad.ContourStrip;
import visad.ContourStripSet;
import visad.Gridded3DSet;
import visad.VisADException;

class ContourQuadSet {
    int nx = 1;
    int ny = 1;
    int npx;
    int npy;
    int nc;
    int nr;
    int lev_idx;
    int numv = 0;
    ContourStripSet css = null;
    ContourQuad[][] qarray = null;
    int snumv = 0;
    public HashMap subGridMap = new HashMap();
    public HashMap subGrid2Map = new HashMap();
    public HashMap markGridMap = new HashMap();
    public HashMap markGrid2Map = new HashMap();

    ContourQuadSet(int nr, int nc, int lev_idx, ContourStripSet css) {
        this.nc = nc;
        this.nr = nr;
        this.lev_idx = lev_idx;
        this.css = css;
        if (css.contourDifficulty == 1) {
            this.nx = 20;
            this.ny = 20;
        } else {
            this.nx = 1;
            this.ny = 1;
        }
        this.npy = nr / this.ny;
        this.npx = nc / this.nx;
        this.qarray = new ContourQuad[this.ny][this.nx];
        for (int j = 0; j < this.ny; ++j) {
            for (int i = 0; i < this.nx; ++i) {
                int lenx = this.npx;
                int leny = this.npy;
                if (j == this.ny - 1) {
                    leny = nr - (this.ny - 1) * this.npy;
                }
                if (i == this.nx - 1) {
                    lenx = nc - (this.nx - 1) * this.npx;
                }
                this.qarray[j][i] = new ContourQuad(this, j * this.npy, i * this.npx, leny, lenx);
            }
        }
    }

    public void add(int idx0, int ir, int ic) {
        int ix = ic / this.npx;
        int iy = ir / this.npy;
        if (ix >= this.nx) {
            ix = this.nx - 1;
        }
        if (iy >= this.ny) {
            iy = this.ny - 1;
        }
        this.qarray[iy][ix].add(idx0, ir, ic);
    }

    public void get(float[] vx, float[] vy) {
        this.numv = 0;
        this.snumv = 0;
        for (int j = 0; j < this.ny; ++j) {
            for (int i = 0; i < this.nx; ++i) {
                ContourStrip[] c_strps = this.qarray[j][i].getContourStrips(vx, vy);
                this.numv += this.qarray[j][i].numv;
                this.snumv += this.qarray[j][i].stripCnt;
                if (c_strps == null) continue;
                this.css.vecArray[this.lev_idx].add(c_strps[0]);
            }
        }
    }

    public void getArrays(float[] vx, float[] vy, byte[][] auxLevels, float[][] vx1, float[][] vy1, float[][] vz1, byte[][] colors, Gridded3DSet spatial_set) throws VisADException {
        float[][] arrays = new float[2][2 * this.numv];
        int clr_dim = 3;
        if (auxLevels != null) {
            clr_dim = auxLevels.length;
            colors[0] = new byte[2 * this.numv];
            colors[1] = new byte[2 * this.numv];
            colors[2] = new byte[2 * this.numv];
            colors[3] = new byte[2 * this.numv];
        }
        int cnt = 0;
        for (int j = 0; j < this.ny; ++j) {
            for (int i = 0; i < this.nx; ++i) {
                for (int k = 0; k < this.qarray[j][i].numv; ++k) {
                    int vidx = this.qarray[j][i].vert_indices[k];
                    if (vidx < 0) continue;
                    arrays[0][cnt] = vx[vidx];
                    arrays[1][cnt] = vy[vidx];
                    if (auxLevels != null) {
                        colors[0][cnt] = auxLevels[0][vidx];
                        colors[1][cnt] = auxLevels[1][vidx];
                        colors[2][cnt] = auxLevels[2][vidx];
                        if (clr_dim == 4) {
                            colors[3][cnt] = auxLevels[3][vidx];
                        }
                    }
                    arrays[0][++cnt] = vx[vidx + 1];
                    arrays[1][cnt] = vy[vidx + 1];
                    if (auxLevels != null) {
                        colors[0][cnt] = auxLevels[0][vidx + 1];
                        colors[1][cnt] = auxLevels[1][vidx + 1];
                        colors[2][cnt] = auxLevels[2][vidx + 1];
                        if (clr_dim == 4) {
                            colors[3][cnt] = auxLevels[3][vidx];
                        }
                    }
                    ++cnt;
                }
            }
        }
        float[][] tmp = new float[2][cnt];
        System.arraycopy(arrays[0], 0, tmp[0], 0, cnt);
        System.arraycopy(arrays[1], 0, tmp[1], 0, cnt);
        float[][] tmp3D = spatial_set.gridToValue(tmp);
        vx1[0] = tmp3D[0];
        vy1[0] = tmp3D[1];
        vz1[0] = tmp3D[2];
        arrays = null;
        colors = null;
    }
}

