/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Vector;
import visad.ContourQuadSet;
import visad.ContourStrip;
import visad.Gridded3DSet;
import visad.PlotDigits;
import visad.VisADException;

class ContourStripSet {
    static final int DEFAULT_DASH_VALUE = 2;
    static final int DISABLE_DASH_VALUE = -1;
    int mxsize;
    float[] levels;
    int n_levs;
    int nr;
    int nc;
    Gridded3DSet spatial_set;
    Vector[] vecArray;
    Vector vec;
    PlotDigits[] plot_s;
    float[][] plot_min_max;
    boolean[] swap;
    ContourQuadSet[] qSet;
    int contourDifficulty = 0;

    ContourStripSet(int size, float[] levels, boolean[] swap, double scale_ratio, double label_size, int nr, int nc, Gridded3DSet spatial_set, int contourDifficulty) throws VisADException {
        int kk;
        this.mxsize = 40 * size;
        this.levels = levels;
        this.n_levs = levels.length;
        this.vecArray = new Vector[this.n_levs];
        this.plot_s = new PlotDigits[this.n_levs];
        this.plot_min_max = new float[this.n_levs][2];
        float fac = (float)(0.15 * (1.0 / scale_ratio) * label_size);
        this.nr = nr;
        this.nc = nc;
        this.swap = swap;
        this.spatial_set = spatial_set;
        this.contourDifficulty = contourDifficulty;
        for (kk = 0; kk < this.n_levs; ++kk) {
            this.vecArray[kk] = new Vector();
            PlotDigits plot = new PlotDigits();
            plot.Number = levels[kk];
            plot.plotdigits(levels[kk], 0.0f, 0.0f, fac * 1.0f, fac * 1.0f, 400, new boolean[]{false, false, false});
            float[][] tmp = new float[][]{plot.Vx, plot.Vy};
            plot.Vx = tmp[1];
            plot.Vy = tmp[0];
            tmp[0] = plot.VxB;
            tmp[1] = plot.VyB;
            plot.VxB = tmp[1];
            plot.VyB = tmp[0];
            float vx_min = Float.MAX_VALUE;
            float vy_min = Float.MAX_VALUE;
            float vx_max = -3.4028235E38f;
            float vy_max = -3.4028235E38f;
            float vxB_min = Float.MAX_VALUE;
            float vyB_min = Float.MAX_VALUE;
            float vxB_max = -3.4028235E38f;
            float vyB_max = -3.4028235E38f;
            for (int ii = 0; ii < plot.NumVerts; ++ii) {
                if (plot.Vx[ii] < vx_min) {
                    vx_min = plot.Vx[ii];
                }
                if (plot.Vy[ii] < vy_min) {
                    vy_min = plot.Vy[ii];
                }
                if (plot.Vx[ii] > vx_max) {
                    vx_max = plot.Vx[ii];
                }
                if (plot.Vy[ii] > vy_max) {
                    vy_max = plot.Vy[ii];
                }
                if (plot.VxB[ii] < vxB_min) {
                    vxB_min = plot.VxB[ii];
                }
                if (plot.VyB[ii] < vyB_min) {
                    vyB_min = plot.VyB[ii];
                }
                if (plot.VxB[ii] > vxB_max) {
                    vxB_max = plot.VxB[ii];
                }
                if (!(plot.VyB[ii] > vyB_max)) continue;
                vyB_max = plot.VyB[ii];
            }
            float t_x = (vx_max - vx_min) / 2.0f + vx_min;
            float t_y = (vy_max - vy_min) / 2.0f + vy_min;
            float t_xB = (vxB_max - vxB_min) / 2.0f + vxB_min;
            float t_yB = (vyB_max - vyB_min) / 2.0f + vyB_min;
            int ii = 0;
            while (ii < plot.NumVerts) {
                int n = ii;
                plot.Vx[n] = plot.Vx[n] - t_x;
                int n2 = ii;
                plot.Vy[n2] = plot.Vy[n2] - t_y;
                int n3 = ii;
                plot.VxB[n3] = plot.VxB[n3] - t_xB;
                int n4 = ii++;
                plot.VyB[n4] = plot.VyB[n4] - t_yB;
            }
            this.plot_s[kk] = plot;
            if (!swap[0]) {
                this.plot_min_max[kk][0] = vy_min;
                this.plot_min_max[kk][1] = vy_max;
            } else {
                this.plot_min_max[kk][0] = vx_min;
                this.plot_min_max[kk][1] = vx_max;
            }
            this.plot_min_max[kk][0] = vx_min;
            this.plot_min_max[kk][1] = vx_max;
        }
        this.qSet = new ContourQuadSet[this.n_levs];
        for (kk = 0; kk < this.n_levs; ++kk) {
            this.qSet[kk] = new ContourQuadSet(nr, nc, kk, this);
        }
    }

    void add(float[] vx, float[] vy, int idx0, int idx1, int lev_idx, int ir, int ic) {
        this.qSet[lev_idx].add(idx0, ir, ic);
    }

    void add(float[] vx, float[] vy, int idx0, int idx1, float level) {
        int lev_idx = 0;
        for (int kk = 0; kk < this.n_levs; ++kk) {
            if (level != this.levels[kk]) continue;
            lev_idx = kk;
        }
        this.add(vx, vy, idx0, idx1, lev_idx);
    }

    void add(float[] vx, float[] vy, int idx0, int idx1, int lev_idx) {
        this.vec = this.vecArray[lev_idx];
        int n_strip = this.vec.size();
        if (n_strip == 0) {
            ContourStrip c_strp = new ContourStrip(this.mxsize, lev_idx, idx0, idx1, this.plot_s[lev_idx], this);
            this.vec.addElement(c_strp);
        } else {
            int[] found_array = new int[3];
            int found = 0;
            for (int kk = 0; kk < n_strip; ++kk) {
                ContourStrip c_strp = (ContourStrip)this.vec.elementAt(kk);
                if (!c_strp.addPair(vx, vy, idx0, idx1)) continue;
                found_array[found] = kk;
                ++found;
            }
            if (found == 3) {
                ContourStrip c_strp = new ContourStrip(this.mxsize, lev_idx, idx0, idx1, this.plot_s[lev_idx], this);
                this.vec.addElement(c_strp);
            } else if (found == 2) {
                ContourStrip c_strpA = (ContourStrip)this.vec.elementAt(found_array[0]);
                ContourStrip c_strpB = (ContourStrip)this.vec.elementAt(found_array[1]);
                ContourStrip c_strp = c_strpA.merge(c_strpB);
                this.vec.addElement(c_strp);
                this.vec.removeElement(c_strpA);
                this.vec.removeElement(c_strpB);
            } else if (found == 0) {
                ContourStrip c_strp = new ContourStrip(this.mxsize, lev_idx, idx0, idx1, this.plot_s[lev_idx], this);
                this.vec.addElement(c_strp);
            }
        }
    }

    void getLineColorArrays(float[] vx, float[] vy, byte[][] colors, byte[] labelColor, int lev_idx, float[][][] out_vv, byte[][][] out_bb, float[][][][] out_vvL, byte[][][][] out_bbL, float[][][] out_loc, boolean[] dashed) {
        int kk;
        int tt;
        int mm;
        int n_strips = this.vecArray[lev_idx].size();
        float[][][][] la = new float[n_strips][2][][];
        byte[][][][] ca = new byte[n_strips][2][][];
        float[][][][][] laL = new float[n_strips][4][][][];
        byte[][][][][] caL = new byte[n_strips][4][][][];
        float[][][][] locL = new float[n_strips][3][][];
        for (int kk2 = 0; kk2 < n_strips; ++kk2) {
            ContourStrip cs = (ContourStrip)this.vecArray[lev_idx].elementAt(kk2);
            cs.dashed = dashed[lev_idx] ? 2 : -1;
            if (cs.hi_idx - cs.low_idx + 1 < 20) {
                cs.getInterpolatedLabeledColorArray(vx, vy, colors, labelColor, la[kk2], ca[kk2], laL[kk2], caL[kk2], locL[kk2]);
                continue;
            }
            cs.getLabeledLineColorArray(vx, vy, colors, labelColor, la[kk2], ca[kk2], laL[kk2], caL[kk2], locL[kk2]);
        }
        for (int tt2 = 0; tt2 < 2; ++tt2) {
            int mm2;
            int len = 0;
            for (int mm3 = 0; mm3 < n_strips; ++mm3) {
                if (la[mm3][tt2] == null) continue;
                len += la[mm3][tt2][0].length;
            }
            out_vv[tt2] = new float[3][len];
            int cnt = 0;
            for (mm = 0; mm < n_strips; ++mm) {
                if (la[mm][tt2] == null) continue;
                System.arraycopy(la[mm][tt2][0], 0, out_vv[tt2][0], cnt, la[mm][tt2][0].length);
                System.arraycopy(la[mm][tt2][1], 0, out_vv[tt2][1], cnt, la[mm][tt2][1].length);
                System.arraycopy(la[mm][tt2][2], 0, out_vv[tt2][2], cnt, la[mm][tt2][1].length);
                cnt += la[mm][tt2][0].length;
            }
            int clr_dim = 0;
            if (colors == null) continue;
            clr_dim = colors.length;
            len = 0;
            for (mm2 = 0; mm2 < n_strips; ++mm2) {
                if (ca[mm2][tt2] == null) continue;
                len += ca[mm2][tt2][0].length;
            }
            out_bb[tt2] = new byte[clr_dim][len];
            cnt = 0;
            for (mm2 = 0; mm2 < n_strips; ++mm2) {
                if (ca[mm2][tt2] == null) continue;
                for (int cc = 0; cc < clr_dim; ++cc) {
                    System.arraycopy(ca[mm2][tt2][cc], 0, out_bb[tt2][cc], cnt, ca[mm2][tt2][cc].length);
                }
                cnt += ca[mm2][tt2][0].length;
            }
        }
        int n_lbl = 0;
        for (int mm4 = 0; mm4 < n_strips; ++mm4) {
            if (laL[mm4][0] == null) continue;
            n_lbl += laL[mm4][0].length;
        }
        out_vvL[0] = new float[n_lbl][][];
        out_vvL[1] = new float[n_lbl][][];
        out_vvL[2] = new float[n_lbl][][];
        out_vvL[3] = new float[n_lbl][][];
        out_bbL[0] = new byte[n_lbl][][];
        out_bbL[1] = new byte[n_lbl][][];
        out_bbL[2] = new byte[n_lbl][][];
        out_bbL[3] = new byte[n_lbl][][];
        out_loc[0] = new float[n_lbl][];
        out_loc[1] = new float[n_lbl][];
        out_loc[2] = new float[n_lbl][];
        for (tt = 0; tt < 4; ++tt) {
            n_lbl = 0;
            for (kk = 0; kk < n_strips; ++kk) {
                if (laL[kk][tt] == null) continue;
                for (mm = 0; mm < laL[kk][tt].length; ++mm) {
                    out_vvL[tt][n_lbl] = laL[kk][tt][mm];
                    if (caL[kk][tt] != null) {
                        out_bbL[tt][n_lbl] = caL[kk][tt][mm];
                    }
                    ++n_lbl;
                }
            }
        }
        for (tt = 0; tt < 3; ++tt) {
            n_lbl = 0;
            for (kk = 0; kk < n_strips; ++kk) {
                if (locL[kk][0] == null) continue;
                for (mm = 0; mm < locL[kk][tt].length; ++mm) {
                    out_loc[tt][n_lbl] = locL[kk][tt][mm];
                    ++n_lbl;
                }
            }
        }
    }

    void getLineColorArrays(float[] vx, float[] vy, byte[][] colors, byte[] labelColor, float[][][] out_vv, byte[][][] out_bb, float[][][][] out_vvL, byte[][][][] out_bbL, float[][][] out_loc, boolean[] dashFlags, int contourDifficulty) {
        int ll;
        int cnt;
        int kk;
        int tt;
        if (contourDifficulty == 0) {
            this.makeContourStrips(vx, vy);
        } else {
            for (int kk2 = 0; kk2 < this.qSet.length; ++kk2) {
                this.qSet[kk2].get(vx, vy);
            }
        }
        float[][][][] tmp = new float[this.n_levs][2][][];
        byte[][][][] btmp = new byte[this.n_levs][2][][];
        float[][][][][] tmpL = new float[this.n_levs][4][][][];
        byte[][][][][] btmpL = new byte[this.n_levs][4][][][];
        float[][][][] tmpLoc = new float[this.n_levs][3][][];
        int n_lbl = 0;
        for (int kk3 = 0; kk3 < this.n_levs; ++kk3) {
            this.getLineColorArrays(vx, vy, colors, labelColor, kk3, tmp[kk3], btmp[kk3], tmpL[kk3], btmpL[kk3], tmpLoc[kk3], dashFlags);
            n_lbl += tmpL[kk3][0].length;
        }
        for (tt = 0; tt < 2; ++tt) {
            int kk4;
            int len = 0;
            for (kk = 0; kk < this.n_levs; ++kk) {
                len += tmp[kk][tt][0].length;
            }
            out_vv[tt] = new float[3][len];
            int cnt2 = 0;
            for (int kk5 = 0; kk5 < this.n_levs; ++kk5) {
                System.arraycopy(tmp[kk5][tt][0], 0, out_vv[tt][0], cnt2, tmp[kk5][tt][0].length);
                System.arraycopy(tmp[kk5][tt][1], 0, out_vv[tt][1], cnt2, tmp[kk5][tt][0].length);
                System.arraycopy(tmp[kk5][tt][2], 0, out_vv[tt][2], cnt2, tmp[kk5][tt][0].length);
                cnt2 += tmp[kk5][tt][0].length;
            }
            int clr_dim = 0;
            if (colors == null) continue;
            clr_dim = colors.length;
            len = 0;
            for (kk4 = 0; kk4 < this.n_levs; ++kk4) {
                len += btmp[kk4][tt][0].length;
            }
            out_bb[tt] = new byte[clr_dim][len];
            cnt2 = 0;
            for (kk4 = 0; kk4 < this.n_levs; ++kk4) {
                for (int cc = 0; cc < clr_dim; ++cc) {
                    System.arraycopy(btmp[kk4][tt][cc], 0, out_bb[tt][cc], cnt2, btmp[kk4][tt][cc].length);
                }
                cnt2 += btmp[kk4][tt][0].length;
            }
        }
        btmp = null;
        for (tt = 0; tt < 4; ++tt) {
            out_vvL[tt] = new float[n_lbl][][];
            cnt = 0;
            for (kk = 0; kk < this.n_levs; ++kk) {
                for (ll = 0; ll < tmpL[kk][tt].length; ++ll) {
                    out_vvL[tt][cnt] = tmpL[kk][tt][ll];
                    ++cnt;
                }
            }
            out_bbL[tt] = new byte[n_lbl][][];
            cnt = 0;
            for (kk = 0; kk < this.n_levs; ++kk) {
                for (ll = 0; ll < tmpL[kk][tt].length; ++ll) {
                    out_bbL[tt][cnt] = btmpL[kk][tt][ll];
                    ++cnt;
                }
            }
        }
        tmpL = null;
        btmpL = null;
        for (tt = 0; tt < 3; ++tt) {
            out_loc[tt] = new float[n_lbl][];
            cnt = 0;
            for (kk = 0; kk < this.n_levs; ++kk) {
                if (tmpLoc[kk][tt] == null) continue;
                for (ll = 0; ll < tmpLoc[kk][tt].length; ++ll) {
                    out_loc[tt][cnt] = tmpLoc[kk][tt][ll];
                    ++cnt;
                }
            }
        }
    }

    void makeContourStrips(float[] vx, float[] vy) {
        for (int kk = 0; kk < this.n_levs; ++kk) {
            int nx = this.qSet[kk].nx;
            int ny = this.qSet[kk].ny;
            for (int j = 0; j < ny; ++j) {
                for (int i = 0; i < nx; ++i) {
                    int[] vert_indices = this.qSet[kk].qarray[j][i].vert_indices;
                    int len = this.qSet[kk].qarray[j][i].numv;
                    for (int q = 0; q < len; ++q) {
                        int idx = vert_indices[q];
                        this.add(vx, vy, idx, idx + 1, kk);
                    }
                }
            }
        }
    }
}

