/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import visad.BaseUnit;
import visad.DerivedUnit;
import visad.PromiscuousUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.UnitException;

public final class OffsetUnit
extends Unit
implements Serializable {
    final ScaledUnit scaledUnit;
    final double offset;
    private static SimpleDateFormat dateFormat;
    private static double offsetUnitOrigin;
    private static Unit millisecond;

    public OffsetUnit(double offset) {
        this(offset, "");
    }

    public OffsetUnit(double offset, String identifier) {
        super(identifier);
        this.offset = offset;
        this.scaledUnit = new ScaledUnit(1.0);
    }

    public OffsetUnit(double offset, BaseUnit that) {
        this(offset, that, offset == 0.0 ? that.getIdentifier() : null);
    }

    public OffsetUnit(double offset, BaseUnit that, String identifier) {
        super(identifier);
        this.offset = offset;
        this.scaledUnit = new ScaledUnit(1.0, that);
    }

    public OffsetUnit(double offset, DerivedUnit that) {
        this(offset, that, offset == 0.0 ? that.getIdentifier() : null);
    }

    public OffsetUnit(double offset, DerivedUnit that, String identifier) {
        super(identifier);
        this.offset = offset;
        this.scaledUnit = new ScaledUnit(1.0, that);
    }

    public OffsetUnit(double offset, ScaledUnit that) {
        this(offset, that, offset == 0.0 ? that.getIdentifier() : null);
    }

    public OffsetUnit(double offset, ScaledUnit that, String identifier) {
        super(identifier);
        this.offset = offset;
        this.scaledUnit = that;
    }

    public OffsetUnit(double offset, OffsetUnit that) {
        this(offset, that, offset == 0.0 ? that.getIdentifier() : null);
    }

    public OffsetUnit(double offset, OffsetUnit that, String identifier) {
        super(identifier);
        this.offset = offset + that.offset;
        this.scaledUnit = that.scaledUnit;
    }

    public boolean isDimensionless() {
        return this.scaledUnit.isDimensionless();
    }

    protected boolean isTime() {
        return SI.second.isConvertible(this.scaledUnit);
    }

    protected Unit protectedClone(String identifier) {
        return new OffsetUnit(0.0, this, identifier);
    }

    public Unit pow(int power) {
        return this.scaledUnit.pow(power);
    }

    public Unit root(int root) throws IllegalArgumentException {
        return this.scaledUnit.root(root);
    }

    public Unit pow(double power) {
        return this.scaledUnit.pow(power);
    }

    public String getDefinition() {
        String definition;
        String scaledString = this.scaledUnit.toString();
        if (scaledString.indexOf(32) != -1) {
            scaledString = "(" + scaledString + ")";
        }
        if (!this.isTime()) {
            definition = scaledString + " @ " + this.offset;
        } else {
            try {
                definition = scaledString + " since " + dateFormat.format(new Date((long)(millisecond.toThis(this.offset, (Unit)this.scaledUnit) + offsetUnitOrigin)));
            }
            catch (UnitException e) {
                definition = e.toString();
            }
        }
        return definition;
    }

    public Unit multiply(Unit that) throws UnitException {
        return that.multiply(this.scaledUnit);
    }

    public Unit divide(Unit that) throws UnitException {
        return that.divideInto(this.scaledUnit);
    }

    protected Unit divideInto(Unit that) throws UnitException {
        return that.divide(this.scaledUnit);
    }

    public double[] toThis(double[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    public float[] toThis(float[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    public double[] toThis(double[] values, Unit that, boolean copy) throws UnitException {
        double[] newValues;
        if (this.equals(that) || that instanceof PromiscuousUnit) {
            newValues = copy ? (double[])values.clone() : values;
        } else {
            newValues = that.toThat(values, (Unit)this.scaledUnit, copy);
            for (int i = 0; i < newValues.length; ++i) {
                if (newValues[i] != newValues[i]) continue;
                int n = i;
                newValues[n] = newValues[n] - this.offset;
            }
        }
        return newValues;
    }

    public float[] toThis(float[] values, Unit that, boolean copy) throws UnitException {
        float[] newValues;
        if (this.equals(that) || that instanceof PromiscuousUnit) {
            newValues = copy ? (float[])values.clone() : values;
        } else {
            newValues = that.toThat(values, (Unit)this.scaledUnit, copy);
            for (int i = 0; i < newValues.length; ++i) {
                if (newValues[i] != newValues[i]) continue;
                int n = i;
                newValues[n] = (float)((double)newValues[n] - this.offset);
            }
        }
        return newValues;
    }

    public double[] toThat(double[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    public float[] toThat(float[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    public double[] toThat(double[] values, Unit that, boolean copy) throws UnitException {
        double[] newValues;
        double[] dArray = newValues = copy ? (double[])values.clone() : values;
        if (!this.equals(that) && !(that instanceof PromiscuousUnit)) {
            for (int i = 0; i < newValues.length; ++i) {
                if (newValues[i] != newValues[i]) continue;
                int n = i;
                newValues[n] = newValues[n] + this.offset;
            }
            newValues = that.toThis(newValues, (Unit)this.scaledUnit, copy);
        }
        return newValues;
    }

    public float[] toThat(float[] values, Unit that, boolean copy) throws UnitException {
        float[] newValues;
        float[] fArray = newValues = copy ? (float[])values.clone() : values;
        if (!this.equals(that) && !(that instanceof PromiscuousUnit)) {
            for (int i = 0; i < newValues.length; ++i) {
                if (newValues[i] != newValues[i]) continue;
                int n = i;
                newValues[n] = (float)((double)newValues[n] + this.offset);
            }
            newValues = that.toThis(newValues, (Unit)this.scaledUnit, copy);
        }
        return newValues;
    }

    public Unit getAbsoluteUnit() {
        return this.scaledUnit.getAbsoluteUnit();
    }

    public boolean isConvertible(Unit unit) {
        return this.scaledUnit.isConvertible(unit);
    }

    public static void main(String[] args) throws UnitException {
        BaseUnit degK = SI.kelvin;
        OffsetUnit degC = new OffsetUnit(273.15, degK);
        ScaledUnit degR = new ScaledUnit(0.5555555555555556, degK);
        OffsetUnit degF = new OffsetUnit(459.67, degR);
        Unit degF2 = ((Unit)degF).pow(2);
        System.out.println("degC=\"" + degC + "\"");
        System.out.println("degF=\"" + degF + "\"");
        System.out.println("degF.toThis(0,degC)=" + degF.toThis(0.0, (Unit)degC));
        System.out.println("degF.toThat(32,degC)=" + degF.toThat(32.0, (Unit)degC));
        double[] values = ((Unit)degF).toThis(new double[]{0.0, 100.0}, (Unit)degC);
        System.out.println("degF.toThis({0,100},degC)=" + values[0] + "," + values[1]);
        values = ((Unit)degF).toThat(new double[]{32.0, 212.0}, (Unit)degC);
        System.out.println("degF.toThat({32,212},degC)=" + values[0] + "," + values[1]);
        System.out.println("degF.pow(2)=" + ((Unit)degF).pow(2));
        System.out.println("degF.multiply(degC)=" + ((Unit)degF).multiply(degC));
        System.out.println("degC.multiply(degF)=" + ((Unit)degC).multiply(degF));
        System.out.println("degF.divide(degC)=" + ((Unit)degF).divide(degC));
        System.out.println("degC.divide(degF)=" + ((Unit)degC).divide(degF));
        System.out.println("degF2.pow(0.5)=" + degF2.pow(0.5));
        System.out.println("new OffsetUnit(0,SI.second).toString()=" + new OffsetUnit(0.0, SI.second).toString());
        System.out.println("new OffsetUnit(-1.8e9,SI.second).toString()=" + new OffsetUnit(-1.8E9, SI.second).toString());
    }

    public boolean equals(Unit unit) {
        return unit instanceof OffsetUnit && this.scaledUnit.equals(((OffsetUnit)unit).scaledUnit) && this.offset == ((OffsetUnit)unit).offset;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode ^= this.scaledUnit.hashCode() ^ new Double(this.offset).hashCode();
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    static {
        try {
            dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateFormat.applyPattern("yyyy-MM-dd HH:mm:ss.SSS 'UTC'");
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            calendar.clear();
            calendar.set(2001, 0, 1, 0, 0, 0);
            offsetUnitOrigin = calendar.getTime().getTime();
            millisecond = SI.second.scale(0.001).clone("ms");
        }
        catch (Exception e) {
            System.err.println("OffsetUnit.<clinit>: Couldn't initialize class: " + e);
            System.exit(1);
        }
    }
}

